/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.plugin.AbstractPluginModelBase;
import org.eclipse.pde.internal.core.plugin.AttributeChangedEvent;
import org.eclipse.pde.internal.core.plugin.PluginAttribute;
import org.eclipse.pde.internal.core.plugin.PluginElement;
import org.eclipse.pde.internal.core.plugin.PluginObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.ModelUndoManager;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageEditor;

public class PluginUndoManager
extends ModelUndoManager {
    AbstractPluginModelBase model;

    public PluginUndoManager(PDEMultiPageEditor editor) {
        super(editor);
        this.setUndoLevelLimit(30);
    }

    public void connect(IModelChangeProvider provider) {
        this.model = (AbstractPluginModelBase)provider;
        super.connect(provider);
    }

    protected String getPageId(Object obj) {
        if (obj instanceof IPluginBase) {
            return "OverviewPage";
        }
        if (obj instanceof IPluginImport) {
            return "DependenciesPage";
        }
        if (obj instanceof IPluginLibrary) {
            return "RuntimePage";
        }
        if (obj instanceof IPluginExtension || obj instanceof IPluginElement || obj instanceof IPluginAttribute) {
            return "ExtensionsPage";
        }
        if (obj instanceof IPluginExtensionPoint) {
            return "ExtensionPointPage";
        }
        return null;
    }

    protected void execute(IModelChangedEvent event, boolean undo) {
        Object[] elements = event.getChangedObjects();
        int type = event.getChangeType();
        String propertyName = event.getChangedProperty();
        switch (type) {
            case 1: {
                if (undo) {
                    this.executeRemove(elements);
                    break;
                }
                this.executeAdd(elements);
                break;
            }
            case 2: {
                if (undo) {
                    this.executeAdd(elements);
                    break;
                }
                this.executeRemove(elements);
                break;
            }
            case 3: {
                if (event instanceof AttributeChangedEvent) {
                    this.executeAttributeChange((AttributeChangedEvent)event, undo);
                    break;
                }
                if (undo) {
                    this.executeChange(elements[0], propertyName, event.getNewValue(), event.getOldValue());
                    break;
                }
                this.executeChange(elements[0], propertyName, event.getOldValue(), event.getNewValue());
            }
        }
    }

    private void executeAdd(Object[] elements) {
        IPluginBase pluginBase = this.model.getPluginBase();
        try {
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof IPluginImport) {
                    pluginBase.add((IPluginImport)element);
                } else if (element instanceof IPluginLibrary) {
                    pluginBase.add((IPluginLibrary)element);
                } else if (element instanceof IPluginExtensionPoint) {
                    pluginBase.add((IPluginExtensionPoint)element);
                } else if (element instanceof IPluginExtension) {
                    pluginBase.add((IPluginExtension)element);
                } else if (element instanceof IPluginElement) {
                    IPluginElement e = (IPluginElement)element;
                    IPluginParent p = (IPluginParent)e.getParent();
                    p.add((IPluginObject)e);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeRemove(Object[] elements) {
        IPluginBase pluginBase = this.model.getPluginBase();
        try {
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof IPluginImport) {
                    pluginBase.remove((IPluginImport)element);
                } else if (element instanceof IPluginLibrary) {
                    pluginBase.remove((IPluginLibrary)element);
                } else if (element instanceof IPluginExtensionPoint) {
                    pluginBase.remove((IPluginExtensionPoint)element);
                } else if (element instanceof IPluginExtension) {
                    pluginBase.remove((IPluginExtension)element);
                } else if (element instanceof IPluginElement) {
                    IPluginElement e = (IPluginElement)element;
                    IPluginParent p = (IPluginParent)e.getParent();
                    p.remove((IPluginObject)e);
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void executeAttributeChange(AttributeChangedEvent e, boolean undo) {
        PluginElement element = (PluginElement)e.getChangedObjects()[0];
        PluginAttribute att = (PluginAttribute)e.getChagedAttribute();
        Object oldValue = e.getOldValue();
        Object newValue = e.getNewValue();
        try {
            if (undo) {
                element.setAttribute(att.getName(), oldValue.toString());
            } else {
                element.setAttribute(att.getName(), newValue.toString());
            }
        }
        catch (CoreException ex) {
            PDEPlugin.logException(ex);
        }
    }

    private void executeChange(Object element, String propertyName, Object oldValue, Object newValue) {
        if (element instanceof PluginObject) {
            PluginObject pobj = (PluginObject)element;
            try {
                pobj.restoreProperty(propertyName, oldValue, newValue);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        IPluginObject obj;
        if (event.getChangeType() == 3 && !((obj = (IPluginObject)event.getChangedObjects()[0]) instanceof IPluginBase) && !obj.isInTheModel()) {
            return;
        }
        super.modelChanged(event);
    }
}

