/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestFormPage;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.update.ui.forms.internal.FormEntry;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.HyperlinkAdapter;
import org.eclipse.update.ui.forms.internal.IFormTextListener;
import org.eclipse.update.ui.forms.internal.IHyperlinkListener;
import org.eclipse.update.ui.forms.internal.SelectableFormLabel;

public class PluginSpecSection
extends PDEFormSection {
    public static final String SECTION_TITLE = "ManifestEditor.PluginSpecSection.title";
    public static final String SECTION_DESC = "ManifestEditor.PluginSpecSection.desc";
    public static final String SECTION_FDESC = "ManifestEditor.PluginSpecSection.fdesc";
    public static final String KEY_ID = "ManifestEditor.PluginSpecSection.id";
    public static final String KEY_FID = "ManifestEditor.PluginSpecSection.fid";
    public static final String KEY_NAME = "ManifestEditor.PluginSpecSection.name";
    public static final String KEY_FNAME = "ManifestEditor.PluginSpecSection.fname";
    public static final String KEY_VERSION = "ManifestEditor.PluginSpecSection.version";
    public static final String KEY_PROVIDER_NAME = "ManifestEditor.PluginSpecSection.providerName";
    public static final String KEY_PLUGIN_ID = "ManifestEditor.PluginSpecSection.pluginId";
    public static final String KEY_PLUGIN_ID_TOOLTIP = "ManifestEditor.PluginSpecSection.pluginId.tooltip";
    public static final String KEY_PLUGIN_VERSION = "ManifestEditor.PluginSpecSection.pluginVersion";
    public static final String KEY_CLASS = "ManifestEditor.PluginSpecSection.class";
    public static final String KEY_CLASS_TOOLTIP = "ManifestEditor.PluginSpecSection.class.tooltip";
    public static final String KEY_VERSION_FORMAT = "ManifestEditor.PluginSpecSection.versionFormat";
    public static final String KEY_VERSION_TITLE = "ManifestEditor.PluginSpecSection.versionTitle";
    public static final String KEY_MATCH = "ManifestEditor.PluginSpecSection.versionMatch";
    public static final String KEY_MATCH_PERFECT = "ManifestEditor.MatchSection.perfect";
    public static final String KEY_MATCH_EQUIVALENT = "ManifestEditor.MatchSection.equivalent";
    public static final String KEY_MATCH_COMPATIBLE = "ManifestEditor.MatchSection.compatible";
    public static final String KEY_MATCH_GREATER = "ManifestEditor.MatchSection.greater";
    private Text idText;
    private FormEntry titleText;
    private boolean updateNeeded;
    private boolean fragment;
    private FormEntry providerText;
    private FormEntry versionText;
    private FormEntry classText;
    private FormEntry pluginIdText;
    private FormEntry pluginVersionText;
    private CCombo matchCombo;

    public PluginSpecSection(ManifestFormPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        boolean fragment = ((ManifestEditor)page.getEditor()).isFragmentEditor();
        if (fragment) {
            this.setDescription(PDEPlugin.getResourceString(SECTION_FDESC));
        } else {
            this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        }
        this.setFragment(fragment);
    }

    public void commitChanges(boolean onSave) {
        this.titleText.commit();
        this.providerText.commit();
        this.versionText.commit();
        if (this.isFragment()) {
            this.pluginIdText.commit();
            this.pluginVersionText.commit();
        } else {
            this.classText.commit();
        }
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 2;
        layout.verticalSpacing = 7;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        String labelName = this.isFragment() ? PDEPlugin.getResourceString(KEY_FID) : PDEPlugin.getResourceString(KEY_ID);
        this.idText = this.createText(container, labelName, factory);
        this.idText.setEnabled(false);
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        final IPluginBase pluginBase = model.getPluginBase();
        labelName = this.isFragment() ? PDEPlugin.getResourceString(KEY_FNAME) : PDEPlugin.getResourceString(KEY_NAME);
        this.titleText = new FormEntry(this.createText(container, labelName, factory));
        this.titleText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    pluginBase.setName(text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
                String name = pluginBase.getName();
                name = pluginBase.getResourceString(name);
                if (!pluginBase.getModel().isEditable()) {
                    name = PDEPlugin.getFormattedMessage("ManifestEditor.readOnly", name);
                }
                PluginSpecSection.this.getFormPage().getForm().setHeadingText(name);
                ((ManifestEditor)PluginSpecSection.this.getFormPage().getEditor()).updateTitle();
            }

            public void textDirty(FormEntry text) {
                PluginSpecSection.this.forceDirty();
            }
        });
        this.versionText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(KEY_VERSION), factory));
        this.versionText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    PluginVersionIdentifier pvi = new PluginVersionIdentifier(text.getValue());
                    String formatted = pvi.toString();
                    text.setValue(formatted, true);
                    pluginBase.setVersion(formatted);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
                catch (Throwable throwable) {
                    String message = PDEPlugin.getResourceString(PluginSpecSection.KEY_VERSION_FORMAT);
                    MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString(PluginSpecSection.KEY_VERSION_TITLE), (String)message);
                    text.setValue(pluginBase.getVersion(), true);
                }
            }

            public void textDirty(FormEntry text) {
                PluginSpecSection.this.forceDirty();
            }
        });
        this.providerText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(KEY_PROVIDER_NAME), factory));
        this.providerText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    pluginBase.setProviderName(text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void textDirty(FormEntry text) {
                PluginSpecSection.this.forceDirty();
            }
        });
        if (this.isFragment()) {
            final IFragment fragment = (IFragment)pluginBase;
            SelectableFormLabel link = factory.createSelectableLabel(container, PDEPlugin.getResourceString(KEY_PLUGIN_ID));
            factory.turnIntoHyperlink((Control)link, (IHyperlinkListener)new HyperlinkAdapter(){

                public void linkActivated(Control link) {
                    PluginSpecSection.this.handleOpen();
                }
            });
            link.setToolTipText(PDEPlugin.getResourceString(KEY_PLUGIN_ID_TOOLTIP));
            this.pluginIdText = new FormEntry(this.createText(container, factory, 1));
            this.pluginIdText.addFormTextListener(new IFormTextListener(){

                public void textValueChanged(FormEntry text) {
                    try {
                        fragment.setPluginId(text.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }

                public void textDirty(FormEntry text) {
                    PluginSpecSection.this.forceDirty();
                }
            });
            factory.createLabel(container, PDEPlugin.getResourceString(KEY_PLUGIN_VERSION));
            this.pluginVersionText = new FormEntry(this.createText(container, factory, 1));
            this.pluginVersionText.addFormTextListener(new IFormTextListener(){

                public void textValueChanged(FormEntry text) {
                    try {
                        fragment.setPluginVersion(text.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }

                public void textDirty(FormEntry text) {
                    PluginSpecSection.this.forceDirty();
                }
            });
            factory.createLabel(container, PDEPlugin.getResourceString(KEY_MATCH));
            this.matchCombo = new CCombo(container, 0x800008);
            this.matchCombo.setBackground(factory.getBackgroundColor());
            this.matchCombo.setForeground(factory.getForegroundColor());
            GridData gd = new GridData(768);
            this.matchCombo.setLayoutData((Object)gd);
            String[] items = new String[]{"", PDEPlugin.getResourceString(KEY_MATCH_EQUIVALENT), PDEPlugin.getResourceString(KEY_MATCH_COMPATIBLE), PDEPlugin.getResourceString(KEY_MATCH_PERFECT), PDEPlugin.getResourceString(KEY_MATCH_GREATER)};
            this.matchCombo.setItems(items);
            this.matchCombo.pack();
            this.matchCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent event) {
                    int match = PluginSpecSection.this.matchCombo.getSelectionIndex();
                    try {
                        fragment.setRule(match);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            });
        } else {
            final IPlugin plugin = (IPlugin)pluginBase;
            if (model.isEditable()) {
                SelectableFormLabel link = factory.createSelectableLabel(container, PDEPlugin.getResourceString(KEY_CLASS));
                factory.turnIntoHyperlink((Control)link, (IHyperlinkListener)new HyperlinkAdapter(){

                    public void linkActivated(Control link) {
                        PluginSpecSection.this.handleOpen();
                    }
                });
                link.setToolTipText(PDEPlugin.getResourceString(KEY_CLASS_TOOLTIP));
            } else {
                factory.createLabel(container, PDEPlugin.getResourceString(KEY_CLASS));
            }
            this.classText = new FormEntry(this.createText(container, factory, 1));
            this.classText.addFormTextListener(new IFormTextListener(){

                public void textValueChanged(FormEntry text) {
                    try {
                        plugin.setClassName(text.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }

                public void textDirty(FormEntry text) {
                    PluginSpecSection.this.forceDirty();
                }
            });
            GridData gd = (GridData)this.classText.getControl().getLayoutData();
            gd.widthHint = 150;
        }
        factory.paintBordersFor(container);
        return container;
    }

    private void forceDirty() {
        this.setDirty(true);
        IModel model = (IModel)this.getFormPage().getModel();
        if (model instanceof IEditable) {
            IEditable editable = (IEditable)model;
            editable.setDirty(true);
            this.getFormPage().getEditor().fireSaveNeeded();
        }
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    private void handleOpen() {
        if (this.isFragment()) {
            this.handleOpenPlugin();
            return;
        }
        String name = this.classText.getControl().getText();
        IFile file = ((IFileEditorInput)this.getFormPage().getEditor().getEditorInput()).getFile();
        IProject project = file.getProject();
        IJavaProject javaProject = JavaCore.create((IProject)project);
        String path = String.valueOf(name.replace('.', '/')) + ".java";
        try {
            IJavaElement result = javaProject.findElement((IPath)new Path(path));
            if (result != null) {
                JavaUI.openInEditor((IJavaElement)result);
            }
        }
        catch (PartInitException partInitException) {
            Display.getCurrent().beep();
        }
        catch (JavaModelException javaModelException) {
            Display.getCurrent().beep();
        }
    }

    private void handleOpenPlugin() {
        IFragmentModel model = (IFragmentModel)this.getFormPage().getModel();
        String id = model.getFragment().getPluginId();
        if (id == null) {
            return;
        }
        ManifestEditor.openPluginEditor(id);
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        this.update(input);
        if (!model.isEditable()) {
            this.titleText.getControl().setEditable(false);
            this.versionText.getControl().setEditable(false);
            this.providerText.getControl().setEditable(false);
            if (this.isFragment()) {
                this.pluginVersionText.getControl().setEditable(false);
                this.pluginIdText.getControl().setEditable(false);
                this.matchCombo.setEnabled(false);
            } else {
                this.classText.getControl().setEditable(false);
            }
        }
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public boolean isDirty() {
        boolean baseDirty;
        boolean bl = baseDirty = this.titleText.isDirty() || this.providerText.isDirty() || this.versionText.isDirty();
        if (this.isFragment()) {
            return baseDirty || this.pluginVersionText.isDirty() || this.pluginIdText.isDirty();
        }
        return baseDirty || this.classText.isDirty();
    }

    public boolean isFragment() {
        return this.fragment;
    }

    public void modelChanged(IModelChangedEvent e) {
        Object obj;
        if (e.getChangeType() == 99) {
            this.updateNeeded = true;
        } else if (e.getChangeType() == 3 && (obj = e.getChangedObjects()[0]) instanceof IPluginBase) {
            this.updateNeeded = true;
            this.update();
        }
    }

    public void setFocus() {
        if (this.titleText != null) {
            this.titleText.getControl().setFocus();
        }
    }

    public void setFragment(boolean newFragment) {
        this.fragment = newFragment;
    }

    private void setIfDefined(FormEntry formText, String value) {
        if (value != null) {
            formText.setValue(value, true);
        }
    }

    private void setIfDefined(Text text, String value) {
        if (value != null) {
            text.setText(value);
        }
    }

    public void update() {
        if (this.updateNeeded) {
            this.update(this.getFormPage().getModel());
        }
    }

    public void update(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        IPluginBase pluginBase = model.getPluginBase();
        this.setIfDefined(this.titleText, pluginBase.getName());
        this.getFormPage().getForm().setHeadingText(pluginBase.getResourceString(pluginBase.getName()));
        ((ManifestEditor)this.getFormPage().getEditor()).updateTitle();
        this.setIfDefined(this.idText, pluginBase.getId());
        this.setIfDefined(this.versionText, pluginBase.getVersion());
        this.setIfDefined(this.providerText, pluginBase.getProviderName());
        if (this.isFragment()) {
            IFragment fragment = (IFragment)pluginBase;
            this.setIfDefined(this.pluginIdText, fragment.getPluginId());
            this.setIfDefined(this.pluginVersionText, fragment.getPluginVersion());
            this.matchCombo.select(fragment.getRule());
        } else {
            this.setIfDefined(this.classText, ((IPlugin)pluginBase).getClassName());
        }
        this.updateNeeded = false;
    }

    public boolean canPaste(Clipboard clipboard) {
        return clipboard.getContents((Transfer)TextTransfer.getInstance()) != null;
    }
}

