/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.builders.DependencyLoop;
import org.eclipse.pde.internal.builders.DependencyLoopFinder;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.util.StringMatcher;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.elements.NamedElement;
import org.eclipse.pde.internal.ui.preferences.MainPreferencePage;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewDependencyWizardPage
extends WizardPage {
    public static final String KEY_TITLE = "ManifestEditor.ImportListSection.new.title";
    public static final String KEY_DESC = "ManifestEditor.ImportListSection.new.desc";
    public static final String KEY_PLUGINS = "ManifestEditor.ImportListSection.new.label";
    public static final String KEY_FILTER = "ManifestEditor.ImportList.new.filter";
    public static final String KEY_WORKSPACE_PLUGINS = "AdvancedLauncherTab.workspacePlugins";
    public static final String KEY_EXTERNAL_PLUGINS = "AdvancedLauncherTab.externalPlugins";
    public static final String KEY_LOOP_WARNING = "ManifestEditor.ImportListSection.loopWarning";
    private IPluginModelBase modelBase;
    private CheckboxTreeViewer pluginTreeViewer;
    private Text filterText;
    private Image pluginImage;
    private Image errorPluginImage;
    private Image pluginsImage;
    private NamedElement workspacePlugins;
    private NamedElement externalPlugins;
    private Vector externalList;
    private Vector workspaceList;
    private Vector candidates = new Vector();
    private StringMatcher stringMatcher;

    public NewDependencyWizardPage(IPluginModelBase modelBase) {
        super("newDependencyPage");
        this.modelBase = modelBase;
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        provider.connect((Object)this);
        this.pluginImage = provider.get(PDEPluginImages.DESC_PLUGIN_OBJ);
        this.errorPluginImage = provider.get(PDEPluginImages.DESC_PLUGIN_OBJ, 1);
        this.pluginsImage = provider.get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ);
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        this.setPageComplete(false);
        this.stringMatcher = new StringMatcher("", true, false);
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_FILTER));
        this.filterText = new Text(container, 2052);
        this.filterText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String text = NewDependencyWizardPage.this.filterText.getText();
                if (text.indexOf(63) == -1 && text.indexOf(42) == -1) {
                    text = String.valueOf(text) + "*";
                }
                NewDependencyWizardPage.this.stringMatcher.setPattern(text);
                NewDependencyWizardPage.this.pluginTreeViewer.refresh();
            }
        });
        GridData gd = new GridData(768);
        this.filterText.setLayoutData((Object)gd);
        label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(KEY_PLUGINS));
        Control c = this.createPluginList(container);
        gd = new GridData(1808);
        c.setLayoutData((Object)gd);
        this.initialize();
        gd = (GridData)this.pluginTreeViewer.getControl().getLayoutData();
        gd.widthHint = 125;
        gd.heightHint = 250;
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.manifest_add_dependencies");
    }

    protected Control createPluginList(Composite parent) {
        this.pluginTreeViewer = new CheckboxTreeViewer(parent, 2048);
        this.pluginTreeViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.pluginTreeViewer.setLabelProvider((IBaseLabelProvider)new PluginLabelProvider());
        this.pluginTreeViewer.setSorter((ViewerSorter)new ListUtil.PluginSorter(){

            public int category(Object obj) {
                if (obj == NewDependencyWizardPage.this.workspacePlugins) {
                    return -1;
                }
                if (obj == NewDependencyWizardPage.this.externalPlugins) {
                    return 1;
                }
                return 0;
            }
        });
        this.pluginTreeViewer.setAutoExpandLevel(2);
        this.pluginTreeViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer v, Object parent, Object object) {
                if (object instanceof IPluginModel) {
                    String prefix;
                    IPluginModel model = (IPluginModel)object;
                    boolean include = model.isEnabled();
                    if (include) {
                        boolean bl = include = !NewDependencyWizardPage.this.isOnTheList(model);
                    }
                    if (include && (prefix = NewDependencyWizardPage.this.filterText.getText()).length() > 0) {
                        String name = MainPreferencePage.isFullNameModeEnabled() ? model.getPlugin().getName() : model.getPlugin().getId();
                        include = NewDependencyWizardPage.this.stringMatcher.match(name);
                    }
                    return include;
                }
                return true;
            }
        });
        this.pluginTreeViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                Object element = event.getElement();
                if (element instanceof IPluginModel) {
                    IPluginModel model = (IPluginModel)event.getElement();
                    NewDependencyWizardPage.this.handleCheckStateChanged(model, event.getChecked());
                } else {
                    NewDependencyWizardPage.this.pluginTreeViewer.setChecked(element, false);
                }
            }
        });
        this.pluginTreeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                Object item = ((IStructuredSelection)e.getSelection()).getFirstElement();
                if (item instanceof IPluginModel) {
                    NewDependencyWizardPage.this.pluginSelected((IPluginModel)item);
                } else {
                    NewDependencyWizardPage.this.pluginSelected(null);
                }
            }
        });
        this.workspacePlugins = new NamedElement(PDEPlugin.getResourceString(KEY_WORKSPACE_PLUGINS), this.pluginsImage);
        this.externalPlugins = new NamedElement(PDEPlugin.getResourceString(KEY_EXTERNAL_PLUGINS), this.pluginsImage);
        return this.pluginTreeViewer.getTree();
    }

    public void dispose() {
        super.dispose();
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
    }

    private boolean isOnTheList(IPluginModel candidate) {
        IPlugin plugin = candidate.getPlugin();
        if (!this.modelBase.isFragmentModel()) {
            IPlugin thisPlugin = (IPlugin)this.modelBase.getPluginBase();
            if (plugin.getId().equals(thisPlugin.getId())) {
                return true;
            }
        }
        IPluginImport[] imports = this.modelBase.getPluginBase().getImports();
        int i = 0;
        while (i < imports.length) {
            IPluginImport iimport = imports[i];
            if (iimport.getId().equals(plugin.getId())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Object[] getExternalPlugins() {
        return PDECore.getDefault().getExternalModelManager().getModels();
    }

    private Object[] getWorkspacePlugins() {
        return PDECore.getDefault().getWorkspaceModelManager().getWorkspacePluginModels();
    }

    public void init(IWorkbench workbench) {
    }

    private void initialize() {
        this.pluginTreeViewer.setInput((Object)PDEPlugin.getDefault());
        this.pluginTreeViewer.setGrayed((Object)this.workspacePlugins, true);
        this.pluginTreeViewer.setGrayed((Object)this.externalPlugins, true);
        this.pluginTreeViewer.reveal((Object)this.workspacePlugins);
    }

    private void pluginSelected(IPluginModel model) {
    }

    private void handleCheckStateChanged(IPluginModel candidate, boolean checked) {
        if (checked) {
            this.candidates.add(candidate);
        } else {
            this.candidates.remove(candidate);
        }
        this.setPageComplete(this.candidates.size() > 0);
        if (this.candidates.size() > 0) {
            IPlugin[] plugins = new IPlugin[this.candidates.size()];
            int i = 0;
            while (i < this.candidates.size()) {
                plugins[i] = ((IPluginModel)this.candidates.get(i)).getPlugin();
                ++i;
            }
            if (this.modelBase instanceof IPluginModel) {
                DependencyLoop[] loops = DependencyLoopFinder.findLoops((IPlugin)((IPlugin)this.modelBase.getPluginBase()), (IPlugin[])plugins, (boolean)true);
                if (loops.length > 0) {
                    this.setMessage(PDEPlugin.getResourceString(KEY_LOOP_WARNING), 2);
                } else {
                    this.setMessage(null);
                }
            }
        } else {
            this.setMessage(null);
        }
    }

    public boolean finish() {
        IPluginBase pluginBase = this.modelBase.getPluginBase();
        try {
            int i = 0;
            while (i < this.candidates.size()) {
                IPluginModel candidate = (IPluginModel)this.candidates.get(i);
                IPluginImport importNode = this.modelBase.getFactory().createImport();
                importNode.setId(candidate.getPlugin().getId());
                pluginBase.add(importNode);
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    class PluginLabelProvider
    extends LabelProvider {
        PluginLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof IPluginModel) {
                IPluginModel model = (IPluginModel)obj;
                return PDEPlugin.getDefault().getLabelProvider().getObjectText((IPluginBase)model.getPlugin());
            }
            return obj.toString();
        }

        public Image getImage(Object obj) {
            if (obj instanceof IPluginModel) {
                IPluginModel model = (IPluginModel)obj;
                return PDEPlugin.getDefault().getLabelProvider().getImage(model);
            }
            if (obj instanceof NamedElement) {
                return ((NamedElement)obj).getImage();
            }
            return null;
        }
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        PluginContentProvider() {
        }

        public boolean hasChildren(Object parent) {
            return !(parent instanceof IPluginModel);
        }

        public Object[] getChildren(Object parent) {
            if (parent == NewDependencyWizardPage.this.externalPlugins) {
                return NewDependencyWizardPage.this.getExternalPlugins();
            }
            if (parent == NewDependencyWizardPage.this.workspacePlugins) {
                return NewDependencyWizardPage.this.getWorkspacePlugins();
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            if (child instanceof IPluginModel) {
                IPluginModel model = (IPluginModel)child;
                if (model.getUnderlyingResource() != null) {
                    return NewDependencyWizardPage.this.workspacePlugins;
                }
                return NewDependencyWizardPage.this.externalPlugins;
            }
            return null;
        }

        public Object[] getElements(Object input) {
            return new Object[]{NewDependencyWizardPage.this.workspacePlugins, NewDependencyWizardPage.this.externalPlugins};
        }
    }
}

