/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.ui.editor.ModifiedTextPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public abstract class ManifestPropertySource
implements IPropertySource {
    protected IPluginObject object;

    public ManifestPropertySource(IPluginObject object) {
        this.object = object;
    }

    protected PropertyDescriptor createTextPropertyDescriptor(String name, String displayName) {
        if (this.isEditable()) {
            return new ModifiedTextPropertyDescriptor(name, displayName);
        }
        return new PropertyDescriptor((Object)name, displayName);
    }

    protected IJavaProject getJavaProject() {
        IProject project = this.getProject();
        return JavaCore.create((IProject)project);
    }

    protected IProject getProject() {
        IPluginModelBase model = this.object.getModel();
        IResource file = model.getUnderlyingResource();
        if (file != null) {
            return file.getProject();
        }
        return null;
    }

    public boolean isEditable() {
        return this.object.getModel().isEditable();
    }

    protected IPropertyDescriptor[] toDescriptorArray(Vector result) {
        Object[] array = new IPropertyDescriptor[result.size()];
        result.copyInto(array);
        return array;
    }

    public String getNonzeroValue(String value) {
        if (value != null) {
            return value;
        }
        return "";
    }

    public abstract Object getEditableValue();

    public abstract IPropertyDescriptor[] getPropertyDescriptors();

    public abstract Object getPropertyValue(Object var1);

    public abstract boolean isPropertySet(Object var1);

    public abstract void resetPropertyValue(Object var1);

    public abstract void setPropertyValue(Object var1, Object var2);
}

