/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.util.Vector;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestDependenciesPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestExtensionPointPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestExtensionsPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestFormPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestRuntimePage;
import org.eclipse.pde.internal.ui.preferences.MainPreferencePage;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.search.UnusedDependenciesAction;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.actions.ActionContext;

public class ManifestFormOutlinePage
extends FormOutlinePage {
    private Vector topics;
    private Image overviewPageImage;
    private Image runtimePageImage;
    private Image dependenciesPageImage;
    private Image extensionsPageImage;
    private Image extensionPointsPageImage;

    public ManifestFormOutlinePage(PDEFormPage formPage) {
        super(formPage);
        this.initializeImages();
    }

    private void initializeImages() {
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        this.overviewPageImage = provider.get(PDEPluginImages.DESC_OVERVIEW_OBJ);
        this.dependenciesPageImage = provider.get(PDEPluginImages.DESC_REQ_PLUGINS_OBJ);
        this.extensionsPageImage = provider.get(PDEPluginImages.DESC_EXTENSIONS_OBJ);
        this.extensionPointsPageImage = provider.get(PDEPluginImages.DESC_EXT_POINTS_OBJ);
        this.runtimePageImage = provider.get(PDEPluginImages.DESC_RUNTIME_OBJ);
    }

    protected ITreeContentProvider createContentProvider() {
        return new ContentProvider();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        IPluginModelBase model = (IPluginModelBase)this.formPage.getModel();
        model.addModelChangedListener((IModelChangedListener)this);
        this.createContextMenu();
    }

    private void createContextMenu() {
        MenuManager manager = new MenuManager();
        manager.setRemoveAllWhenShown(true);
        manager.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                this.contextMenuAboutToShow(manager);
            }

            private void contextMenuAboutToShow(IMenuManager manager) {
                IPluginModelBase model = ManifestFormOutlinePage.this.getPlugin().getModel();
                if (model instanceof WorkspacePluginModelBase) {
                    manager.add((IAction)new UnusedDependenciesAction((IPluginModelBase)((WorkspacePluginModelBase)model)));
                    manager.add((IContributionItem)new Separator());
                }
                PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
                actionGroup.setContext(new ActionContext(ManifestFormOutlinePage.this.getSelection()));
                actionGroup.fillContextMenu(manager);
            }
        });
        Menu menu = manager.createContextMenu(this.getControl());
        this.getControl().setMenu(menu);
    }

    protected ILabelProvider createLabelProvider() {
        return new OutlineLabelProvider();
    }

    public void dispose() {
        super.dispose();
        IPluginModelBase model = (IPluginModelBase)this.formPage.getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
    }

    String getObjectLabel(Object obj) {
        boolean fullNames = MainPreferencePage.isFullNameModeEnabled();
        if (obj instanceof IPluginImport) {
            String pluginId = ((IPluginImport)obj).getId();
            if (!fullNames || pluginId == null) {
                return this.preventNull(pluginId);
            }
            IPlugin plugin = PDECore.getDefault().findPlugin(pluginId);
            if (plugin != null) {
                return plugin.getResourceString(plugin.getName());
            }
            return pluginId;
        }
        if (obj instanceof IPluginLibrary) {
            return this.preventNull(((IPluginLibrary)obj).getName());
        }
        if (obj instanceof IPluginExtension) {
            IPluginExtension extension = (IPluginExtension)obj;
            if (!fullNames || extension.getPoint() == null) {
                return this.preventNull(extension.getPoint());
            }
            ISchema schema = PDECore.getDefault().getSchemaRegistry().getSchema(extension.getPoint());
            if (schema != null) {
                return schema.getName();
            }
            IPluginExtensionPoint pointInfo = PDECore.getDefault().getExternalModelManager().findExtensionPoint(extension.getPoint());
            if (pointInfo != null) {
                return pointInfo.getResourceString(pointInfo.getName());
            }
        }
        if (obj instanceof IPluginExtensionPoint) {
            IPluginExtensionPoint point = (IPluginExtensionPoint)obj;
            if (!fullNames || point.getId() == null) {
                return this.preventNull(point.getId());
            }
            return point.getTranslatedName();
        }
        return null;
    }

    private String preventNull(String name) {
        return name != null ? name : "";
    }

    private Image getPageImage(PDEFormPage page) {
        if (page instanceof ManifestFormPage) {
            return this.overviewPageImage;
        }
        if (page instanceof ManifestDependenciesPage) {
            return this.dependenciesPageImage;
        }
        if (page instanceof ManifestExtensionsPage) {
            return this.extensionsPageImage;
        }
        if (page instanceof ManifestExtensionPointPage) {
            return this.extensionPointsPageImage;
        }
        if (page instanceof ManifestRuntimePage) {
            return this.runtimePageImage;
        }
        return null;
    }

    public IPDEEditorPage getParentPage(Object item) {
        if (item instanceof IPluginImport) {
            return this.formPage.getEditor().getPage("DependenciesPage");
        }
        if (item instanceof IPluginExtension) {
            return this.formPage.getEditor().getPage("ExtensionsPage");
        }
        if (item instanceof IPluginExtensionPoint) {
            return this.formPage.getEditor().getPage("ExtensionPointPage");
        }
        if (item instanceof IPluginLibrary) {
            return this.formPage.getEditor().getPage("RuntimePage");
        }
        return super.getParentPage(item);
    }

    IPluginBase getPlugin() {
        IPluginModelBase model = (IPluginModelBase)this.formPage.getModel();
        return model.getPluginBase();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.treeViewer.refresh();
            this.treeViewer.expandAll();
            return;
        }
        Object object = event.getChangedObjects()[0];
        if (event.getChangeType() == 3) {
            String property = event.getChangedProperty();
            if (object instanceof IPluginBase && "extension_order".equals(property)) {
                this.treeViewer.refresh((Object)this.getParentPage(event.getOldValue()));
            } else {
                this.treeViewer.update(object, null);
            }
        } else {
            IPDEEditorPage parent = null;
            if (object instanceof IPluginExtension || object instanceof IPluginExtensionPoint || object instanceof IPluginLibrary || object instanceof IPluginImport) {
                parent = this.getParentPage(object);
            } else if (object instanceof IPluginObject) {
                parent = ((IPluginObject)object).getParent();
            }
            if (parent != null) {
                if (event.getChangeType() == 1) {
                    this.treeViewer.add((Object)parent, event.getChangedObjects());
                } else {
                    this.treeViewer.remove(event.getChangedObjects());
                }
            } else {
                this.treeViewer.refresh();
                this.treeViewer.expandAll();
            }
        }
    }

    class ContentProvider
    extends FormOutlinePage.BasicContentProvider {
        ContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof ManifestExtensionsPage) {
                return ManifestFormOutlinePage.this.getPlugin().getExtensions();
            }
            if (parent instanceof ManifestExtensionPointPage) {
                return ManifestFormOutlinePage.this.getPlugin().getExtensionPoints();
            }
            if (parent instanceof ManifestDependenciesPage) {
                return ManifestFormOutlinePage.this.getPlugin().getImports();
            }
            if (parent instanceof ManifestRuntimePage) {
                return ManifestFormOutlinePage.this.getPlugin().getLibraries();
            }
            return super.getChildren(parent);
        }

        public Object getParent(Object child) {
            return super.getParent(child);
        }
    }

    class OutlineLabelProvider
    extends FormOutlinePage.BasicLabelProvider {
        OutlineLabelProvider() {
        }

        public String getText(Object obj) {
            String label = ManifestFormOutlinePage.this.getObjectLabel(obj);
            if (label != null) {
                return label;
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
            Image image = provider.getImage(obj);
            if (image != null) {
                return image;
            }
            if (obj instanceof PDEFormPage && (image = ManifestFormOutlinePage.this.getPageImage((PDEFormPage)obj)) != null) {
                return image;
            }
            return super.getImage(obj);
        }
    }
}

