/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangeProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.plugin.ExternalFragmentModel;
import org.eclipse.pde.internal.core.plugin.ExternalPluginModel;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IModelUndoManager;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageXMLEditor;
import org.eclipse.pde.internal.ui.editor.SystemFileEditorInput;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestDependenciesPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestExtensionPointPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestExtensionsPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestFormOutlinePage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestFormPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestRuntimePage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestSourcePageNew;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestTemplatePage;
import org.eclipse.pde.internal.ui.editor.manifest.PartiallySynchronizedDocument;
import org.eclipse.pde.internal.ui.editor.manifest.PluginUndoManager;
import org.eclipse.pde.internal.ui.editor.manifest.SynchronizedStorageDocumentProvider;
import org.eclipse.pde.internal.ui.editor.manifest.SynchronizedSystemFileDocumentProvider;
import org.eclipse.pde.internal.ui.wizards.templates.TemplateEditorInput;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.part.FileEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ManifestEditor
extends PDEMultiPageXMLEditor
implements IPropertyChangeListener {
    public static final String TEMPLATE_PAGE = "TemplatePage";
    public static final String OVERVIEW_PAGE = "OverviewPage";
    public static final String EXTENSIONS_PAGE = "ExtensionsPage";
    public static final String RUNTIME_PAGE = "RuntimePage";
    public static final String EXTENSION_POINT_PAGE = "ExtensionPointPage";
    public static final String DEPENDENCIES_PAGE = "DependenciesPage";
    public static final String SOURCE_PAGE = "SourcePage";
    public static final String KEY_TEMPLATE = "ManifestEditor.TemplatePage.title";
    public static final String KEY_OVERVIEW = "ManifestEditor.OverviewPage.title";
    public static final String KEY_DEPENDENCIES = "ManifestEditor.DependenciesPage.title";
    public static final String KEY_RUNTIME = "ManifestEditor.RuntimePage.title";
    public static final String KEY_READ_ONLY = "ManifestEditor.readOnly";
    public static final String KEY_EXTENSIONS = "ManifestEditor.ExtensionsPage.title";
    public static final String KEY_EXTENSION_POINTS = "ManifestEditor.ExtensionPointsPage.title";
    public static final String NO_PLATFORM_HOME = "ManifestEditor.noPlatformHome";
    private boolean storageModel = false;

    public ManifestEditor() {
        PDEPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
    }

    private void checkPlatformHome() throws PartInitException {
        Preferences preferences = PDECore.getDefault().getPluginPreferences();
        String home = preferences.getString("platform_path");
        if (home == null || home.length() == 0) {
            throw new PartInitException(PDEPlugin.getResourceString(NO_PLATFORM_HOME));
        }
    }

    private IPluginModelBase createFileSystemModel(File file) {
        boolean fragment = file.getName().toLowerCase().equals("fragment.xml");
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            PDEPlugin.logException(e);
            return null;
        }
        Object model = null;
        model = fragment ? new ExternalFragmentModel() : new ExternalPluginModel();
        String parentPath = file.getParentFile().getAbsolutePath();
        model.setInstallLocation("file:" + parentPath);
        try {
            model.load((InputStream)stream, false);
        }
        catch (CoreException coreException) {
            return null;
        }
        try {
            ((InputStream)stream).close();
        }
        catch (IOException iOException) {}
        return model;
    }

    private IPluginModelBase createStorageModel(IStorage storage) {
        String lname = storage.getName().toLowerCase();
        boolean fragment = lname.startsWith("fragment.xml");
        InputStream stream = null;
        try {
            stream = storage.getContents();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
            return null;
        }
        Object model = null;
        model = fragment ? new ExternalFragmentModel() : new ExternalPluginModel();
        model.setInstallLocation("");
        try {
            model.load(stream, false);
        }
        catch (CoreException coreException) {
            return null;
        }
        try {
            stream.close();
        }
        catch (IOException iOException) {}
        this.storageModel = true;
        return model;
    }

    protected Object createModel(Object input) throws CoreException {
        if (input instanceof IFile) {
            return this.createResourceModel((IFile)input);
        }
        if (input instanceof IStorage) {
            return this.createStorageModel((IStorage)input);
        }
        if (input instanceof File) {
            return this.createFileSystemModel((File)input);
        }
        return null;
    }

    protected IModelUndoManager createModelUndoManager() {
        return new PluginUndoManager(this);
    }

    protected void createPages() {
        this.firstPageId = OVERVIEW_PAGE;
        this.formWorkbook.setFirstPageSelected(false);
        ManifestFormPage formPage = new ManifestFormPage(this, PDEPlugin.getResourceString(KEY_OVERVIEW));
        this.addPage(OVERVIEW_PAGE, formPage);
        this.addPage(DEPENDENCIES_PAGE, new ManifestDependenciesPage(formPage, PDEPlugin.getResourceString(KEY_DEPENDENCIES)));
        this.addPage(RUNTIME_PAGE, new ManifestRuntimePage(formPage, PDEPlugin.getResourceString(KEY_RUNTIME)));
        this.addPage(EXTENSIONS_PAGE, new ManifestExtensionsPage(formPage, PDEPlugin.getResourceString(KEY_EXTENSIONS)));
        this.addPage(EXTENSION_POINT_PAGE, new ManifestExtensionPointPage(formPage, PDEPlugin.getResourceString(KEY_EXTENSION_POINTS)));
        this.addPage(SOURCE_PAGE, new ManifestSourcePageNew(this));
    }

    private void addTemplatePage(IProject project) {
        IFile templateFile = project.getFile(".template");
        if (!templateFile.exists()) {
            return;
        }
        ManifestFormPage parent = (ManifestFormPage)this.getPage(OVERVIEW_PAGE);
        ManifestTemplatePage page = new ManifestTemplatePage(parent, PDEPlugin.getResourceString(KEY_TEMPLATE), templateFile);
        this.addPage(TEMPLATE_PAGE, page, 0);
    }

    private IPluginModelBase createResourceModel(IFile file) throws CoreException {
        InputStream stream = null;
        stream = file.getContents(false);
        WorkspaceModelManager modelProvider = PDECore.getDefault().getWorkspaceModelManager();
        modelProvider.connect((Object)file, (Object)this);
        WorkspacePluginModelBase model = (WorkspacePluginModelBase)modelProvider.getModel((Object)file, (Object)this);
        try {
            model.load(stream, false);
        }
        catch (CoreException coreException) {}
        String buildName = "build.properties";
        IPath buildPath = file.getProject().getFullPath().append(buildName);
        IFile buildFile = file.getWorkspace().getRoot().getFile(buildPath);
        modelProvider.connect((Object)buildFile, (Object)this);
        IBuildModel buildModel = (IBuildModel)modelProvider.getModel((Object)buildFile, (Object)this);
        try {
            buildModel.load();
        }
        catch (CoreException coreException) {}
        model.setBuildModel(buildModel);
        try {
            stream.close();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        return model;
    }

    public void dispose() {
        super.dispose();
        IPluginModelBase model = (IPluginModelBase)this.getModel();
        WorkspaceModelManager modelProvider = PDECore.getDefault().getWorkspaceModelManager();
        if (model instanceof WorkspacePluginModelBase) {
            IBuildModel buildModel = model.getBuildModel();
            modelProvider.disconnect((Object)buildModel.getUnderlyingResource(), (Object)this);
            ((WorkspacePluginModelBase)model).setBuildModel(null);
            modelProvider.disconnect((Object)model.getUnderlyingResource(), (Object)this);
        } else {
            model.dispose();
        }
        PDEPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
    }

    public IPDEEditorPage getHomePage() {
        return this.getPage(OVERVIEW_PAGE);
    }

    protected String getSourcePageId() {
        return SOURCE_PAGE;
    }

    public String getTitle() {
        if (!this.isModelCorrect(this.getModel())) {
            return super.getTitle();
        }
        IPluginModelBase model = (IPluginModelBase)this.getModel();
        String name = model.getPluginBase().getName();
        if (name == null) {
            return super.getTitle();
        }
        String value = model.getResourceString(name);
        if (value.startsWith("%")) {
            return super.getTitle();
        }
        return value;
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.checkPlatformHome();
        if (input instanceof TemplateEditorInput) {
            this.firstPageId = ((TemplateEditorInput)input).getFirstPageId();
        }
        if (input instanceof IFileEditorInput) {
            IFile file = ((IFileEditorInput)input).getFile();
            IProject project = file.getProject();
            this.addTemplatePage(project);
        }
        super.init(site, input);
    }

    public boolean isFragmentEditor() {
        return false;
    }

    protected boolean isModelCorrect(Object model) {
        return model != null ? ((IPluginModelBase)model).isValid() : false;
    }

    protected boolean isModelDirty(Object model) {
        return model != null && model instanceof IEditable && model instanceof IModel && ((IModel)model).isEditable() && ((IEditable)model).isDirty();
    }

    protected boolean isValidContentType(IEditorInput input) {
        String name = input.getName().toLowerCase();
        return input instanceof IStorageEditorInput && !(input instanceof IFileEditorInput) ? (this.isFragmentEditor() ? name.startsWith("fragment.xml") : name.startsWith("plugin.xml")) : (this.isFragmentEditor() ? name.equals("fragment.xml") : name.equals("plugin.xml"));
    }

    private static ManifestEditor openExternalPlugin(IPluginBase pluginInfo) {
        boolean isFragment = pluginInfo.getModel().isFragmentModel();
        String manifest = isFragment ? "fragment.xml" : "plugin.xml";
        String fileName = String.valueOf(pluginInfo.getModel().getInstallLocation()) + File.separator + manifest;
        File file = new File(fileName);
        if (file.exists()) {
            String editorId = String.valueOf(PDEPlugin.getPluginId()) + (isFragment ? ".fragmentEditor" : ".manifestEditor");
            try {
                SystemFileEditorInput input = new SystemFileEditorInput(file);
                return (ManifestEditor)PDEPlugin.getActivePage().openEditor((IEditorInput)input, editorId);
            }
            catch (PartInitException e) {
                PDEPlugin.logException(e);
            }
        }
        return null;
    }

    public static ManifestEditor openPluginEditor(String pluginId) {
        return ManifestEditor.openPluginEditor(pluginId, null);
    }

    public static ManifestEditor openPluginEditor(String pluginId, Object object) {
        IPlugin pluginToOpen = PDECore.getDefault().findPlugin(pluginId);
        if (pluginToOpen != null) {
            return ManifestEditor.openPluginEditor((IPluginBase)pluginToOpen, object);
        }
        Display.getCurrent().beep();
        return null;
    }

    public static ManifestEditor openPluginEditor(IPluginBase plugin) {
        return ManifestEditor.openPluginEditor(plugin, null);
    }

    public static ManifestEditor openPluginEditor(IPluginBase plugin, Object object) {
        return ManifestEditor.openPluginEditor(plugin, object, null);
    }

    public static ManifestEditor openPluginEditor(IPluginBase plugin, Object object, IMarker marker) {
        ManifestEditor editor = null;
        IResource underlyingResource = plugin.getModel().getUnderlyingResource();
        editor = underlyingResource == null ? ManifestEditor.openExternalPlugin(plugin) : ManifestEditor.openWorkspacePlugin((IFile)underlyingResource, plugin instanceof IFragment);
        if (editor != null && object != null) {
            editor.openTo(object, marker);
        }
        return editor;
    }

    private static ManifestEditor openWorkspacePlugin(IFile pluginFile, boolean fragment) {
        String editorId = fragment ? "org.eclipse.pde.ui.fragmentEditor" : "org.eclipse.pde.ui.manifestEditor";
        try {
            FileEditorInput input = new FileEditorInput(pluginFile);
            return (ManifestEditor)PDEPlugin.getActivePage().openEditor((IEditorInput)input, editorId);
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
            return null;
        }
    }

    protected boolean updateModel() {
        return this.updateModelNew();
    }

    private boolean updateModelNew() {
        ManifestSourcePageNew sourcePage = (ManifestSourcePageNew)this.getPage(this.getSourcePageId());
        boolean result = sourcePage.tryGetModelUpdatingTicket() ? this.updateModelOrig() : sourcePage.containsError();
        return result;
    }

    private boolean updateModelOrig() {
        IPluginModelBase model = (IPluginModelBase)this.getModel();
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        String text = document.get();
        boolean cleanModel = true;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes("UTF8"));
            try {
                model.reload((InputStream)stream, false);
                if (model instanceof IEditable && model.isEditable()) {
                    ((IEditable)model).setDirty(false);
                }
                cleanModel = this.containsError();
            }
            catch (CoreException coreException) {
                cleanModel = false;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedEncodingException e) {
            PDEPlugin.logException(e);
        }
        return cleanModel;
    }

    public void updateTitle() {
        this.firePropertyChange(1);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String property = event.getProperty();
        if (property.equals("Preferences.MainPage.showObjects")) {
            final IModelChangeProvider provider = (IModelChangeProvider)this.getModel();
            final ModelChangedEvent e = new ModelChangedEvent(99, null, null);
            BusyIndicator.showWhile((Display)this.formWorkbook.getControl().getDisplay(), (Runnable)new Runnable(){

                public void run() {
                    provider.fireModelChanged((IModelChangedEvent)e);
                }
            });
        }
    }

    public boolean canCopy(ISelection selection) {
        return this.getCurrentPage() instanceof ManifestFormPage ? true : super.canCopy(selection);
    }

    protected IPDEEditorPage getPageFor(Object object) {
        IPDEEditorPage overviewPage = this.getPage(OVERVIEW_PAGE);
        ManifestFormOutlinePage outline = (ManifestFormOutlinePage)overviewPage.getContentOutlinePage();
        if (outline != null) {
            return outline.getParentPage(object);
        }
        return null;
    }

    protected IDocumentProvider createDocumentProvider(Object input) {
        return this.createDocumentProviderNew(input);
    }

    private IDocumentProvider createDocumentProviderNew(Object input) {
        Object documentProvider = null;
        if (input instanceof IFile) {
            documentProvider = new SynchronizedUTF8FileDocumentProvider();
        } else if (input instanceof File) {
            documentProvider = new SynchronizedSystemFileDocumentProvider(this.createDocumentPartitioner(), "UTF8");
        } else if (input instanceof IStorage) {
            documentProvider = new SynchronizedStorageDocumentProvider(this.createDocumentPartitioner(), "UTF8");
        }
        return documentProvider;
    }

    protected class SynchronizedUTF8FileDocumentProvider
    extends PDEMultiPageXMLEditor.UTF8FileDocumentProvider {
        protected SynchronizedUTF8FileDocumentProvider() {
        }

        public IDocument createEmptyDocument() {
            return new PartiallySynchronizedDocument();
        }
    }
}

