/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.update.ui.forms.internal.FormSection;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class LibraryTypeSection
extends PDEFormSection {
    private Button codeButton;
    private Button resourcesButton;
    private IPluginLibrary currentLibrary;

    public LibraryTypeSection(PDEFormPage formPage) {
        super(formPage);
        this.setHeaderText(PDEPlugin.getResourceString("ManifestEditor.LibraryTypeSection.title"));
        this.setDescription(PDEPlugin.getResourceString("ManifestEditor.LibraryTypeSection.desc"));
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        this.codeButton = factory.createButton(container, PDEPlugin.getResourceString("ManifestEditor.LibraryTypeSection.code"), 16);
        this.codeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (LibraryTypeSection.this.codeButton.getSelection()) {
                        LibraryTypeSection.this.currentLibrary.setType(null);
                    } else {
                        LibraryTypeSection.this.currentLibrary.setType("resource");
                    }
                }
                catch (CoreException coreException) {}
            }
        });
        this.resourcesButton = factory.createButton(container, PDEPlugin.getResourceString("ManifestEditor.LibraryTypeSection.resources"), 16);
        this.update(null);
        return container;
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        this.setReadOnly(!model.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void sectionChanged(FormSection source, int changeType, Object changeObject) {
        this.update((IPluginLibrary)changeObject);
    }

    public void update(IPluginLibrary library) {
        if (library == null) {
            this.codeButton.setEnabled(false);
            this.codeButton.setSelection(false);
            this.resourcesButton.setEnabled(false);
            this.resourcesButton.setSelection(false);
        } else {
            String type = library.getType();
            if (type != null && type.equals("resource")) {
                this.codeButton.setSelection(false);
                this.resourcesButton.setSelection(true);
            } else {
                this.codeButton.setSelection(true);
                this.resourcesButton.setSelection(false);
            }
            this.codeButton.setEnabled(!this.isReadOnly());
            this.resourcesButton.setEnabled(!this.isReadOnly());
        }
        this.currentLibrary = library;
    }

    public void modelChanged(IModelChangedEvent e) {
        Object object;
        if (e.getChangeType() == 3 && (object = e.getChangedObjects()[0]) instanceof IPluginLibrary) {
            this.update((IPluginLibrary)object);
        }
    }

    public void commitChanges(boolean onSave) {
        try {
            if (this.currentLibrary != null) {
                if (this.resourcesButton.getSelection()) {
                    this.currentLibrary.setType("resource");
                } else {
                    this.currentLibrary.setType(null);
                }
            }
            this.setDirty(false);
        }
        catch (CoreException coreException) {}
    }
}

