/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaConventions;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.ui.JavaUI;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.ischema.ISchemaAttribute;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.codegen.AttributeClassCodeGenerator;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class JavaAttributeWizardPage
extends WizardPage {
    public static final String PAGE_TITLE = "JavaAttributeWizard.title";
    public static final String DUPLICATION_TITLE = "JavaAttributeWizard.duplication.title";
    public static final String KEY_GENERATING = "JavaAttributeWizard.generating";
    public static final String KEY_FINISH = "JavaAttributeWizard.finish";
    public static final String DUPLICATION_MESSAGE = "JavaAttributeWizard.duplication.message";
    public static final String PAGE_DESC = "JavaAttributeWizard.desc";
    public static final String KEY_CONTAINER_SELECTION = "JavaAttributeWizard.containerSelection";
    public static final String KEY_PACKAGE_SELECTION = "JavaAttributeWizard.packageSelection";
    public static final String KEY_MISSING_CONTAINER = "JavaAttributeWizard.error.container";
    public static final String GENERATE = "JavaAttributeWizard.generate";
    public static final String GENERATE_CONTAINER_NAME = "JavaAttributeWizard.generate.container";
    public static final String GENERATE_CONTAINER_BROWSE = "JavaAttributeWizard.generate.container.browse";
    public static final String GENERATE_PACKAGE_NAME = "JavaAttributeWizard.generate.package";
    public static final String GENERATE_PACKAGE_BROWSE = "JavaAttributeWizard.generate.package.browse";
    public static final String GENERATE_CLASS_NAME = "JavaAttributeWizard.generate.class";
    public static final String GENERATE_OPEN_EDITOR = "JavaAttributeWizard.generate.openEditor";
    public static final String SEARCH = "JavaAttributeWizard.search";
    public static final String SEARCH_CLASS_NAME = "JavaAttributeWizard.search.className";
    public static final String SEARCH_CLASS_BROWSE = "JavaAttributeWizard.search.className.browse";
    public static final String KEY_FIND_TYPE = "JavaAttributeWizard.findType";
    public static final String KEY_FILTER = "JavaAttributeWizard.filter";
    private String className;
    private IProject project;
    private ISchemaAttribute attInfo;
    private Button searchButton;
    private Label searchLabel;
    private Text searchText;
    private Button searchBrowse;
    private Button generateButton;
    private Label containerLabel;
    private Text containerText;
    private Button containerBrowse;
    private Label packageLabel;
    private Text packageText;
    private Button packageBrowse;
    private Label classLabel;
    private Text classText;
    private Button openFileButton;
    private ModifyListener modifyListener;
    private IPluginModelBase model;

    public JavaAttributeWizardPage(IProject project, IPluginModelBase model, ISchemaAttribute attInfo, String className) {
        super("classPage");
        this.project = project;
        this.model = model;
        this.attInfo = attInfo;
        this.className = className;
        this.setTitle(PDEPlugin.getResourceString(PAGE_TITLE));
        this.setDescription(PDEPlugin.getResourceString(PAGE_DESC));
        this.modifyListener = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                JavaAttributeWizardPage.this.verifyComplete();
            }
        };
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 5;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(768));
        this.createSearchSection(container);
        this.createGenerateSection(container);
        this.enableGenerateSection(false);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        this.setPageComplete(this.classText.getText().length() > 0);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.java_attribute_wizard_page");
    }

    private void enableGenerateSection(boolean enabled) {
        this.containerLabel.setEnabled(enabled);
        this.containerText.setEnabled(enabled);
        this.containerBrowse.setEnabled(enabled);
        this.packageLabel.setEnabled(enabled);
        this.packageText.setEnabled(enabled);
        this.packageBrowse.setEnabled(enabled);
        this.classLabel.setEnabled(enabled);
        this.classText.setEnabled(enabled);
        this.openFileButton.setEnabled(enabled);
    }

    private void enableSearchSection(boolean enabled) {
        this.searchLabel.setEnabled(enabled);
        this.searchText.setEnabled(enabled);
        this.searchBrowse.setEnabled(enabled);
    }

    private void createSearchSection(Composite parent) {
        this.searchButton = new Button(parent, 16);
        this.searchButton.setText(PDEPlugin.getResourceString(SEARCH));
        this.searchButton.setSelection(true);
        this.searchButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaAttributeWizardPage.this.generateButton.setSelection(!JavaAttributeWizardPage.this.searchButton.getSelection());
                JavaAttributeWizardPage.this.enableSearchSection(JavaAttributeWizardPage.this.searchButton.getSelection());
                JavaAttributeWizardPage.this.enableGenerateSection(!JavaAttributeWizardPage.this.searchButton.getSelection());
                JavaAttributeWizardPage.this.verifyComplete();
            }
        });
        Composite searchSection = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        searchSection.setLayout((Layout)layout);
        searchSection.setLayoutData((Object)new GridData(768));
        this.searchLabel = new Label(searchSection, 0);
        this.searchLabel.setText(PDEPlugin.getResourceString(SEARCH_CLASS_NAME));
        GridData gd = new GridData();
        gd.horizontalIndent = 25;
        this.searchLabel.setLayoutData((Object)gd);
        this.searchText = new Text(searchSection, 2048);
        this.searchText.setLayoutData((Object)new GridData(768));
        this.searchText.setText(this.className);
        this.searchText.addModifyListener(this.modifyListener);
        this.searchBrowse = new Button(searchSection, 8);
        this.searchBrowse.setLayoutData((Object)new GridData(128));
        SWTUtil.setButtonDimensionHint(this.searchBrowse);
        this.searchBrowse.setText(PDEPlugin.getResourceString(SEARCH_CLASS_BROWSE));
        this.searchBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaAttributeWizardPage.this.handleFindType(JavaAttributeWizardPage.this.searchText);
            }
        });
    }

    private void createGenerateSection(Composite parent) {
        this.generateButton = new Button(parent, 16);
        this.generateButton.setText(PDEPlugin.getResourceString(GENERATE));
        this.generateButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaAttributeWizardPage.this.searchButton.setSelection(!JavaAttributeWizardPage.this.generateButton.getSelection());
                JavaAttributeWizardPage.this.enableGenerateSection(JavaAttributeWizardPage.this.generateButton.getSelection());
                JavaAttributeWizardPage.this.enableSearchSection(!JavaAttributeWizardPage.this.generateButton.getSelection());
                JavaAttributeWizardPage.this.verifyComplete();
            }
        });
        Composite generateSection = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        generateSection.setLayout((Layout)layout);
        generateSection.setLayoutData((Object)new GridData(768));
        this.containerLabel = new Label(generateSection, 0);
        this.containerLabel.setText(PDEPlugin.getResourceString(GENERATE_CONTAINER_NAME));
        GridData gd = new GridData();
        gd.horizontalIndent = 25;
        this.containerLabel.setLayoutData((Object)gd);
        this.containerText = new Text(generateSection, 2048);
        this.containerText.setText(this.computeSourceContainer());
        this.containerText.setLayoutData((Object)new GridData(768));
        this.containerText.addModifyListener(this.modifyListener);
        this.containerBrowse = new Button(generateSection, 8);
        this.containerBrowse.setText(PDEPlugin.getResourceString(GENERATE_CONTAINER_BROWSE));
        this.containerBrowse.setLayoutData((Object)new GridData(32));
        SWTUtil.setButtonDimensionHint(this.containerBrowse);
        this.containerBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaAttributeWizardPage.this.handleFindContainer(JavaAttributeWizardPage.this.containerText);
            }
        });
        this.packageLabel = new Label(generateSection, 0);
        this.packageLabel.setText(PDEPlugin.getResourceString(GENERATE_PACKAGE_NAME));
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.packageLabel.setLayoutData((Object)gd);
        this.packageText = new Text(generateSection, 2048);
        this.packageText.setLayoutData((Object)new GridData(768));
        this.packageText.addModifyListener(this.modifyListener);
        this.packageBrowse = new Button(generateSection, 8);
        this.packageBrowse.setText(PDEPlugin.getResourceString(GENERATE_PACKAGE_BROWSE));
        this.packageBrowse.setLayoutData((Object)new GridData(32));
        SWTUtil.setButtonDimensionHint(this.packageBrowse);
        this.packageBrowse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                JavaAttributeWizardPage.this.handleFindPackage(JavaAttributeWizardPage.this.packageText);
            }
        });
        this.classLabel = new Label(generateSection, 0);
        this.classLabel.setText(PDEPlugin.getResourceString(GENERATE_CLASS_NAME));
        gd = new GridData();
        gd.horizontalIndent = 25;
        this.classLabel.setLayoutData((Object)gd);
        this.classText = new Text(generateSection, 2048);
        this.classText.setLayoutData((Object)new GridData(768));
        this.classText.addModifyListener(this.modifyListener);
        int loc = this.className.lastIndexOf(46);
        if (loc != -1) {
            this.packageText.setText(this.className.substring(0, loc));
            this.classText.setText(this.className.substring(loc + 1));
        }
        this.openFileButton = new Button(generateSection, 32);
        this.openFileButton.setText(PDEPlugin.getResourceString(GENERATE_OPEN_EDITOR));
        gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.horizontalIndent = 25;
        this.openFileButton.setLayoutData((Object)gd);
        this.openFileButton.setSelection(true);
    }

    private String computeSourceContainer() {
        IBuildModel buildModel = this.model.getBuildModel();
        if (buildModel == null || !buildModel.isLoaded()) {
            return "";
        }
        String candidate = null;
        IBuildEntry[] entries = buildModel.getBuild().getBuildEntries();
        int i = 0;
        while (i < entries.length) {
            IBuildEntry entry = entries[i];
            if (entry.getName().startsWith("source.")) {
                if (candidate != null) {
                    candidate = null;
                    break;
                }
                String[] tokens = entry.getTokens();
                if (tokens.length > 1) {
                    candidate = null;
                    break;
                }
                candidate = tokens[0];
            }
            ++i;
        }
        return candidate != null ? candidate : "";
    }

    private void createTask(IFile file) {
        String message = PDEPlugin.getFormattedMessage(KEY_FINISH, file.getName());
        try {
            IMarker marker = file.createMarker("org.eclipse.core.resources.taskmarker");
            marker.setAttribute("priority", 0);
            marker.setAttribute("message", (Object)message);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public boolean finish() {
        if (!this.searchButton.getSelection()) {
            this.className = String.valueOf(this.packageText.getText()) + "." + this.classText.getText();
            return this.generateClass();
        }
        this.className = this.searchText.getText();
        return true;
    }

    private boolean generateClass() {
        if (this.isAlreadyCreated(this.className)) {
            Display.getCurrent().beep();
            boolean ok = MessageDialog.openQuestion((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString(DUPLICATION_TITLE), (String)PDEPlugin.getFormattedMessage(DUPLICATION_MESSAGE, this.className));
            if (!ok) {
                return false;
            }
        }
        final String folderName = this.containerText.getText();
        final boolean openFile = this.openFileButton.getSelection();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                try {
                    JavaAttributeWizardPage.this.generateClass(folderName, openFile, pm);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        };
        try {
            this.getContainer().run(false, true, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    private void generateClass(String folderName, boolean openFile, IProgressMonitor monitor) throws CoreException {
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        IFolder folder = this.getSourceFolder(folderName);
        AttributeClassCodeGenerator generator = new AttributeClassCodeGenerator(javaProject, folder, this.className, this.attInfo);
        monitor.subTask(PDEPlugin.getFormattedMessage(KEY_GENERATING, this.className));
        IFile file = generator.generate(monitor);
        if (file != null && openFile) {
            IWorkbenchPage page = PDEPlugin.getActivePage();
            page.openEditor(file);
        }
        monitor.done();
    }

    public String getClassName() {
        return this.className;
    }

    private IFolder getSourceFolder(String folderName) throws CoreException {
        IPath path = this.project.getFullPath().append(folderName);
        IFolder folder = this.project.getWorkspace().getRoot().getFolder(path);
        return folder;
    }

    private void handleFindContainer(Text target) {
        Object[] result;
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(target.getShell(), (IContainer)this.project, false, PDEPlugin.getResourceString(KEY_CONTAINER_SELECTION));
        int status = dialog.open();
        if (status == 0 && (result = dialog.getResult()).length == 1) {
            IPath path = (IPath)result[0];
            target.setText(path.lastSegment());
        }
    }

    private void handleFindPackage(Text target) {
        try {
            SelectionDialog dialog = JavaUI.createPackageDialog((Shell)PDEPlugin.getActiveWorkbenchShell(), (IJavaProject)JavaCore.create((IProject)this.project), (int)0);
            dialog.setTitle(PDEPlugin.getResourceString(KEY_PACKAGE_SELECTION));
            dialog.setMessage("");
            int status = dialog.open();
            if (status == 0) {
                Object[] result = dialog.getResult();
                IPackageFragment packageFragment = (IPackageFragment)result[0];
                target.setText(packageFragment.getElementName());
                target.setFocus();
                target.selectAll();
            }
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleFindType(Text target) {
        try {
            SelectionDialog dialog = JavaUI.createTypeDialog((Shell)PDEPlugin.getActiveWorkbenchShell(), (IRunnableContext)this.getContainer(), (IProject)this.project, (int)6, (boolean)false);
            dialog.setTitle(PDEPlugin.getResourceString(KEY_FIND_TYPE));
            dialog.setMessage(PDEPlugin.getResourceString(KEY_FILTER));
            int status = dialog.open();
            if (status == 0) {
                Object[] result = dialog.getResult();
                IType type = (IType)result[0];
                target.setText(type.getFullyQualifiedName());
                target.setFocus();
                target.selectAll();
            }
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
        }
    }

    public boolean isAlreadyCreated(String fullName) {
        IJavaProject javaProject = JavaCore.create((IProject)this.project);
        Path path = new Path(String.valueOf(fullName.replace('.', '/')) + ".java");
        try {
            IJavaElement element = javaProject.findElement((IPath)path);
            return element != null;
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
            return false;
        }
    }

    private void verifyComplete() {
        IStatus status = null;
        if (this.searchButton.getSelection()) {
            status = JavaConventions.validateJavaTypeName((String)this.searchText.getText());
        } else {
            status = JavaConventions.validatePackageName((String)this.packageText.getText());
            IStatus second = JavaConventions.validateJavaTypeName((String)this.classText.getText());
            if (second.getSeverity() > status.getSeverity()) {
                status = second;
            }
        }
        this.setPageComplete(status.getSeverity() != 4 && this.containerText.getText().length() > 0);
        String errorMessage = null;
        if (status.getSeverity() == 4) {
            errorMessage = status.getMessage();
        }
        if (errorMessage == null && this.containerText.getText().length() == 0) {
            errorMessage = PDEPlugin.getResourceString(KEY_MISSING_CONTAINER);
        }
        if (errorMessage != null) {
            this.setErrorMessage(errorMessage);
        } else {
            this.setErrorMessage(null);
        }
        if (status.getSeverity() != 0) {
            this.setMessage(status.getMessage());
        } else {
            this.setMessage(null);
        }
    }
}

