/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.core.plugin.IPluginLibrary;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.build.WorkspaceBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestRuntimePage;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.parts.StructuredViewerPart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.ISharedImages;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerSelectionDialog;
import org.eclipse.update.ui.forms.internal.FormSection;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class JarsSection
extends TableSection
implements IModelChangedListener {
    private FormWidgetFactory factory;
    private TableViewer entryTable;
    private Image entryImage;
    private IPluginLibrary currentLibrary;
    public static final String SECTION_TITLE = "ManifestEditor.JarsSection.title";
    public static final String SECTION_RTITLE = "ManifestEditor.JarsSection.rtitle";
    public static final String SECTION_DIALOG_TITLE = "ManifestEditor.JarsSection.dialogTitle";
    public static final String POPUP_NEW_FOLDER = "ManifestEditor.JarsSection.newFolder";
    public static final String POPUP_DELETE = "Actions.delete.label";
    public static final String SECTION_NEW = "ManifestEditor.JarsSection.new";
    public static final String SECTION_DESC = "ManifestEditor.JarsSection.desc";
    public static final String SOURCE_DIALOG_TITLE = "ManifestEditor.JarsSection.missingSource.title";
    public static final String SOURCE_DIALOG_MESSAGE = "ManifestEditor.JarsSection.missingSource.message";
    public static final String DUPLICATE_FOLDER_MESSAGE = "ManifestEditor.JarsSection.missingSource.duplicateFolder";

    public JarsSection(ManifestRuntimePage page) {
        super(page, new String[]{PDEPlugin.getResourceString(SECTION_NEW)});
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.factory = factory;
        this.initializeImages();
        Composite container = this.createClientContainer(parent, 2, factory);
        this.createViewerPartControl(container, 65536, 2, factory);
        EditableTablePart tablePart = this.getTablePart();
        this.entryTable = tablePart.getTableViewer();
        this.entryTable.setContentProvider((IContentProvider)new TableContentProvider());
        this.entryTable.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        factory.paintBordersFor(container);
        return container;
    }

    protected StructuredViewerPart createViewerPart(String[] buttonLabels) {
        EditableTablePart tablePart = (EditableTablePart)super.createViewerPart(buttonLabels);
        tablePart.setEditable(false);
        return tablePart;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        Object item = selection.getFirstElement();
        this.fireSelectionNotification(item);
        this.getFormPage().setSelection((ISelection)selection);
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleNew();
        }
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals("delete")) {
            this.handleDelete();
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        IModel model = (IModel)this.getFormPage().getModel();
        ISelection selection = this.entryTable.getSelection();
        if (this.currentLibrary != null) {
            Action newAction = new Action(PDEPlugin.getResourceString(POPUP_NEW_FOLDER)){

                public void run() {
                    JarsSection.this.handleNew();
                }
            };
            newAction.setEnabled(model.isEditable());
            manager.add((IAction)newAction);
        }
        if (!selection.isEmpty()) {
            manager.add((IContributionItem)new Separator());
            Action deleteAction = new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

                public void run() {
                    JarsSection.this.handleDelete();
                }
            };
            deleteAction.setEnabled(model.isEditable());
            manager.add((IAction)deleteAction);
        }
        manager.add((IContributionItem)new Separator());
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager, false);
    }

    private void handleDelete() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IBuildModel buildModel = model.getBuildModel();
        if (!buildModel.isEditable()) {
            return;
        }
        IFile file = (IFile)model.getUnderlyingResource();
        IProject project = file.getProject();
        Object object = ((IStructuredSelection)this.entryTable.getSelection()).getFirstElement();
        if (object != null && object instanceof String) {
            String folderName = object.toString();
            IFolder folder = project.getFolder(folderName);
            this.removeIfOnBuildPath(project, folder);
            String libKey = "source." + this.currentLibrary.getName();
            IBuildEntry entry = buildModel.getBuild().getEntry(libKey);
            if (entry != null) {
                try {
                    entry.removeToken(object.toString());
                    this.entryTable.remove(object);
                    ((WorkspaceBuildModel)buildModel).save();
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }
        }
    }

    private void handleNew() {
        Object[] result;
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IFile file = (IFile)model.getUnderlyingResource();
        IProject project = file.getProject();
        ContainerSelectionDialog dialog = new ContainerSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), (IContainer)project, true, PDEPlugin.getResourceString(SECTION_DIALOG_TITLE));
        if (dialog.open() == 0 && (result = dialog.getResult()).length == 1) {
            IPath path = (IPath)result[0];
            IPath projectPath = project.getFullPath();
            if (!projectPath.isPrefixOf(path)) {
                return;
            }
            int matching = path.matchingFirstSegments(projectPath);
            String folder = (path = path.removeFirstSegments(matching)).toString();
            if (!this.verifyFolderExists(project, folder)) {
                return;
            }
            try {
                if (!folder.endsWith("/")) {
                    folder = String.valueOf(folder) + "/";
                }
                IBuildModel buildModel = model.getBuildModel();
                String libKey = "source." + this.currentLibrary.getName();
                IBuildEntry entry = buildModel.getBuild().getEntry(libKey);
                if (entry == null) {
                    entry = buildModel.getFactory().createEntry(libKey);
                    buildModel.getBuild().add(entry);
                } else if (entry.contains(folder)) {
                    String message = PDEPlugin.getFormattedMessage(DUPLICATE_FOLDER_MESSAGE, folder);
                    MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)"", (String)message);
                    return;
                }
                entry.addToken(folder);
                this.entryTable.add((Object)folder);
                ((WorkspaceBuildModel)buildModel).save();
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        IBuildModel buildModel = model.getBuildModel();
        boolean editable = model.isEditable() && buildModel.isEditable();
        this.setReadOnly(!editable);
        this.getTablePart().setButtonEnabled(0, false);
        model.addModelChangedListener((IModelChangedListener)this);
        if (!buildModel.isEditable()) {
            String header = this.getHeaderText();
            this.setHeaderText(PDEPlugin.getFormattedMessage(SECTION_RTITLE, header));
        }
    }

    private void initializeImages() {
        IWorkbench workbench = PlatformUI.getWorkbench();
        ISharedImages sharedImages = workbench.getSharedImages();
        this.entryImage = sharedImages.getImage("IMG_OBJ_FOLDER");
    }

    public void modelChanged(IModelChangedEvent event) {
    }

    public void sectionChanged(FormSection source, int changeType, Object changeObject) {
        IPluginLibrary library = (IPluginLibrary)changeObject;
        this.update(library);
    }

    public void setFocus() {
        this.entryTable.getTable().setFocus();
    }

    private void update(IPluginLibrary library) {
        this.currentLibrary = library;
        this.entryTable.setInput((Object)this.currentLibrary);
        this.getTablePart().setButtonEnabled(0, !this.isReadOnly() && library != null);
    }

    private boolean verifyFolderExists(IProject project, String folderName) {
        IPath path = project.getFullPath().append(folderName);
        IFolder folder = project.getWorkspace().getRoot().getFolder(path);
        if (!folder.exists()) {
            boolean result = MessageDialog.openQuestion((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString(SOURCE_DIALOG_TITLE), (String)PDEPlugin.getFormattedMessage(SOURCE_DIALOG_MESSAGE, folder.getFullPath().toString()));
            if (result) {
                try {
                    folder.create(false, true, null);
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                    return false;
                }
            } else {
                return false;
            }
        }
        return this.addIfNotOnBuildPath(project, folder);
    }

    private boolean addIfNotOnBuildPath(IProject project, IFolder folder) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] entries = null;
        try {
            entries = javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
            return false;
        }
        int i = 0;
        while (i < entries.length) {
            IPath path;
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 3 && (path = entry.getPath()).equals((Object)folder.getFullPath())) {
                return true;
            }
            ++i;
        }
        IClasspathEntry sourceEntry = JavaCore.newSourceEntry((IPath)folder.getFullPath().makeAbsolute());
        IClasspathEntry[] newEntries = new IClasspathEntry[entries.length + 1];
        System.arraycopy(entries, 0, newEntries, 0, entries.length);
        newEntries[entries.length] = sourceEntry;
        return this.executeNewClasspathOperation(javaProject, newEntries);
    }

    private boolean removeIfOnBuildPath(IProject project, IFolder folder) {
        IJavaProject javaProject = JavaCore.create((IProject)project);
        IClasspathEntry[] entries = null;
        try {
            entries = javaProject.getRawClasspath();
        }
        catch (JavaModelException e) {
            PDEPlugin.logException(e);
            return false;
        }
        ArrayList<IClasspathEntry> newList = new ArrayList<IClasspathEntry>();
        boolean found = false;
        int i = 0;
        while (i < entries.length) {
            IPath path;
            IClasspathEntry entry = entries[i];
            if (entry.getEntryKind() == 3 && (path = entry.getPath()).equals((Object)folder.getFullPath())) {
                found = true;
            } else {
                newList.add(entry);
            }
            ++i;
        }
        if (!found) {
            return false;
        }
        IClasspathEntry[] newEntries = newList.toArray(new IClasspathEntry[newList.size()]);
        return this.executeNewClasspathOperation(javaProject, newEntries);
    }

    private boolean executeNewClasspathOperation(final IJavaProject javaProject, final IClasspathEntry[] newEntries) {
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    javaProject.setRawClasspath(newEntries, monitor);
                }
                catch (JavaModelException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        ProgressMonitorDialog pmd = new ProgressMonitorDialog(this.entryTable.getTable().getShell());
        try {
            pmd.run(true, false, op);
            return true;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IPluginLibrary) {
                IPluginLibrary library = (IPluginLibrary)parent;
                IPluginModelBase model = (IPluginModelBase)JarsSection.this.getFormPage().getModel();
                IBuildModel buildModel = model.getBuildModel();
                String libKey = "source." + library.getName();
                IBuildEntry entry = buildModel.getBuild().getEntry(libKey);
                if (entry != null) {
                    return entry.getTokens();
                }
            }
            return new Object[0];
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return JarsSection.this.entryImage;
        }
    }
}

