/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.builders.DependencyLoop;
import org.eclipse.pde.internal.builders.DependencyLoopFinder;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.plugin.ImportObject;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.manifest.DependenciesForm;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestDependenciesPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestEditor;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class ImportStatusSection
extends PDEFormSection
implements IModelChangedListener {
    private TreeViewer statusTree;
    private FormWidgetFactory factory;
    private Image pluginImage;
    private Image fragmentImage;
    private Image importImage;
    private Image warningLoopImage;
    private Image loopNodeImage;
    private CCombo combo;
    private Vector references;
    private Object[] loops;
    private Vector freferences;
    private Action openAction;
    private Action refreshAction;
    public static final String SECTION_TITLE = "ManifestEditor.ImportStatusSection.title";
    public static final String SECTION_DESC = "ManifestEditor.ImportStatusSection.desc";
    public static final String COMBO_LABEL = "ManifestEditor.ImportStatusSection.comboLabel";
    public static final String COMBO_LOOPS = "ManifestEditor.ImportStatusSection.comboLoops";
    public static final String COMBO_REFS = "ManifestEditor.ImportStatusSection.comboRefs";
    public static final String COMBO_FREFS = "ManifestEditor.ImportStatusSection.comboFrefs";
    public static final String KEY_OPEN_LABEL = "Actions.open.label";
    public static final String KEY_REFRESH_LABEL = "Actions.refresh.label";
    private static final int LOOP_MODE = 0;
    private static final int REFERENCE_MODE = 1;
    private static final int FREFERENCE_MODE = 2;
    private int mode = 0;

    public ImportStatusSection(ManifestDependenciesPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.factory = factory;
        this.initializeImages();
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        factory.createLabel(container, PDEPlugin.getResourceString(COMBO_LABEL));
        int comboStyle = 8;
        comboStyle = !SWT.getPlatform().equals("motif") ? (comboStyle |= 0x800000) : (comboStyle |= 0x800);
        this.combo = new CCombo(container, comboStyle);
        this.combo.setBackground(factory.getBackgroundColor());
        this.combo.setForeground(factory.getForegroundColor());
        this.combo.add(PDEPlugin.getResourceString(COMBO_LOOPS));
        this.combo.add(PDEPlugin.getResourceString(COMBO_REFS));
        this.combo.add(PDEPlugin.getResourceString(COMBO_FREFS));
        GridData gd = new GridData(768);
        this.combo.setLayoutData((Object)gd);
        this.combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ImportStatusSection.this.viewChanged();
            }
        });
        Tree tree = new Tree(container, 0);
        factory.hookDeleteListener((Control)tree);
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                ImportStatusSection.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.setRemoveAllWhenShown(true);
        popupMenuManager.addMenuListener(listener);
        Menu menu = popupMenuManager.createContextMenu((Control)tree);
        tree.setMenu(menu);
        this.statusTree = new TreeViewer(tree);
        this.statusTree.setContentProvider((IContentProvider)new StatusContentProvider());
        this.statusTree.setLabelProvider((IBaseLabelProvider)new StatusLabelProvider());
        factory.paintBordersFor(container);
        this.statusTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                Object item = ((IStructuredSelection)event.getSelection()).getFirstElement();
                ImportStatusSection.this.fireSelectionNotification(item);
                ImportStatusSection.this.getFormPage().setSelection(event.getSelection());
            }
        });
        this.statusTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent e) {
                ImportStatusSection.this.handleOpen(e.getSelection());
            }
        });
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        tree.setLayoutData((Object)gd);
        this.combo.pack();
        this.combo.select(0);
        this.makeActions();
        return container;
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        return actionId.equals("delete");
    }

    public void expandTo(Object object) {
        if (object instanceof IPluginImport) {
            ImportObject iobj = new ImportObject((IPluginImport)object);
            this.statusTree.setSelection((ISelection)new StructuredSelection((Object)iobj), true);
        }
    }

    private void fillContextMenu(IMenuManager manager) {
        Object object;
        ISelection selection = this.statusTree.getSelection();
        if (!selection.isEmpty() && (object = ((IStructuredSelection)selection).getFirstElement()) instanceof IPluginBase) {
            manager.add((IAction)this.openAction);
        }
        manager.add((IAction)this.refreshAction);
        manager.add((IContributionItem)new Separator());
        ((DependenciesForm)this.getFormPage().getForm()).fillContextMenu(manager);
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager);
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        this.statusTree.setInput((Object)model.getPluginBase());
        this.setReadOnly(!model.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void initializeImages() {
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        this.pluginImage = provider.get(PDEPluginImages.DESC_PLUGIN_OBJ);
        this.fragmentImage = provider.get(PDEPluginImages.DESC_FRAGMENT_OBJ);
        this.importImage = provider.get(PDEPluginImages.DESC_REQ_PLUGIN_OBJ);
        this.loopNodeImage = provider.get(PDEPluginImages.DESC_LOOP_NODE_OBJ);
        this.warningLoopImage = provider.get(PDEPluginImages.DESC_LOOP_OBJ, 2);
    }

    private void makeActions() {
        this.openAction = new Action(){

            public void run() {
                ImportStatusSection.this.handleOpen(ImportStatusSection.this.statusTree.getSelection());
            }
        };
        this.openAction.setText(PDEPlugin.getResourceString(KEY_OPEN_LABEL));
        this.refreshAction = new Action(){

            public void run() {
                ImportStatusSection.this.viewChanged();
            }
        };
        this.refreshAction.setText(PDEPlugin.getResourceString(KEY_REFRESH_LABEL));
    }

    private void handleOpen(ISelection sel) {
        IStructuredSelection ssel;
        if (sel instanceof IStructuredSelection && (ssel = (IStructuredSelection)sel).size() == 1) {
            this.handleOpen(ssel.getFirstElement());
        }
    }

    private void handleOpen(Object obj) {
        if (obj instanceof IPluginBase) {
            IPluginBase plugin = (IPluginBase)obj;
            ManifestEditor.openPluginEditor(plugin);
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        boolean fullRefresh = false;
        if (event.getChangeType() == 99) {
            fullRefresh = true;
        } else {
            Object changeObject = event.getChangedObjects()[0];
            if (changeObject instanceof IPluginImport) {
                fullRefresh = true;
            }
        }
        if (fullRefresh) {
            this.references = null;
            this.freferences = null;
            this.loops = null;
            this.statusTree.refresh();
            return;
        }
    }

    private void viewChanged() {
        int index = this.combo.getSelectionIndex();
        switch (index) {
            case 0: {
                this.mode = 0;
                this.statusTree.setAutoExpandLevel(0);
                break;
            }
            case 1: {
                this.mode = 1;
                this.statusTree.setAutoExpandLevel(-1);
                break;
            }
            case 2: {
                this.mode = 2;
                this.statusTree.setAutoExpandLevel(-1);
            }
        }
        BusyIndicator.showWhile((Display)this.statusTree.getTree().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ImportStatusSection.this.statusTree.refresh();
            }
        });
    }

    private Object[] getReferences() {
        if (this.references == null) {
            this.references = new Vector();
            IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
            IPluginBase plugin = model.getPluginBase();
            String referenceId = plugin.getId();
            ExternalModelManager registry = PDECore.getDefault().getExternalModelManager();
            WorkspaceModelManager manager = PDECore.getDefault().getWorkspaceModelManager();
            this.createReferences(this.references, manager.getWorkspacePluginModels(), referenceId);
            if (registry.hasEnabledModels()) {
                this.createReferences(this.references, registry.getModels(), referenceId);
            }
        }
        return this.references.toArray();
    }

    private void createReferences(Vector result, IPluginModel[] candidates, String id) {
        int i = 0;
        while (i < candidates.length) {
            IPluginModel candidate = candidates[i];
            if (this.isReferencing(candidate, id)) {
                result.add(candidate.getPlugin());
            }
            ++i;
        }
    }

    private boolean isReferencing(IPluginModel model, String id) {
        IPlugin plugin = model.getPlugin();
        IPluginImport[] imports = plugin.getImports();
        int i = 0;
        while (i < imports.length) {
            IPluginImport iimport = imports[i];
            if (iimport.getId().equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Object[] getFragmentReferences() {
        if (this.freferences == null) {
            this.freferences = new Vector();
            IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
            IPluginBase plugin = model.getPluginBase();
            String referenceId = plugin.getId();
            WorkspaceModelManager wm = PDECore.getDefault().getWorkspaceModelManager();
            IFragment[] fragments = wm.getFragmentsFor(referenceId, plugin.getVersion());
            int i = 0;
            while (i < fragments.length) {
                this.freferences.add(fragments[i]);
                ++i;
            }
        }
        return this.freferences.toArray();
    }

    private Object[] getLoops() {
        if (this.loops == null) {
            IPlugin plugin = ((IPluginModel)this.getFormPage().getModel()).getPlugin();
            this.loops = DependencyLoopFinder.findLoops((IPlugin)plugin);
        }
        return this.loops;
    }

    private Image resolveObjectImage(Object obj) {
        if (obj instanceof IPlugin) {
            if (this.mode == 1) {
                return this.pluginImage;
            }
            if (this.mode == 0) {
                return this.loopNodeImage;
            }
        }
        if (obj instanceof IFragment) {
            return this.fragmentImage;
        }
        if (obj instanceof DependencyLoop) {
            return this.warningLoopImage;
        }
        return null;
    }

    private String resolveObjectName(Object obj) {
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        if (this.mode == 1 && obj instanceof IPlugin) {
            return provider.getText(obj);
        }
        if (this.mode == 2 && obj instanceof IFragment) {
            return provider.getText(obj);
        }
        return obj.toString();
    }

    public void setFocus() {
        if (this.statusTree != null) {
            this.statusTree.getTree().setFocus();
        }
    }

    class StatusContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        StatusContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof DependencyLoop) {
                DependencyLoop loop = (DependencyLoop)parent;
                return loop.getMembers();
            }
            return new Object[0];
        }

        public boolean hasChildren(Object parent) {
            return parent instanceof DependencyLoop;
        }

        public Object getParent(Object child) {
            return null;
        }

        public Object[] getElements(Object parent) {
            if (ImportStatusSection.this.mode == 1) {
                return ImportStatusSection.this.getReferences();
            }
            if (ImportStatusSection.this.mode == 0) {
                return ImportStatusSection.this.getLoops();
            }
            if (ImportStatusSection.this.mode == 2) {
                return ImportStatusSection.this.getFragmentReferences();
            }
            return new Object[0];
        }
    }

    class StatusLabelProvider
    extends LabelProvider {
        StatusLabelProvider() {
        }

        public String getText(Object obj) {
            return ImportStatusSection.this.resolveObjectName(obj);
        }

        public Image getImage(Object obj) {
            return ImportStatusSection.this.resolveObjectImage(obj);
        }
    }
}

