/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageEditor;
import org.eclipse.pde.internal.ui.editor.manifest.ExtensionElementPropertySource;
import org.eclipse.pde.internal.ui.editor.manifest.ExtensionPropertySource;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestPropertySheet;
import org.eclipse.pde.internal.ui.editor.manifest.NullMenuManager;
import org.eclipse.pde.internal.ui.editor.manifest.NullToolBarManager;
import org.eclipse.pde.internal.ui.editor.manifest.UnknownElementPropertySource;
import org.eclipse.pde.internal.ui.util.PDEProblemFinder;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.views.properties.IPropertySheetEntry;

public class ExtensionsPropertySheet
extends ManifestPropertySheet {
    private Composite attComposite;
    private Action cloneAction;
    private Composite composite;
    private Action addAttAction;
    private Action removeAttAction;
    private ActionContributionItem removeAttItem;
    private boolean newAttVisible;
    private Text newAttText;
    private SubActionBars customBars;
    public static final String KEY_NEW_ATTRIBUTE = "ManifestEditor.ExtensionsPropertySheet.newAttribute";
    public static final String KEY_NEW_ATTRIBUTE_ENTRY = "ManifestEditor.ExtensionsPropertySheet.newAttributeEntry";
    public static final String ADD_ATT_LABEL = "ManifestEditor.ExtensionsPropertySheet.addAttAction.label";
    public static final String ADD_ATT_TOOLTIP = "ManifestEditor.ExtensionsPropertySheet.addAttAction.tooltip";
    public static final String REMOVE_ATT_LABEL = "ManifestEditor.ExtensionsPropertySheet.removeAttAction.label";
    public static final String REMOVE_ATT_TOOLTIP = "ManifestEditor.ExtensionsPropertySheet.removeAttAction.tooltip";
    public static final String CLONE_LABEL = "ManifestEditor.ExtensionsPropertySheet.cloneAction.text";
    public static final String CLONE_TOOLTIP = "ManifestEditor.ExtensionsPropertySheet.cloneAction.tooltip";
    private SubActionBars unknownBars;

    public ExtensionsPropertySheet(PDEMultiPageEditor editor) {
        super(editor);
    }

    public void createControl(Composite parent) {
        this.composite = new Composite(parent, 0);
        PropertyLayout layout = new PropertyLayout();
        this.composite.setLayout((Layout)layout);
        this.createNewAttField(this.composite);
        super.createControl(this.composite);
    }

    protected void createNewAttField(Composite container) {
        this.attComposite = new Composite(container, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        this.attComposite.setLayout((Layout)layout);
        Label label = new Label(this.attComposite, 0);
        label.setText(PDEPlugin.getResourceString(KEY_NEW_ATTRIBUTE));
        label.setLayoutData((Object)new GridData());
        this.newAttText = new Text(this.attComposite, 2048);
        this.newAttText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                if (e.character == '\u001b') {
                    ExtensionsPropertySheet.this.setNewAttVisible(false);
                } else if (e.character == '\r') {
                    ExtensionsPropertySheet.this.handleEnter();
                }
            }
        });
        this.newAttText.addListener(31, new Listener(){

            public void handleEvent(Event e) {
                if (ExtensionsPropertySheet.this.attComposite.isVisible()) {
                    ExtensionsPropertySheet.this.handleEnter();
                    e.doit = false;
                }
            }
        });
        GridData gd = new GridData(768);
        this.newAttText.setLayoutData((Object)gd);
    }

    public void fillContextMenu(IMenuManager manager) {
        if (this.isUnknown()) {
            manager.add((IAction)this.addAttAction);
            manager.add((IAction)this.removeAttAction);
        } else {
            super.fillContextMenu(manager);
        }
    }

    public void fillLocalMenuBar(IMenuManager menuManager) {
        this.doFillLocalMenuBar(menuManager);
        menuManager.add((IAction)this.cloneAction);
    }

    public void fillLocalToolBar(IToolBarManager toolBarManager) {
        if (!(this.source instanceof ExtensionPropertySource)) {
            if (this.isUnknown()) {
                toolBarManager.add((IAction)this.addAttAction);
                toolBarManager.add((IAction)this.removeAttAction);
            } else {
                this.doFillLocalToolBar(toolBarManager);
            }
            toolBarManager.add((IContributionItem)new Separator());
            toolBarManager.add((IAction)this.cloneAction);
        }
    }

    public Control getControl() {
        return this.composite;
    }

    private void handleAddAttribute() {
        this.setNewAttVisible(true);
    }

    private void handleClone() {
        IPluginElement element = (IPluginElement)this.currentInput;
        IPluginParent parent = (IPluginParent)element.getParent();
        IPluginElement newElement = element.createCopy();
        try {
            parent.add((IPluginObject)newElement);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleEnter() {
        if (this.source instanceof UnknownElementPropertySource) {
            ((UnknownElementPropertySource)this.source).addAttribute(this.newAttText.getText(), "");
        }
        this.setNewAttVisible(false);
        this.refreshInput();
    }

    private void handleRemoveAttribute() {
        IPropertySheetEntry entry = this.getSelectedEntry();
        if (entry == null) {
            return;
        }
        PDEProblemFinder.fixMe("Should not be using display name as an id");
        String attName = entry.getDisplayName();
        ((UnknownElementPropertySource)this.source).removeAttribute(attName);
        this.refreshInput();
        this.removeAttAction.setEnabled(false);
    }

    public boolean isNewAttVisible() {
        return this.newAttVisible;
    }

    protected boolean isUnknown() {
        return this.source != null && this.source instanceof UnknownElementPropertySource;
    }

    protected void makeActions() {
        super.makeActions();
        this.addAttAction = new Action("addAtt"){

            public void run() {
                ExtensionsPropertySheet.this.handleAddAttribute();
            }
        };
        this.addAttAction.setImageDescriptor(PDEPluginImages.DESC_ADD_ATT);
        this.addAttAction.setHoverImageDescriptor(PDEPluginImages.DESC_ADD_ATT_HOVER);
        this.addAttAction.setDisabledImageDescriptor(PDEPluginImages.DESC_ADD_ATT_DISABLED);
        this.addAttAction.setText(PDEPlugin.getResourceString(ADD_ATT_LABEL));
        this.addAttAction.setToolTipText(PDEPlugin.getResourceString(ADD_ATT_TOOLTIP));
        this.addAttAction.setEnabled(false);
        this.removeAttAction = new Action("removeAtt"){

            public void run() {
                ExtensionsPropertySheet.this.handleRemoveAttribute();
            }
        };
        this.removeAttAction.setImageDescriptor(PDEPluginImages.DESC_REMOVE_ATT);
        this.removeAttAction.setHoverImageDescriptor(PDEPluginImages.DESC_REMOVE_ATT_HOVER);
        this.removeAttAction.setDisabledImageDescriptor(PDEPluginImages.DESC_REMOVE_ATT_DISABLED);
        this.removeAttAction.setText(PDEPlugin.getResourceString(REMOVE_ATT_LABEL));
        this.removeAttAction.setToolTipText(PDEPlugin.getResourceString(REMOVE_ATT_TOOLTIP));
        this.removeAttAction.setEnabled(false);
        this.cloneAction = new Action("clone"){

            public void run() {
                ExtensionsPropertySheet.this.handleClone();
            }
        };
        this.cloneAction.setImageDescriptor(PDEPluginImages.DESC_CLONE_EL);
        this.cloneAction.setHoverImageDescriptor(PDEPluginImages.DESC_CLONE_EL_HOVER);
        this.cloneAction.setDisabledImageDescriptor(PDEPluginImages.DESC_CLONE_EL_DISABLED);
        this.cloneAction.setText(PDEPlugin.getResourceString(CLONE_LABEL));
        this.cloneAction.setToolTipText(PDEPlugin.getResourceString(CLONE_TOOLTIP));
        this.cloneAction.setEnabled(false);
    }

    public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
        this.superMakeContributions(new NullMenuManager(), new NullToolBarManager(), statusLineManager);
        this.customBars = new SubActionBars();
        this.customBars.menuManager = new SubMenuManager(menuManager);
        this.customBars.toolBarManager = new SubToolBarManager(toolBarManager);
        this.customBars.setVisible(true);
        this.doFillLocalToolBar((IToolBarManager)this.customBars.toolBarManager);
        this.customBars.toolBarManager.add((IAction)this.cloneAction);
        this.doFillLocalMenuBar((IMenuManager)this.customBars.menuManager);
        this.customBars.menuManager.add((IAction)this.cloneAction);
        this.unknownBars = new SubActionBars();
        this.unknownBars.toolBarManager = new SubToolBarManager(toolBarManager);
        this.unknownBars.toolBarManager.add((IContributionItem)new Separator());
        this.unknownBars.toolBarManager.add((IAction)this.addAttAction);
        this.unknownBars.toolBarManager.add((IAction)this.removeAttAction);
        this.unknownBars.toolBarManager.add((IContributionItem)new Separator());
        this.unknownBars.toolBarManager.add((IAction)this.cloneAction);
        this.unknownBars.menuManager = new SubMenuManager(menuManager);
        this.unknownBars.menuManager.add((IContributionItem)new Separator());
        this.unknownBars.menuManager.add((IAction)this.addAttAction);
        this.unknownBars.menuManager.add((IAction)this.removeAttAction);
        this.unknownBars.menuManager.add((IContributionItem)new Separator());
        this.unknownBars.menuManager.add((IAction)this.cloneAction);
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        super.selectionChanged(part, sel);
        this.updateActionVisibility();
    }

    public void setNewAttVisible(boolean value) {
        if (value != this.newAttVisible) {
            this.newAttVisible = value;
            this.attComposite.setVisible(value);
            this.composite.layout(true);
            if (value) {
                this.newAttText.setText(PDEPlugin.getResourceString(KEY_NEW_ATTRIBUTE_ENTRY));
                this.newAttText.selectAll();
                this.newAttText.setFocus();
            }
        }
    }

    protected void switchBars() {
        boolean unknown = this.isUnknown();
        this.unknownBars.setVisible(unknown);
        this.customBars.setVisible(!unknown);
        this.customBars.updateActionBars();
    }

    public void updateActions(IPropertySheetEntry entry) {
        super.updateActions(entry);
        if (this.isUnknown() && this.isEditable()) {
            this.removeAttAction.setEnabled(entry != null);
        }
    }

    private void updateActionVisibility() {
        boolean unknown = this.isUnknown();
        this.addAttAction.setEnabled(unknown && this.isEditable());
        this.removeAttAction.setEnabled(false);
        this.setNewAttVisible(false);
        if (this.source instanceof ExtensionElementPropertySource || this.source instanceof UnknownElementPropertySource) {
            this.cloneAction.setEnabled(this.isEditable());
        } else {
            this.cloneAction.setEnabled(false);
        }
    }

    class SubActionBars {
        SubMenuManager menuManager;
        SubToolBarManager toolBarManager;

        SubActionBars() {
        }

        public void updateActionBars() {
            this.menuManager.update(true);
            this.toolBarManager.update(true);
        }

        public void setVisible(boolean visible) {
            this.menuManager.setVisible(visible);
            this.toolBarManager.setVisible(visible);
        }
    }

    class PropertyLayout
    extends Layout {
        PropertyLayout() {
        }

        public Point computeSize(Composite parent, int wHint, int hHint, boolean changed) {
            Control[] children = parent.getChildren();
            Control c1 = children[0];
            Control c2 = children[1];
            Point s1 = c1.computeSize(wHint, hHint, changed);
            Point s2 = c2.computeSize(wHint, hHint, changed);
            int width = Math.max(s1.x, s2.x);
            int height = s2.y;
            if (ExtensionsPropertySheet.this.newAttVisible) {
                height += s1.y;
            }
            return new Point(width, height);
        }

        public void layout(Composite parent, boolean changed) {
            Rectangle bounds = parent.getClientArea();
            int y = 0;
            Control[] children = parent.getChildren();
            if (ExtensionsPropertySheet.this.newAttVisible) {
                Control c1 = children[0];
                Point s1 = c1.computeSize(-1, -1, changed);
                c1.setLocation(0, 0);
                c1.setSize(bounds.width, s1.y);
                y = s1.y;
            }
            Control c2 = children[1];
            c2.setSize(bounds.width, bounds.height - y);
            c2.setLocation(0, y);
        }
    }
}

