/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestFormPage;
import org.eclipse.pde.internal.ui.preferences.MainPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.IFormPage;
import org.eclipse.update.ui.forms.internal.IHyperlinkListener;
import org.eclipse.update.ui.forms.internal.SelectableFormLabel;

public class ExtensionSection
extends PDEFormSection
implements IHyperlinkListener,
IModelChangedListener {
    public static final String SECTION_TITLE = "ManifestEditor.ExtensionSection.title";
    public static final String SECTION_DESC = "ManifestEditor.ExtensionSection.desc";
    public static final String SECTION_FDESC = "ManifestEditor.ExtensionSection.fdesc";
    public static final String SECTION_MORE = "ManifestEditor.ExtensionSection.more";
    private FormWidgetFactory factory;
    private boolean needsUpdate;
    private Composite extensionParent;
    private Button moreButton;
    private Image extensionImage;

    public ExtensionSection(ManifestFormPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        boolean fragment = ((ManifestEditor)page.getEditor()).isFragmentEditor();
        if (fragment) {
            this.setDescription(PDEPlugin.getResourceString(SECTION_FDESC));
        } else {
            this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        }
    }

    private void addExtensionLink(IPluginExtension extension) {
        String point = extension.getPoint();
        IPluginExtensionPoint pointInfo = PDECore.getDefault().findExtensionPoint(point);
        Label imageLabel = this.factory.createLabel(this.extensionParent, "");
        String name = point;
        String tooltip = point;
        if (extension.getName() != null) {
            String extensionName = extension.getTranslatedName();
            if (MainPreferencePage.isFullNameModeEnabled()) {
                name = extensionName;
            } else {
                tooltip = extensionName;
            }
        } else if (pointInfo != null) {
            String translatedName = pointInfo.getTranslatedName();
            if (MainPreferencePage.isFullNameModeEnabled()) {
                name = translatedName;
            } else {
                tooltip = translatedName;
            }
        }
        SelectableFormLabel hyperlink = this.factory.createSelectableLabel(this.extensionParent, name);
        this.factory.turnIntoHyperlink((Control)hyperlink, (IHyperlinkListener)this);
        hyperlink.setToolTipText(tooltip);
        hyperlink.setData((Object)extension);
        imageLabel.setImage(this.extensionImage);
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.factory = factory;
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        this.extensionParent = factory.createComposite(container);
        this.extensionParent.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        this.extensionParent.setLayoutData((Object)gd);
        Composite buttonContainer = factory.createComposite(container);
        gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        this.moreButton = factory.createButton(buttonContainer, PDEPlugin.getResourceString(SECTION_MORE), 8);
        gd = new GridData(34);
        this.moreButton.setLayoutData((Object)gd);
        final IPDEEditorPage targetPage = this.getFormPage().getEditor().getPage("ExtensionsPage");
        this.moreButton.setToolTipText(((IFormPage)targetPage).getTitle());
        this.moreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtensionSection.this.getFormPage().getEditor().showPage(targetPage);
            }
        });
        return container;
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public void initialize(Object input) {
        this.initializeImages();
        IPluginModelBase model = (IPluginModelBase)input;
        this.update(false);
        model.addModelChangedListener((IModelChangedListener)this);
    }

    private void initializeImages() {
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        this.extensionImage = provider.get(PDEPluginImages.DESC_EXTENSION_OBJ);
    }

    public void linkActivated(Control linkLabel) {
        IPluginExtension extension = (IPluginExtension)linkLabel.getData();
        this.getFormPage().getEditor().showPage("ExtensionsPage", extension);
    }

    public void linkEntered(Control link) {
        IPDEEditorPage page = this.getFormPage().getEditor().getPage("ExtensionsPage");
        String status = String.valueOf(((PDEFormPage)page).getStatusText()) + "#" + ((SelectableFormLabel)link).getText();
        IStatusLineManager manager = this.getFormPage().getEditor().getStatusLineManager();
        if (manager != null) {
            manager.setMessage(status);
        }
    }

    public void linkExited(Control linkLabel) {
        IStatusLineManager manager = this.getFormPage().getEditor().getStatusLineManager();
        if (manager != null) {
            manager.setMessage("");
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        String property;
        int type = event.getChangeType();
        if (type == 99) {
            this.needsUpdate = true;
        }
        if (this.getFormPage().isVisible()) {
            this.update();
        } else if (type == 1 || type == 2) {
            Object[] objects = event.getChangedObjects();
            if (objects[0] instanceof IPluginExtension) {
                this.needsUpdate = true;
            }
        } else if (type == 3 && ((property = event.getChangedProperty()).equals("extension_order") || property.equals("sibling_order"))) {
            this.needsUpdate = true;
        }
    }

    public void update() {
        if (this.needsUpdate) {
            this.update(true);
        }
    }

    public void update(boolean removePrevious) {
        if (removePrevious) {
            Control[] children = this.extensionParent.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IPluginBase plugin = model.getPluginBase();
        IPluginExtension[] extensions = plugin.getExtensions();
        int i = 0;
        while (i < extensions.length) {
            this.addExtensionLink(extensions[i]);
            ++i;
        }
        this.needsUpdate = false;
        if (removePrevious) {
            this.extensionParent.layout(true);
            this.extensionParent.redraw();
        }
    }
}

