/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestPropertySource;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public class ExtensionPropertySource
extends ManifestPropertySource {
    private PropertyDescriptor[] descriptors;
    private static final String P_POINT = "point";
    private static final String P_ID = "id";
    private static final String P_NAME = "name";

    public ExtensionPropertySource(IPluginExtension extension) {
        super((IPluginObject)extension);
    }

    public Object getEditableValue() {
        return null;
    }

    public IPluginExtension getExtension() {
        return (IPluginExtension)this.object;
    }

    public IPropertyDescriptor[] getPropertyDescriptors() {
        if (this.descriptors == null) {
            this.descriptors = new PropertyDescriptor[3];
            this.descriptors[0] = this.createTextPropertyDescriptor(P_POINT, P_POINT);
            this.descriptors[0].setLabelProvider((ILabelProvider)new PropertyLabelProvider(P_POINT, PDEPluginImages.get(PDEPluginImages.IMG_ATT_REQ_OBJ)));
            this.descriptors[1] = this.createTextPropertyDescriptor(P_ID, P_ID);
            this.descriptors[2] = this.createTextPropertyDescriptor(P_NAME, P_NAME);
        }
        return this.descriptors;
    }

    public Object getPropertyValue(Object name) {
        if (name.equals(P_ID)) {
            return this.getNonzeroValue(this.getExtension().getId());
        }
        if (name.equals(P_NAME)) {
            return this.getNonzeroValue(this.getExtension().getName());
        }
        if (name.equals(P_POINT)) {
            return this.getNonzeroValue(this.getExtension().getPoint());
        }
        return "";
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    public void resetPropertyValue(Object property) {
    }

    public void setExtension(IPluginExtension newExtension) {
        this.object = newExtension;
    }

    public void setPropertyValue(Object name, Object value) {
        String svalue = value.toString();
        IPluginExtension ex = (IPluginExtension)this.object;
        if (svalue.length() == 0) {
            svalue = null;
        }
        try {
            if (name.equals(P_ID)) {
                ex.setId(svalue);
            } else if (name.equals(P_NAME)) {
                ex.setName(svalue);
            } else if (name.equals(P_POINT)) {
                ex.setPoint(svalue);
            }
        }
        catch (CoreException e) {
            System.out.println((Object)e);
        }
    }

    class PropertyLabelProvider
    extends LabelProvider {
        private Image image;
        private String name;

        public PropertyLabelProvider(String name, Image image) {
            this.image = image;
            this.name = name;
        }

        public String getText(Object obj) {
            Object value = ExtensionPropertySource.this.getPropertyValue(this.name);
            return value != null ? value.toString() : "";
        }

        public Image getImage(Object obj) {
            return this.image;
        }
    }
}

