/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestFormPage;
import org.eclipse.pde.internal.ui.preferences.MainPreferencePage;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.layout.RowLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.IFormPage;
import org.eclipse.update.ui.forms.internal.IHyperlinkListener;
import org.eclipse.update.ui.forms.internal.SelectableFormLabel;

public class ExtensionPointSection
extends PDEFormSection
implements IHyperlinkListener,
IModelChangedListener {
    private FormWidgetFactory factory;
    private Composite pointParent;
    private boolean needsUpdate;
    public static final String SECTION_TITLE = "ManifestEditor.ExtensionPointSection.title";
    public static final String SECTION_MORE = "ManifestEditor.ExtensionPointSection.more";
    public static final String SECTION_DESC = "ManifestEditor.ExtensionPointSection.desc";
    public static final String SECTION_FDESC = "ManifestEditor.ExtensionPointSection.fdesc";
    private Button moreButton;

    public ExtensionPointSection(ManifestFormPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        boolean fragment = ((ManifestEditor)page.getEditor()).isFragmentEditor();
        if (fragment) {
            this.setDescription(PDEPlugin.getResourceString(SECTION_FDESC));
        } else {
            this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        }
    }

    private void addExtensionPointLink(IPluginExtensionPoint point) {
        String name;
        Label imageLabel = this.factory.createLabel(this.pointParent, "");
        String tooltip = name = point.getId();
        if (MainPreferencePage.isFullNameModeEnabled()) {
            name = point.getTranslatedName();
        } else {
            tooltip = point.getTranslatedName();
        }
        SelectableFormLabel hyperlink = this.factory.createSelectableLabel(this.pointParent, name);
        this.factory.turnIntoHyperlink((Control)hyperlink, (IHyperlinkListener)this);
        hyperlink.setToolTipText(tooltip);
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        Image image = provider.get(PDEPluginImages.DESC_EXT_POINT_OBJ);
        imageLabel.setImage(image);
        hyperlink.setData((Object)point);
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.factory = factory;
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        layout.verticalSpacing = 2;
        this.pointParent = factory.createComposite(container);
        RowLayout rlayout = new RowLayout();
        rlayout.wrap = true;
        this.pointParent.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        this.pointParent.setLayoutData((Object)gd);
        Composite buttonContainer = factory.createComposite(container);
        gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        this.moreButton = factory.createButton(buttonContainer, PDEPlugin.getResourceString(SECTION_MORE), 8);
        gd = new GridData(34);
        this.moreButton.setLayoutData((Object)gd);
        final IPDEEditorPage targetPage = this.getFormPage().getEditor().getPage("ExtensionPointPage");
        this.moreButton.setToolTipText(((IFormPage)targetPage).getTitle());
        this.moreButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ExtensionPointSection.this.getFormPage().getEditor().showPage(targetPage);
            }
        });
        return container;
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        this.update(false);
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void linkActivated(Control linkLabel) {
        IPluginExtensionPoint point = (IPluginExtensionPoint)linkLabel.getData();
        this.getFormPage().getEditor().showPage("ExtensionPointPage", point);
    }

    public void linkEntered(Control linkLabel) {
        IPDEEditorPage page = this.getFormPage().getEditor().getPage("ExtensionPointPage");
        IPluginExtensionPoint point = (IPluginExtensionPoint)linkLabel.getData();
        String status = String.valueOf(((PDEFormPage)page).getStatusText()) + "#" + point.getName();
        IStatusLineManager manager = this.getFormPage().getEditor().getStatusLineManager();
        if (manager != null) {
            manager.setMessage(status);
        }
    }

    public void linkExited(Control linkLabel) {
        IStatusLineManager manager = this.getFormPage().getEditor().getStatusLineManager();
        if (manager != null) {
            manager.setMessage("");
        }
    }

    public void modelChanged(IModelChangedEvent event) {
        Object[] objects;
        int type = event.getChangeType();
        if (type == 99) {
            this.needsUpdate = true;
        } else if ((type == 1 || type == 2) && (objects = event.getChangedObjects())[0] instanceof IPluginExtensionPoint) {
            this.needsUpdate = true;
        }
        if (this.getFormPage().isVisible()) {
            this.update();
        }
    }

    public void update() {
        if (this.needsUpdate) {
            this.update(true);
        }
    }

    public void update(boolean removePrevious) {
        if (removePrevious) {
            Control[] children = this.pointParent.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].dispose();
                ++i;
            }
        }
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IPluginBase plugin = model.getPluginBase();
        IPluginExtensionPoint[] points = plugin.getExtensionPoints();
        int i = 0;
        while (i < points.length) {
            this.addExtensionPointLink(points[i]);
            ++i;
        }
        if (removePrevious) {
            this.pointParent.layout(true);
            this.pointParent.redraw();
        }
        this.needsUpdate = false;
    }
}

