/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginAttribute;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginExtension;
import org.eclipse.pde.core.plugin.IPluginExtensionPoint;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.IPluginObject;
import org.eclipse.pde.core.plugin.IPluginParent;
import org.eclipse.pde.internal.core.ExternalModelManager;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.ischema.ISchema;
import org.eclipse.pde.internal.core.ischema.ISchemaElement;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.eclipse.pde.internal.core.plugin.PluginElement;
import org.eclipse.pde.internal.core.plugin.PluginExtension;
import org.eclipse.pde.internal.core.plugin.PluginParent;
import org.eclipse.pde.internal.core.schema.SchemaRegistry;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PropertiesAction;
import org.eclipse.pde.internal.ui.editor.TreeSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestExtensionsPage;
import org.eclipse.pde.internal.ui.editor.manifest.NewElementAction;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.TreePart;
import org.eclipse.pde.internal.ui.preferences.MainPreferencePage;
import org.eclipse.pde.internal.ui.search.PluginSearchActionGroup;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.pde.internal.ui.wizards.extension.NewExtensionWizard;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.actions.ActionContext;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class DetailExtensionSection
extends TreeSection
implements IModelChangedListener {
    private TreeViewer extensionTree;
    private FormWidgetFactory factory;
    private Image extensionImage;
    public static final String SECTION_TITLE = "ManifestEditor.DetailExtensionSection.title";
    public static final String SECTION_NEW = "ManifestEditor.DetailExtensionSection.new";
    public static final String SECTION_SHOW_CHILDREN = "ManifestEditor.DetailExtensionSection.showAllChildren";
    public static final String POPUP_NEW = "Menus.new.label";
    public static final String POPUP_NEW_EXTENSION = "ManifestEditor.DetailExtensionSection.newExtension";
    public static final String POPUP_COLLAPSE_ALL = "ManifestEditor.DetailExtensionSection.collapseAll";
    public static final String POPUP_GO_TO = "Menus.goTo.label";
    public static final String POPUP_DELETE = "Actions.delete.label";
    private static final String SETTING_SHOW_ALL = "DetailExtensionSection.showAllChildren";
    private Image genericElementImage;
    private SchemaRegistry schemaRegistry;
    private ExternalModelManager pluginInfoRegistry;
    private DrillDownAdapter drillDownAdapter;
    private Action newExtensionAction;
    private Action collapseAllAction;
    private static final String[] COMMON_LABEL_PROPERTIES = new String[]{"label", "name", "id"};
    public static final String SECTION_DOWN = "ManifestEditor.DetailExtensionSection.down";
    public static final String SECTION_UP = "ManifestEditor.DetailExtensionSection.up";

    public DetailExtensionSection(ManifestExtensionsPage page) {
        String[] stringArray = new String[4];
        stringArray[0] = PDEPlugin.getResourceString(SECTION_NEW);
        stringArray[2] = PDEPlugin.getResourceString(SECTION_UP);
        stringArray[3] = PDEPlugin.getResourceString(SECTION_DOWN);
        super(page, stringArray);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.schemaRegistry = PDECore.getDefault().getSchemaRegistry();
        this.pluginInfoRegistry = PDECore.getDefault().getExternalModelManager();
        this.handleDefaultButton = false;
    }

    private static void addItemsForExtensionWithSchema(MenuManager menu, IPluginExtension extension, IPluginParent parent) {
        String tagName;
        ISchema schema = ((PluginExtension)extension).getSchema();
        ISchemaElement elementInfo = schema.findElement(tagName = parent == extension ? "extension" : parent.getName());
        if (elementInfo == null) {
            return;
        }
        ISchemaElement[] candidates = schema.getCandidateChildren(elementInfo);
        int i = 0;
        while (i < candidates.length) {
            ISchemaElement candidateInfo = candidates[i];
            NewElementAction action = new NewElementAction(candidateInfo, parent);
            menu.add((IAction)action);
            ++i;
        }
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.factory = factory;
        this.initializeImages();
        Composite container = this.createClientContainer(parent, 2, factory);
        TreePart treePart = this.getTreePart();
        this.createViewerPartControl(container, 2, 2, factory);
        this.extensionTree = treePart.getTreeViewer();
        this.extensionTree.setAutoExpandLevel(-1);
        this.extensionTree.setContentProvider((IContentProvider)new ExtensionContentProvider());
        this.extensionTree.setLabelProvider((IBaseLabelProvider)new ExtensionLabelProvider());
        this.drillDownAdapter = new DrillDownAdapter(this.extensionTree);
        factory.paintBordersFor(container);
        return container;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        Object item = selection.getFirstElement();
        this.fireSelectionNotification(item);
        this.getFormPage().setSelection((ISelection)selection);
        this.updateUpDownButtons(item);
    }

    protected void handleDoubleClick(IStructuredSelection selection) {
        PropertiesAction action = new PropertiesAction(this.getFormPage().getEditor());
        action.run();
    }

    protected void buttonSelected(int index) {
        switch (index) {
            case 0: {
                this.handleNew();
                break;
            }
            case 1: 
            case 2: {
                this.handleMove(true);
                break;
            }
            case 3: {
                this.handleMove(false);
            }
        }
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals("delete")) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals("cut")) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals("paste")) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public void expandTo(Object object) {
        this.extensionTree.setSelection((ISelection)new StructuredSelection(object), true);
    }

    protected void fillContextMenu(IMenuManager manager) {
        Object object;
        ISelection selection = this.extensionTree.getSelection();
        IStructuredSelection ssel = (IStructuredSelection)selection;
        MenuManager newMenu = null;
        if (ssel.size() == 1) {
            IPluginParent parent;
            object = ssel.getFirstElement();
            if (object instanceof IPluginParent && (parent = (IPluginParent)object).getModel().getUnderlyingResource() != null) {
                newMenu = DetailExtensionSection.fillContextMenu(this.getFormPage(), parent, manager);
                manager.add((IContributionItem)new Separator());
            }
        } else if (ssel.size() > 1) {
            Action delAction = new Action(){

                public void run() {
                    DetailExtensionSection.this.handleDelete();
                }
            };
            delAction.setText(PDEPlugin.getResourceString(POPUP_DELETE));
            manager.add((IAction)delAction);
            manager.add((IContributionItem)new Separator());
            delAction.setEnabled(!this.isReadOnly());
        }
        if (newMenu == null) {
            newMenu = new MenuManager(PDEPlugin.getResourceString(POPUP_NEW));
            manager.add((IContributionItem)newMenu);
        }
        if (!newMenu.isEmpty()) {
            newMenu.add((IContributionItem)new Separator());
        }
        newMenu.add((IAction)this.newExtensionAction);
        manager.add((IContributionItem)new Separator());
        this.drillDownAdapter.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.collapseAllAction);
        manager.add((IContributionItem)new Separator());
        this.getFormPage().getEditor().getContributor().addClipboardActions(manager);
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager, false);
        if (ssel.size() == 1) {
            manager.add((IContributionItem)new Separator());
            object = ssel.getFirstElement();
            if (object instanceof IPluginExtension) {
                PluginSearchActionGroup actionGroup = new PluginSearchActionGroup();
                actionGroup.setContext(new ActionContext(selection));
                actionGroup.fillContextMenu(manager);
                manager.add((IContributionItem)new Separator());
            }
            manager.add((IAction)new PropertiesAction(this.getFormPage().getEditor()));
        }
    }

    static IMenuManager fillContextMenu(PDEFormPage page, IPluginParent parent, IMenuManager manager) {
        return DetailExtensionSection.fillContextMenu(page, parent, manager, false);
    }

    static IMenuManager fillContextMenu(PDEFormPage page, IPluginParent parent, IMenuManager manager, boolean addSiblingItems) {
        return DetailExtensionSection.fillContextMenu(page, parent, manager, addSiblingItems, true);
    }

    static IMenuManager fillContextMenu(PDEFormPage page, final IPluginParent parent, IMenuManager manager, boolean addSiblingItems, boolean fullMenu) {
        MenuManager menu = new MenuManager(PDEPlugin.getResourceString(POPUP_NEW));
        IPluginExtension extension = DetailExtensionSection.getExtension(parent);
        ISchema schema = ((PluginExtension)extension).getSchema();
        if (schema == null) {
            menu.add((IAction)new NewElementAction(null, parent));
        } else {
            IPluginObject parentsParent;
            DetailExtensionSection.addItemsForExtensionWithSchema(menu, extension, parent);
            if (addSiblingItems && !((parentsParent = parent.getParent()) instanceof IPluginExtension)) {
                IPluginParent pparent = (IPluginParent)parentsParent;
                menu.add((IContributionItem)new Separator());
                DetailExtensionSection.addItemsForExtensionWithSchema(menu, extension, pparent);
            }
        }
        manager.add((IContributionItem)menu);
        manager.add((IContributionItem)new Separator());
        if (fullMenu) {
            Action deleteAction = new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

                public void run() {
                    try {
                        IPluginObject parentsParent = parent.getParent();
                        if (parent instanceof IPluginExtension) {
                            IPluginBase plugin = (IPluginBase)parentsParent;
                            plugin.remove((IPluginExtension)parent);
                        } else {
                            IPluginParent parentElement = (IPluginParent)parent.getParent();
                            parentElement.remove((IPluginObject)parent);
                        }
                    }
                    catch (CoreException coreException) {}
                }
            };
            deleteAction.setEnabled(((IModel)page.getModel()).isEditable());
            manager.add((IAction)deleteAction);
        }
        return menu;
    }

    static IPluginExtension getExtension(IPluginParent parent) {
        while (parent != null && !(parent instanceof IPluginExtension)) {
            parent = (IPluginParent)parent.getParent();
        }
        return (IPluginExtension)parent;
    }

    private void handleDelete() {
        IStructuredSelection sel = (IStructuredSelection)this.extensionTree.getSelection();
        if (sel.isEmpty()) {
            return;
        }
        Iterator iter = sel.iterator();
        while (iter.hasNext()) {
            IPluginObject object = (IPluginObject)iter.next();
            try {
                if (object instanceof IPluginElement) {
                    IPluginElement ee = (IPluginElement)object;
                    IPluginParent parent = (IPluginParent)ee.getParent();
                    parent.remove((IPluginObject)ee);
                    continue;
                }
                if (!(object instanceof IPluginExtension)) continue;
                IPluginExtension extension = (IPluginExtension)object;
                IPluginBase plugin = extension.getPluginBase();
                plugin.remove(extension);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    void handleNew() {
        IFile file = ((IFileEditorInput)this.getFormPage().getEditor().getEditorInput()).getFile();
        final IProject project = file.getProject();
        BusyIndicator.showWhile((Display)this.extensionTree.getTree().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                NewExtensionWizard wizard = new NewExtensionWizard(project, (IPluginModelBase)DetailExtensionSection.this.getFormPage().getModel());
                WizardDialog dialog = new WizardDialog(PDEPlugin.getActiveWorkbenchShell(), (IWizard)wizard);
                dialog.create();
                SWTUtil.setDialogSize((Dialog)dialog, 500, 500);
                dialog.open();
            }
        });
    }

    private void handleCollapseAll() {
        this.getTreePart().getTreeViewer().collapseAll();
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        this.extensionTree.setInput((Object)model.getPluginBase());
        boolean editable = model.isEditable();
        this.setReadOnly(!editable);
        TreePart treePart = this.getTreePart();
        treePart.setButtonEnabled(0, editable);
        treePart.setButtonEnabled(2, false);
        treePart.setButtonEnabled(3, false);
        model.addModelChangedListener((IModelChangedListener)this);
        this.newExtensionAction = new Action(){

            public void run() {
                DetailExtensionSection.this.handleNew();
            }
        };
        this.newExtensionAction.setText(PDEPlugin.getResourceString(POPUP_NEW_EXTENSION));
        this.newExtensionAction.setImageDescriptor(PDEPluginImages.DESC_EXTENSION_OBJ);
        this.newExtensionAction.setEnabled(editable);
        this.collapseAllAction = new Action(){

            public void run() {
                DetailExtensionSection.this.handleCollapseAll();
            }
        };
        this.collapseAllAction.setText(PDEPlugin.getResourceString(POPUP_COLLAPSE_ALL));
    }

    public void initializeImages() {
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        this.extensionImage = provider.get(PDEPluginImages.DESC_EXTENSION_OBJ);
        this.genericElementImage = provider.get(PDEPluginImages.DESC_GENERIC_XML_OBJ);
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.extensionTree.refresh();
            return;
        }
        Object changeObject = event.getChangedObjects()[0];
        if (changeObject instanceof IPluginBase && event.getChangeType() == 3 && event.getChangedProperty().equals("extension_order")) {
            IStructuredSelection sel = (IStructuredSelection)this.extensionTree.getSelection();
            IPluginExtension extension = (IPluginExtension)sel.getFirstElement();
            this.extensionTree.refresh();
            this.extensionTree.setSelection((ISelection)new StructuredSelection((Object)extension));
            return;
        }
        if (changeObject instanceof IPluginExtension || changeObject instanceof IPluginElement) {
            IPluginObject pobj = (IPluginObject)changeObject;
            IPluginObject parent = pobj.getParent();
            if (event.getChangeType() == 1) {
                this.extensionTree.add((Object)parent, (Object)pobj);
                this.extensionTree.setSelection((ISelection)new StructuredSelection(changeObject), true);
                this.extensionTree.getTree().setFocus();
                this.asyncResendSelection(this.getFormPage().getSelection());
            } else if (event.getChangeType() == 2) {
                this.extensionTree.remove((Object)pobj);
            } else if (event.getChangedProperty().equals("sibling_order")) {
                IStructuredSelection sel = (IStructuredSelection)this.extensionTree.getSelection();
                IPluginObject child = (IPluginObject)sel.getFirstElement();
                this.extensionTree.refresh((Object)child.getParent());
                this.extensionTree.setSelection((ISelection)new StructuredSelection((Object)child));
            } else {
                IStructuredSelection ssel;
                ISelection sel;
                this.extensionTree.update(changeObject, null);
                if (this.extensionTree.getTree().isFocusControl() && (sel = this.getFormPage().getSelection()) != null && sel instanceof IStructuredSelection && !(ssel = (IStructuredSelection)sel).isEmpty() && ssel.getFirstElement().equals(changeObject)) {
                    this.asyncResendSelection(sel);
                }
            }
        }
    }

    private void asyncResendSelection(final ISelection sel) {
        this.extensionTree.getControl().getDisplay().asyncExec(new Runnable(){

            public void run() {
                DetailExtensionSection.this.getFormPage().setSelection(sel);
            }
        });
    }

    private Image resolveObjectImage(Object obj) {
        if (obj instanceof IPluginExtension) {
            return this.extensionImage;
        }
        Image elementImage = this.genericElementImage;
        if (obj instanceof IPluginElement) {
            boolean hasBodyText;
            IPluginElement element = (IPluginElement)obj;
            Image customImage = DetailExtensionSection.getCustomImage(element);
            if (customImage != null) {
                elementImage = customImage;
            }
            boolean bl = hasBodyText = element.getText() != null;
            if (hasBodyText) {
                elementImage = PDEPlugin.getDefault().getLabelProvider().get(elementImage, 8);
            }
        }
        return elementImage;
    }

    static Image getCustomImage(IPluginElement element) {
        ISchemaElement elementInfo = ((PluginElement)element).getElementInfo();
        if (elementInfo != null && elementInfo.getIconProperty() != null) {
            String iconProperty = elementInfo.getIconProperty();
            IPluginAttribute att = element.getAttribute(iconProperty);
            String iconPath = null;
            if (att != null && att.getValue() != null) {
                iconPath = att.getValue();
            }
            if (iconPath != null) {
                return DetailExtensionSection.getImageFromPlugin(element, iconPath);
            }
        }
        return null;
    }

    private static Image getImageFromPlugin(IPluginElement element, String iconPathName) {
        IPluginModelBase model = element.getModel();
        if (model == null) {
            return null;
        }
        URL modelURL = null;
        String path = model.getInstallLocation();
        IResource resource = model.getUnderlyingResource();
        if (resource != null) {
            IPath realPath = resource.getLocation().removeLastSegments(1);
            path = realPath.toOSString();
        }
        try {
            if (!path.startsWith("file:")) {
                path = "file:" + path;
            }
            modelURL = new URL(String.valueOf(path) + File.separator);
            return PDEPlugin.getDefault().getLabelProvider().getImageFromURL(modelURL, iconPathName);
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    private String resolveObjectName(Object obj) {
        return DetailExtensionSection.resolveObjectName(this.schemaRegistry, this.pluginInfoRegistry, obj);
    }

    public static String resolveObjectName(SchemaRegistry schemaRegistry, ExternalModelManager pluginInfoRegistry, Object obj) {
        boolean fullNames = MainPreferencePage.isFullNameModeEnabled();
        if (obj instanceof IPluginExtension) {
            IPluginExtension extension = (IPluginExtension)obj;
            if (!fullNames) {
                return extension.getPoint();
            }
            if (extension.getName() != null) {
                return extension.getTranslatedName();
            }
            ISchema schema = schemaRegistry.getSchema(extension.getPoint());
            if (schema != null) {
                return schema.getName();
            }
            IPluginExtensionPoint pointInfo = pluginInfoRegistry.findExtensionPoint(extension.getPoint());
            if (pointInfo != null) {
                return pointInfo.getResourceString(pointInfo.getName());
            }
        } else if (obj instanceof IPluginElement) {
            String baseName = obj.toString();
            PluginElement element = (PluginElement)obj;
            String fullName = null;
            ISchemaElement elementInfo = element.getElementInfo();
            IPluginAttribute labelAtt = null;
            if (elementInfo != null && elementInfo.getLabelProperty() != null) {
                labelAtt = element.getAttribute(elementInfo.getLabelProperty());
            }
            if (labelAtt == null) {
                int i = 0;
                while (i < COMMON_LABEL_PROPERTIES.length) {
                    labelAtt = element.getAttribute(COMMON_LABEL_PROPERTIES[i]);
                    if (labelAtt != null) break;
                    ++i;
                }
                if (labelAtt == null && element.getAttributeCount() == 1) {
                    labelAtt = element.getAttributes()[0];
                }
            }
            if (labelAtt != null && labelAtt.getValue() != null) {
                fullName = DetailExtensionSection.stripShortcuts(labelAtt.getValue());
            }
            fullName = element.getResourceString(fullName);
            if (fullNames) {
                return fullName != null ? fullName : baseName;
            }
            return fullName != null ? String.valueOf(fullName) + " (" + baseName + ")" : baseName;
        }
        return obj.toString();
    }

    public void setFocus() {
        if (this.extensionTree != null) {
            this.extensionTree.getTree().setFocus();
        }
    }

    public static String stripShortcuts(String input) {
        StringBuffer output = new StringBuffer();
        int i = 0;
        while (i < input.length()) {
            char c = input.charAt(i);
            if (c != '&') {
                if (c == '@') break;
                output.append(c);
            }
            ++i;
        }
        return output.toString();
    }

    protected boolean canPaste(Object target, Object[] objects) {
        if (objects[0] instanceof IPluginExtension) {
            return true;
        }
        return objects[0] instanceof IPluginElement && target instanceof IPluginParent;
    }

    protected void doPaste(Object target, Object[] objects) {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        IPluginBase plugin = model.getPluginBase();
        try {
            int i = 0;
            while (i < objects.length) {
                Object obj = objects[i];
                if (obj instanceof IPluginExtension) {
                    IPluginExtension extension = (IPluginExtension)obj;
                    ((PluginExtension)extension).setModel(model);
                    ((PluginExtension)extension).setParent((IPluginObject)plugin);
                    plugin.add(extension);
                    ((PluginParent)extension).reconnect();
                } else if (obj instanceof IPluginElement && target instanceof IPluginParent) {
                    PluginElement element = (PluginElement)obj;
                    element.setModel(model);
                    element.setParent((IPluginObject)((IPluginParent)target));
                    ((IPluginParent)target).add((IPluginObject)element);
                    if (element instanceof PluginParent) {
                        element.reconnect();
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    private void handleMove(boolean up) {
        IStructuredSelection sel = (IStructuredSelection)this.extensionTree.getSelection();
        IPluginObject object = (IPluginObject)sel.getFirstElement();
        if (object instanceof IPluginElement) {
            IPluginParent parent = (IPluginParent)object.getParent();
            IPluginObject[] children = parent.getChildren();
            int index = parent.getIndexOf(object);
            int newIndex = up ? index - 1 : index + 1;
            IPluginObject child2 = children[newIndex];
            try {
                parent.swap(object, child2);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        } else if (object instanceof IPluginExtension) {
            IPluginExtension extension = (IPluginExtension)object;
            PluginBase plugin = (PluginBase)extension.getPluginBase();
            IPluginExtension[] extensions = plugin.getExtensions();
            int index = plugin.getIndexOf(extension);
            int newIndex = up ? index - 1 : index + 1;
            IPluginExtension e2 = extensions[newIndex];
            try {
                plugin.swap(extension, e2);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void updateUpDownButtons(Object item) {
        if (this.isReadOnly()) {
            return;
        }
        boolean upEnabled = false;
        boolean downEnabled = false;
        if (item != null) {
            if (item instanceof IPluginElement) {
                IPluginElement element = (IPluginElement)item;
                IPluginParent parent = (IPluginParent)element.getParent();
                int index = parent.getIndexOf((IPluginObject)element);
                if (index > 0) {
                    upEnabled = true;
                }
                if (index < parent.getChildCount() - 1) {
                    downEnabled = true;
                }
            } else if (item instanceof IPluginExtension) {
                IPluginExtension extension = (IPluginExtension)item;
                PluginBase pluginBase = (PluginBase)extension.getParent();
                int index = pluginBase.getIndexOf(extension);
                int size = pluginBase.getExtensionCount();
                if (index > 0) {
                    upEnabled = true;
                }
                if (index < size - 1) {
                    downEnabled = true;
                }
            }
        }
        this.getTreePart().setButtonEnabled(2, upEnabled);
        this.getTreePart().setButtonEnabled(3, downEnabled);
    }

    class ExtensionContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        ExtensionContentProvider() {
        }

        public Object[] getChildren(Object parent) {
            Object[] children = null;
            if (parent instanceof IPluginBase) {
                children = ((IPluginBase)parent).getExtensions();
            } else if (parent instanceof IPluginExtension) {
                children = ((IPluginExtension)parent).getChildren();
            } else if (parent instanceof IPluginElement) {
                children = ((IPluginElement)parent).getChildren();
            }
            if (children == null) {
                children = new Object[]{};
            }
            return children;
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }

        public Object getParent(Object child) {
            if (child instanceof IPluginObject) {
                return ((IPluginObject)child).getParent();
            }
            return null;
        }

        public Object[] getElements(Object parent) {
            return this.getChildren(parent);
        }
    }

    class ExtensionLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        ExtensionLabelProvider() {
        }

        public String getColumnText(Viewer v, Object obj, int index) {
            return this.getColumnText(obj, index);
        }

        public String getText(Object obj) {
            return this.getColumnText(obj, 1);
        }

        public Image getImage(Object obj) {
            return this.getColumnImage(obj, 1);
        }

        public String getColumnText(Object obj, int index) {
            if (index == 1) {
                return DetailExtensionSection.this.resolveObjectName(obj);
            }
            return "";
        }

        public Image getColumnImage(Object obj, int index) {
            if (index == 1) {
                return DetailExtensionSection.this.resolveObjectImage(obj);
            }
            return null;
        }

        public Image getColumnImage(Viewer v, Object obj, int index) {
            return this.getColumnImage(obj, index);
        }
    }
}

