/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.manifest.ImportListSection;
import org.eclipse.pde.internal.ui.editor.manifest.ImportStatusSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestDependenciesPage;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestEditor;
import org.eclipse.pde.internal.ui.editor.manifest.MatchSection;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.ui.forms.internal.AbstractForm;
import org.eclipse.update.ui.forms.internal.FormSection;
import org.eclipse.update.ui.forms.internal.ScrollableSectionForm;
import org.eclipse.update.ui.forms.internal.SectionChangeManager;

public class DependenciesForm
extends ScrollableSectionForm {
    public static final String TITLE = "ManifestEditor.DependenciesForm.title";
    private ManifestDependenciesPage page;
    private ImportListSection importListSection;
    private MatchSection matchSection;
    private ImportStatusSection importStatusSection;

    public DependenciesForm(ManifestDependenciesPage page) {
        this.page = page;
        this.setVerticalFit(true);
        this.setScrollable(true);
    }

    public void commitChanges(boolean onSave) {
        if (this.importListSection == null) {
            return;
        }
        if (onSave || this.importListSection.isDirty()) {
            this.importListSection.commitChanges(onSave);
        }
    }

    protected void createFormClient(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginWidth = 10;
        layout.horizontalSpacing = 15;
        parent.setLayout((Layout)layout);
        this.importListSection = new ImportListSection(this.page);
        Control control = this.importListSection.createControl(parent, this.getFactory());
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        Composite column = ((AbstractForm)this).factory.createComposite(parent);
        gd = new GridData(1808);
        column.setLayoutData((Object)gd);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        column.setLayout((Layout)layout);
        this.matchSection = new MatchSection(this.page);
        control = this.matchSection.createControl(column, this.getFactory());
        gd = new GridData(784);
        control.setLayoutData((Object)gd);
        if (!((ManifestEditor)this.page.getEditor()).isFragmentEditor()) {
            this.importStatusSection = new ImportStatusSection(this.page);
            control = this.importStatusSection.createControl(column, this.getFactory());
            gd = new GridData(1808);
            control.setLayoutData((Object)gd);
        }
        SectionChangeManager manager = new SectionChangeManager();
        manager.linkSections((FormSection)this.importListSection, (FormSection)this.matchSection);
        this.registerSection(this.importListSection);
        this.registerSection(this.matchSection);
        if (!((ManifestEditor)this.page.getEditor()).isFragmentEditor()) {
            this.registerSection(this.importStatusSection);
        }
        if (((ManifestEditor)this.page.getEditor()).isFragmentEditor()) {
            WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.pde.doc.user.manifest_fragment_dependencies");
        } else {
            WorkbenchHelp.setHelp((Control)parent, (String)"org.eclipse.pde.doc.user.manifest_plugin_dependencies");
        }
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        this.setHeadingText(PDEPlugin.getResourceString(TITLE));
        super.initialize((Object)model);
        ((Composite)this.getControl()).layout(true);
    }

    public void expandTo(Object object) {
        this.importListSection.expandTo(object);
    }

    public boolean fillContextMenu(IMenuManager manager) {
        IResource resource = ((IPluginModelBase)this.page.getModel()).getUnderlyingResource();
        if (resource != null && WorkspaceModelManager.isJavaPluginProject((IProject)resource.getProject())) {
            manager.add((IAction)this.importListSection.getBuildpathAction());
            manager.add((IContributionItem)new Separator());
        }
        return true;
    }
}

