/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.manifest;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.plugin.IPluginElement;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.manifest.ManifestExtensionsPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.ui.forms.internal.FormSection;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class BodyTextSection
extends PDEFormSection
implements IModelChangedListener {
    public static final String SECTION_TITLE = "ManifestEditor.BodyTextSection.title";
    public static final String SECTION_TITLE_FULL = "ManifestEditor.BodyTextSection.titleFull";
    public static final String KEY_APPLY = "Actions.apply.flabel";
    public static final String KEY_RESET = "Actions.reset.flabel";
    public static final String KEY_DELETE = "Actions.delete.flabel";
    private FormWidgetFactory factory;
    private Button applyButton;
    private Button resetButton;
    private IPluginElement currentElement;
    private Text text;
    private Color contentColor;

    public BodyTextSection(ManifestExtensionsPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
    }

    private void updateTitle(boolean hasContents) {
        String title = hasContents ? PDEPlugin.getResourceString(SECTION_TITLE_FULL) : PDEPlugin.getResourceString(SECTION_TITLE);
        this.setHeaderText(title);
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.factory = factory;
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.marginHeight = 2;
        layout.marginWidth = 2;
        container.setLayout((Layout)layout);
        this.text = factory.createText(container, "", 578);
        this.text.setEditable(false);
        GridData gd = new GridData(1808);
        this.text.setLayoutData((Object)gd);
        this.text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BodyTextSection.this.applyButton.setEnabled(true);
                BodyTextSection.this.resetButton.setEnabled(true);
            }
        });
        Composite buttonContainer = factory.createComposite(container);
        layout = new GridLayout();
        layout.marginHeight = 0;
        buttonContainer.setLayout((Layout)layout);
        gd = new GridData(48);
        buttonContainer.setLayoutData((Object)gd);
        this.applyButton = factory.createButton(buttonContainer, PDEPlugin.getResourceString(KEY_APPLY), 8);
        gd = new GridData(770);
        this.applyButton.setLayoutData((Object)gd);
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BodyTextSection.this.handleApply();
            }
        });
        this.resetButton = factory.createButton(buttonContainer, PDEPlugin.getResourceString(KEY_RESET), 8);
        gd = new GridData(770);
        this.resetButton.setLayoutData((Object)gd);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BodyTextSection.this.handleReset();
            }
        });
        if (!SWT.getPlatform().equals("motif")) {
            factory.paintBordersFor(container);
        }
        return container;
    }

    public void dispose() {
        IPluginModelBase model = (IPluginModelBase)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals("delete")) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals("cut")) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals("selectAll")) {
            this.text.selectAll();
            return true;
        }
        if (actionId.equals("copy")) {
            this.text.copy();
            return true;
        }
        if (actionId.equals("paste")) {
            this.text.paste();
            return true;
        }
        return false;
    }

    private void handleDelete() {
        this.text.cut();
    }

    private void handleApply() {
        try {
            this.currentElement.setText(this.text.getText().length() > 0 ? this.text.getText() : null);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.applyButton.setEnabled(false);
    }

    private void handleReset() {
        this.updateText(this.currentElement);
        this.resetButton.setEnabled(false);
        this.applyButton.setEnabled(false);
    }

    public void initialize(Object input) {
        IPluginModelBase model = (IPluginModelBase)input;
        model.addModelChangedListener((IModelChangedListener)this);
        this.setReadOnly(!model.isEditable());
        this.text.setEditable(model.isEditable());
        this.updateInput();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            return;
        }
    }

    public void sectionChanged(FormSection source, int changeType, Object changeObject) {
        if (this.currentElement != null && this.currentElement == changeObject) {
            return;
        }
        this.currentElement = changeObject instanceof IPluginElement ? (IPluginElement)changeObject : null;
        this.updateInput();
    }

    private void updateInput() {
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.updateText(this.currentElement);
        this.text.setEditable(!this.isReadOnly() && this.currentElement != null);
    }

    private void updateText(IPluginElement element) {
        String bodyText = element != null ? element.getText() : null;
        this.text.setText(bodyText != null ? bodyText : "");
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.updateTitle(bodyText != null);
    }
}

