/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.feature.FeatureURLElement;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.core.ifeature.IFeatureURL;
import org.eclipse.pde.internal.core.ifeature.IFeatureURLElement;
import org.eclipse.pde.internal.ui.PDELabelProvider;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.ModelDataTransfer;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.PropertiesAction;
import org.eclipse.pde.internal.ui.editor.feature.FeatureFormPage;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class URLSection
extends PDEFormSection {
    public static final String SECTION_TITLE = "FeatureEditor.URLSection.title";
    public static final String POPUP_NEW = "Menus.new.label";
    public static final String POPUP_DELETE = "Actions.delete.label";
    public static final String POPUP_UPDATE_URL = "FeatureEditor.URLSection.updateURL";
    public static final String POPUP_DISCOVERY_URL = "FeatureEditor.URLSection.discoveryURL";
    public static final String SECTION_DESC = "FeatureEditor.URLSection.desc";
    public static final String NEW_UPDATE_SITE = "FeatureEditor.URLSection.newUpdateSite";
    public static final String NEW_DISCOVERY_SITE = "FeatureEditor.URLSection.newDiscoverySite";
    public static final String KEY_UPDATE_URLS = "FeatureEditor.URLSection.updateURLs";
    public static final String KEY_DISCOVERY_URLS = "FeatureEditor.URLSection.discoveryURLs";
    public static final String NEW_URL = "FeatureEditor.URLSection.newURL";
    private boolean updateNeeded;
    private TreeViewer urlTree;
    private Image urlImage;
    private Image urlFolderImage;
    private PropertiesAction propertiesAction;
    private URLFolder[] folders = new URLFolder[]{new URLFolder(1), new URLFolder(2)};

    public URLSection(FeatureFormPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
        PDELabelProvider provider = PDEPlugin.getDefault().getLabelProvider();
        this.urlImage = provider.get(PDEPluginImages.DESC_LINK_OBJ);
        this.urlFolderImage = provider.get(PDEPluginImages.DESC_LINKS_OBJ);
    }

    public void commitChanges(boolean onSave) {
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Tree tree = factory.createTree(container, 0);
        this.urlTree = new TreeViewer(tree);
        this.urlTree.setContentProvider((IContentProvider)new URLContentProvider());
        this.urlTree.setLabelProvider((IBaseLabelProvider)new URLLabelProvider());
        this.urlTree.setAutoExpandLevel(-1);
        this.urlTree.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                URLSection.this.getFormPage().setSelection(e.getSelection());
            }
        });
        this.urlTree.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                URLSection.this.propertiesAction.run();
            }
        });
        MenuManager popupMenuManager = new MenuManager();
        IMenuListener listener = new IMenuListener(){

            public void menuAboutToShow(IMenuManager mng) {
                URLSection.this.fillContextMenu(mng);
            }
        };
        popupMenuManager.addMenuListener(listener);
        popupMenuManager.setRemoveAllWhenShown(true);
        Menu menu = popupMenuManager.createContextMenu((Control)this.urlTree.getTree());
        this.urlTree.getTree().setMenu(menu);
        GridData gd = new GridData(1808);
        gd.heightHint = 100;
        tree.setLayoutData((Object)gd);
        factory.paintBordersFor(container);
        this.propertiesAction = new PropertiesAction(this.getFormPage().getEditor());
        return container;
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals("delete")) {
            this.handleDelete();
            return true;
        }
        if (actionId.equals("cut")) {
            this.handleDelete();
            return false;
        }
        if (actionId.equals("paste")) {
            this.doPaste();
            return true;
        }
        return false;
    }

    public void expandTo(Object object) {
        this.urlTree.setSelection((ISelection)new StructuredSelection(object), true);
    }

    private void fillContextMenu(IMenuManager manager) {
        IModel model = (IModel)this.getFormPage().getModel();
        ISelection selection = this.urlTree.getSelection();
        Object object = ((IStructuredSelection)selection).getFirstElement();
        MenuManager submenu = new MenuManager(PDEPlugin.getResourceString(POPUP_NEW));
        Action updateUrl = new Action(PDEPlugin.getResourceString(POPUP_UPDATE_URL)){

            public void run() {
                URLSection.this.handleNewURL(1);
            }
        };
        updateUrl.setEnabled(model.isEditable());
        submenu.add((IAction)updateUrl);
        Action discoveryUrl = new Action(PDEPlugin.getResourceString(POPUP_DISCOVERY_URL)){

            public void run() {
                URLSection.this.handleNewURL(2);
            }
        };
        discoveryUrl.setEnabled(model.isEditable());
        submenu.add((IAction)discoveryUrl);
        manager.add((IContributionItem)submenu);
        if (object != null && object instanceof IFeatureURLElement) {
            manager.add((IContributionItem)new Separator());
            Action deleteAction = new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

                public void run() {
                    URLSection.this.handleDelete();
                }
            };
            deleteAction.setEnabled(model.isEditable());
            manager.add((IAction)deleteAction);
        }
        manager.add((IContributionItem)new Separator());
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.propertiesAction);
    }

    private void handleDelete() {
        Object object = ((IStructuredSelection)this.urlTree.getSelection()).getFirstElement();
        if (object != null && object instanceof IFeatureURLElement) {
            IFeatureURLElement urlElement = (IFeatureURLElement)object;
            IFeature feature = urlElement.getFeature();
            IFeatureURL url = feature.getURL();
            try {
                if (urlElement.getElementType() == 1) {
                    url.removeUpdate(urlElement);
                } else {
                    url.removeDiscovery(urlElement);
                }
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleNewURL(int type) {
        IFeatureModel model = (IFeatureModel)this.getFormPage().getModel();
        IFeature feature = model.getFeature();
        IFeatureURL url = feature.getURL();
        if (url == null) {
            url = model.getFactory().createURL();
            try {
                feature.setURL(url);
            }
            catch (CoreException coreException) {
                return;
            }
        }
        try {
            IFeatureURLElement element = model.getFactory().createURLElement(url, type);
            String label = type == 1 ? PDEPlugin.getResourceString(NEW_UPDATE_SITE) : PDEPlugin.getResourceString(NEW_DISCOVERY_SITE);
            element.setLabel(label);
            element.setURL(new URL(PDEPlugin.getResourceString(NEW_URL)));
            if (type == 1) {
                url.addUpdate(element);
            } else {
                url.addDiscovery(element);
            }
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        catch (MalformedURLException e) {
            PDEPlugin.logException(e);
        }
    }

    public void initialize(Object input) {
        IFeatureModel model = (IFeatureModel)input;
        this.update(input);
        model.isEditable();
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.updateNeeded = true;
            if (this.getFormPage().isVisible()) {
                this.update();
            }
        } else {
            Object obj = e.getChangedObjects()[0];
            if (obj instanceof IFeatureURLElement) {
                if (e.getChangeType() == 1) {
                    URLFolder parent = null;
                    IFeatureURLElement element = (IFeatureURLElement)obj;
                    parent = element.getElementType() == 1 ? this.folders[0] : this.folders[1];
                    this.urlTree.add((Object)parent, (Object)element);
                    this.urlTree.setSelection((ISelection)new StructuredSelection((Object)element), true);
                } else if (e.getChangeType() == 2) {
                    this.urlTree.remove(obj);
                } else {
                    this.urlTree.update(obj, null);
                }
            }
        }
    }

    public void setFocus() {
    }

    public void update() {
        if (this.updateNeeded) {
            this.update(this.getFormPage().getModel());
        }
    }

    public void update(Object input) {
        IFeatureModel model = (IFeatureModel)input;
        this.urlTree.setInput((Object)model);
        this.updateNeeded = false;
    }

    public boolean canPaste(Clipboard clipboard) {
        Object[] objects;
        IStructuredSelection ssel = (IStructuredSelection)this.urlTree.getSelection();
        if (ssel.size() != 1) {
            return false;
        }
        Object target = ssel.getFirstElement();
        if (target instanceof URLFolder && (objects = (Object[])clipboard.getContents((Transfer)ModelDataTransfer.getInstance())) != null && objects.length > 0) {
            return this.canPaste((URLFolder)target, objects);
        }
        return false;
    }

    protected boolean canPaste(URLFolder target, Object[] objects) {
        int i = 0;
        while (i < objects.length) {
            if (!(objects[i] instanceof FeatureURLElement) || ((FeatureURLElement)objects[i]).getElementType() != target.type) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void doPaste() {
        Clipboard clipboard;
        Object[] objects;
        IStructuredSelection ssel = (IStructuredSelection)this.urlTree.getSelection();
        if (ssel.size() != 1) {
            return;
        }
        Object target = ssel.getFirstElement();
        if (target instanceof URLFolder && (objects = (Object[])(clipboard = this.getFormPage().getEditor().getClipboard()).getContents((Transfer)ModelDataTransfer.getInstance())) != null) {
            this.doPaste((URLFolder)target, objects);
        }
    }

    protected void doPaste(URLFolder target, Object[] objects) {
        IFeatureModel model = (IFeatureModel)this.getFormPage().getModel();
        IFeature feature = model.getFeature();
        int i = 0;
        while (i < objects.length) {
            FeatureURLElement element;
            if (objects[i] instanceof FeatureURLElement && (element = (FeatureURLElement)objects[i]).getElementType() == target.type) {
                element.setModel(model);
                element.setParent((IFeatureObject)feature);
                try {
                    if (target.type == 1) {
                        feature.getURL().addUpdate((IFeatureURLElement)element);
                    } else {
                        feature.getURL().addDiscovery((IFeatureURLElement)element);
                    }
                }
                catch (CoreException e) {
                    PDECore.logException((Throwable)e);
                }
            }
            ++i;
        }
    }

    class URLFolder {
        int type;

        URLFolder(int type) {
            this.type = type;
        }

        IFeatureURL getURL() {
            IFeatureModel model = (IFeatureModel)URLSection.this.getFormPage().getModel();
            IFeature feature = model.getFeature();
            return feature.getURL();
        }
    }

    class URLContentProvider
    extends DefaultContentProvider
    implements ITreeContentProvider {
        URLContentProvider() {
        }

        public boolean hasChildren(Object parent) {
            return this.getChildren(parent).length > 0;
        }

        public Object[] getChildren(Object parent) {
            URLFolder folder;
            IFeatureURL url;
            if (parent instanceof IFeatureURL) {
                return URLSection.this.folders;
            }
            if (parent instanceof URLFolder && (url = (folder = (URLFolder)parent).getURL()) != null) {
                if (folder.type == 1) {
                    return url.getUpdates();
                }
                if (folder.type == 2) {
                    return url.getDiscoveries();
                }
            }
            return new Object[0];
        }

        public Object getParent(Object child) {
            if (child instanceof URLFolder) {
                return ((URLFolder)child).getURL();
            }
            if (child instanceof IFeatureURLElement) {
                IFeatureURLElement element = (IFeatureURLElement)child;
                if (element.getElementType() == 1) {
                    return URLSection.this.folders[0];
                }
                return URLSection.this.folders[1];
            }
            return null;
        }

        public Object[] getElements(Object parent) {
            return URLSection.this.folders;
        }
    }

    class URLLabelProvider
    extends LabelProvider {
        URLLabelProvider() {
        }

        public String getText(Object obj) {
            if (obj instanceof URLFolder) {
                URLFolder folder = (URLFolder)obj;
                if (folder.type == 1) {
                    return PDEPlugin.getResourceString(URLSection.KEY_UPDATE_URLS);
                }
                if (folder.type == 2) {
                    return PDEPlugin.getResourceString(URLSection.KEY_DISCOVERY_URLS);
                }
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            if (obj instanceof URLFolder) {
                return URLSection.this.urlFolderImage;
            }
            if (obj instanceof IFeatureURLElement) {
                return URLSection.this.urlImage;
            }
            return null;
        }
    }
}

