/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.ModelChangedEvent;
import org.eclipse.pde.core.plugin.IFragment;
import org.eclipse.pde.core.plugin.IFragmentModel;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModel;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.feature.WorkspaceFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.core.plugin.PluginBase;
import org.eclipse.pde.internal.core.plugin.WorkspacePluginModelBase;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.help.WorkbenchHelp;

public class SynchronizeVersionsWizardPage
extends WizardPage {
    public static final int USE_FEATURE = 1;
    public static final int USE_PLUGINS = 2;
    public static final int USE_REFERENCES = 3;
    private FeatureEditor featureEditor;
    private Button useComponentButton;
    private Button usePluginsButton;
    private Button useReferencesButton;
    private static final String PREFIX = String.valueOf(PDEPlugin.getPluginId()) + ".synchronizeVersions.";
    private static final String PROP_SYNCHRO_MODE = String.valueOf(PREFIX) + "mode";
    public static final String PAGE_TITLE = "VersionSyncWizard.title";
    public static final String KEY_GROUP = "VersionSyncWizard.group";
    public static final String KEY_USE_COMPONENT = "VersionSyncWizard.useComponent";
    public static final String KEY_USE_PLUGINS = "VersionSyncWizard.usePlugins";
    public static final String KEY_USE_REFERENCES = "VersionSyncWizard.useReferences";
    public static final String KEY_SYNCHRONIZING = "VersionSyncWizard.synchronizing";
    public static final String PAGE_DESC = "VersionSyncWizard.desc";

    public SynchronizeVersionsWizardPage(FeatureEditor featureEditor) {
        super("featureJar");
        this.setTitle(PDEPlugin.getResourceString(PAGE_TITLE));
        this.setDescription(PDEPlugin.getResourceString(PAGE_DESC));
        this.featureEditor = featureEditor;
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        container.setLayout((Layout)layout);
        Group group = new Group(container, 16);
        GridData gd = new GridData(768);
        layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setLayoutData((Object)gd);
        group.setText(PDEPlugin.getResourceString(KEY_GROUP));
        this.useComponentButton = new Button((Composite)group, 16);
        this.useComponentButton.setText(PDEPlugin.getResourceString(KEY_USE_COMPONENT));
        gd = new GridData(768);
        this.useComponentButton.setLayoutData((Object)gd);
        this.usePluginsButton = new Button((Composite)group, 16);
        this.usePluginsButton.setText(PDEPlugin.getResourceString(KEY_USE_PLUGINS));
        gd = new GridData(768);
        this.usePluginsButton.setLayoutData((Object)gd);
        this.useReferencesButton = new Button((Composite)group, 16);
        this.useReferencesButton.setText(PDEPlugin.getResourceString(KEY_USE_REFERENCES));
        gd = new GridData(768);
        this.useReferencesButton.setLayoutData((Object)gd);
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        this.loadSettings();
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.feature_synchronize_versions");
    }

    private WorkspacePluginModelBase findFragment(String id) {
        IFragmentModel[] models = PDECore.getDefault().getWorkspaceModelManager().getWorkspaceFragmentModels();
        return this.findWorkspaceModelBase((IPluginModelBase[])models, id);
    }

    private WorkspacePluginModelBase findModel(String id) {
        IPluginModel[] models = PDECore.getDefault().getWorkspaceModelManager().getWorkspacePluginModels();
        return this.findWorkspaceModelBase((IPluginModelBase[])models, id);
    }

    private IFeaturePlugin findPluginReference(String id) {
        IFeatureModel model = (IFeatureModel)this.featureEditor.getModel();
        IFeaturePlugin[] references = model.getFeature().getPlugins();
        int i = 0;
        while (i < references.length) {
            if (references[i].getId().equals(id)) {
                return references[i];
            }
            ++i;
        }
        return null;
    }

    private WorkspacePluginModelBase findWorkspaceModelBase(IPluginModelBase[] models, String id) {
        int i = 0;
        while (i < models.length) {
            IPluginModelBase modelBase = models[i];
            if (modelBase instanceof WorkspacePluginModelBase && modelBase.getPluginBase().getId().equals(id)) {
                return (WorkspacePluginModelBase)modelBase;
            }
            ++i;
        }
        return null;
    }

    public boolean finish() {
        final int mode = this.saveSettings();
        WorkspaceModifyOperation operation = new WorkspaceModifyOperation(){

            public void execute(IProgressMonitor monitor) {
                try {
                    try {
                        SynchronizeVersionsWizardPage.this.runOperation(mode, monitor);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                    catch (InvocationTargetException e) {
                        PDEPlugin.logException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                Object var3_6 = null;
                monitor.done();
            }
        };
        try {
            this.getContainer().run(false, true, (IRunnableWithProgress)operation);
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        return true;
    }

    private void forceVersion(String targetVersion, IPluginModelBase modelBase) throws CoreException {
        IFile file = (IFile)modelBase.getUnderlyingResource();
        WorkspaceModelManager modelProvider = PDECore.getDefault().getWorkspaceModelManager();
        modelProvider.connect((Object)file, (Object)this.featureEditor);
        WorkspacePluginModelBase model = (WorkspacePluginModelBase)modelProvider.getModel((Object)file, (Object)this.featureEditor);
        model.load();
        if (model.isLoaded()) {
            IPlugin local;
            IFragment fragment;
            IFeaturePlugin ref;
            IPluginBase base = model.getPluginBase();
            base.setVersion(targetVersion);
            if (base instanceof IFragment && (ref = this.findPluginReference((fragment = (IFragment)base).getPluginId())) != null) {
                fragment.setPluginVersion(targetVersion);
            }
            model.save();
            if (base instanceof IPlugin && (local = PDECore.getDefault().findPlugin(base.getId())) != null && local.getModel().getUnderlyingResource() != null && local.getModel().getUnderlyingResource().equals((Object)file)) {
                ((PluginBase)local).internalSetVersion(base.getVersion());
            }
        }
        modelProvider.disconnect((Object)file, (Object)this.featureEditor);
    }

    private void loadSettings() {
        IDialogSettings settings = this.getDialogSettings();
        if (settings.get(PROP_SYNCHRO_MODE) != null) {
            int mode = settings.getInt(PROP_SYNCHRO_MODE);
            switch (mode) {
                case 1: {
                    this.useComponentButton.setSelection(true);
                    break;
                }
                case 2: {
                    this.usePluginsButton.setSelection(true);
                    break;
                }
                case 3: {
                    this.useReferencesButton.setSelection(true);
                }
            }
        } else {
            this.useComponentButton.setSelection(true);
        }
    }

    private void runOperation(int mode, IProgressMonitor monitor) throws CoreException, InvocationTargetException {
        WorkspaceFeatureModel model = (WorkspaceFeatureModel)this.featureEditor.getModel();
        IFeature feature = model.getFeature();
        IFeaturePlugin[] plugins = feature.getPlugins();
        int size = plugins.length;
        monitor.beginTask(PDEPlugin.getResourceString(KEY_SYNCHRONIZING), size);
        int i = 0;
        while (i < plugins.length) {
            this.synchronizeVersion(mode, feature.getVersion(), plugins[i], monitor);
            ++i;
        }
        model.fireModelChanged((IModelChangedEvent)new ModelChangedEvent(99, null, null));
    }

    private int saveSettings() {
        IDialogSettings settings = this.getDialogSettings();
        int mode = 1;
        if (this.usePluginsButton.getSelection()) {
            mode = 2;
        } else if (this.useReferencesButton.getSelection()) {
            mode = 3;
        }
        settings.put(PROP_SYNCHRO_MODE, mode);
        return mode;
    }

    private void synchronizeVersion(int mode, String featureVersion, IFeaturePlugin ref, IProgressMonitor monitor) throws CoreException {
        String id = ref.getId();
        WorkspacePluginModelBase modelBase = null;
        modelBase = ref.isFragment() ? this.findFragment(id) : this.findModel(id);
        if (modelBase == null) {
            return;
        }
        if (mode == 2) {
            String baseVersion = modelBase.getPluginBase().getVersion();
            if (!ref.getVersion().equals(baseVersion)) {
                ref.setVersion(baseVersion);
            }
        } else {
            String targetVersion = featureVersion;
            if (mode == 3) {
                targetVersion = ref.getVersion();
            } else {
                ref.setVersion(targetVersion);
            }
            String baseVersion = modelBase.getPluginBase().getVersion();
            if (!targetVersion.equals(baseVersion)) {
                this.forceVersion(targetVersion, (IPluginModelBase)modelBase);
            }
            if (mode == 1) {
                ref.setVersion(targetVersion);
            }
        }
        monitor.worked(1);
    }
}

