/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.update.core.FeatureReference;
import org.eclipse.update.core.IFeature;

public class PreviewAction
extends Action {
    public static final String LABEL = "FeatureEditor.previewAction.label";
    private FeatureEditor activeEditor;

    public PreviewAction() {
        this.setText(PDEPlugin.getResourceString(LABEL));
    }

    private void ensureContentSaved() {
        if (this.activeEditor.isDirty()) {
            ProgressMonitorDialog monitor = new ProgressMonitorDialog(PDEPlugin.getActiveWorkbenchShell());
            try {
                monitor.run(false, false, new IRunnableWithProgress(){

                    public void run(IProgressMonitor monitor) {
                        PreviewAction.this.activeEditor.doSave(monitor);
                    }
                });
            }
            catch (InvocationTargetException e) {
                PDEPlugin.logException(e);
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    public void run() {
        this.ensureContentSaved();
        IWorkbenchPage page = PDEPlugin.getActivePage();
        IFeature feature = this.createUpdateFeature();
        if (feature == null) {
            return;
        }
        try {
            IViewPart view = page.showView("org.eclipse.update.ui.DetailsView");
            StructuredSelection selection = new StructuredSelection((Object)feature);
            ((ISelectionListener)view).selectionChanged((IWorkbenchPart)this.activeEditor, (ISelection)selection);
        }
        catch (PartInitException e) {
            PDEPlugin.logException(e);
        }
    }

    private IFeature createUpdateFeature() {
        IFileEditorInput input = (IFileEditorInput)this.activeEditor.getEditorInput();
        IFile file = input.getFile();
        IPath fullPath = Platform.getLocation().append(file.getFullPath());
        try {
            File systemFile = fullPath.toFile();
            URL url = systemFile.toURL();
            FeatureReference fref = new FeatureReference();
            fref.setURL(url);
            fref.setType("org.eclipse.update.core.installed");
            return fref.getFeature(null);
        }
        catch (MalformedURLException e) {
            PDEPlugin.logException(e);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        return null;
    }

    public void setActiveEditor(FeatureEditor editor) {
        this.activeEditor = editor;
    }
}

