/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.Choice;
import org.eclipse.pde.internal.core.ifeature.IEnvironment;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEntryPropertySource;
import org.eclipse.pde.internal.ui.editor.feature.FeatureFormPage;
import org.eclipse.pde.internal.ui.editor.feature.PortabilityChoicesDialog;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.ui.forms.internal.FormEntry;
import org.eclipse.update.ui.forms.internal.FormSection;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.IFormTextListener;

public class PortabilitySection
extends PDEFormSection {
    public static final String KEY_DIALOG_TITLE = "FeatureEditor.PortabilityChoicesDialog.title";
    public static final String SECTION_TITLE = "FeatureEditor.PortabilitySection.title";
    public static final String SECTION_DESC = "FeatureEditor.PortabilitySection.desc";
    public static final String SECTION_OS = "FeatureEditor.PortabilitySection.os";
    public static final String SECTION_WS = "FeatureEditor.PortabilitySection.ws";
    public static final String SECTION_NL = "FeatureEditor.PortabilitySection.nl";
    public static final String SECTION_ARCH = "FeatureEditor.PortabilitySection.arch";
    public static final String SECTION_EDIT = "FeatureEditor.PortabilitySection.edit";
    private FormEntry osText;
    private Button osButton;
    private FormEntry wsText;
    private Button wsButton;
    private FormEntry nlText;
    private Button nlButton;
    private FormEntry archText;
    private Button archButton;
    private boolean updateNeeded;
    private boolean reactToSelections;
    private IStructuredSelection currentInput;

    public PortabilitySection(FeatureFormPage page) {
        this(page, PDEPlugin.getResourceString(SECTION_TITLE), PDEPlugin.getResourceString(SECTION_DESC), false);
    }

    public PortabilitySection(PDEFormPage page, String title, String desc, boolean reactToSelections) {
        super(page);
        this.reactToSelections = reactToSelections;
        this.setHeaderText(title);
        this.setDescription(desc);
        this.setCollapsable(!reactToSelections);
        if (!reactToSelections) {
            IFeatureModel model = (IFeatureModel)page.getModel();
            IFeature feature = model.getFeature();
            this.setCollapsed(feature.getOS() == null && feature.getWS() == null && feature.getNL() == null && feature.getArch() == null);
        }
    }

    public boolean canPaste(Clipboard clipboard) {
        return clipboard.getContents((Transfer)TextTransfer.getInstance()) != null;
    }

    public void commitChanges(boolean onSave) {
        this.osText.commit();
        this.wsText.commit();
        if (this.nlText != null) {
            this.nlText.commit();
        }
        this.archText.commit();
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        IFeatureModel model = (IFeatureModel)this.getFormPage().getModel();
        model.getFeature();
        this.osText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_OS), factory));
        this.osText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    PortabilitySection.this.applyValue("os", text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void textDirty(FormEntry text) {
                PortabilitySection.this.forceDirty();
            }
        });
        this.limitTextWidth(this.osText);
        String editLabel = PDEPlugin.getResourceString(SECTION_EDIT);
        this.osButton = factory.createButton(container, editLabel, 8);
        this.osButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)PortabilitySection.this.osText.getControl().getDisplay(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 2 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Choice[] choices = FeatureEntryPropertySource.getOSChoices();
                        PortabilitySection.access$3(2.access$0(this.this$1), PortabilitySection.access$2(2.access$0(this.this$1)), choices);
                    }
                });
            }

            static /* synthetic */ PortabilitySection access$0(2 var0) {
                return var0.PortabilitySection.this;
            }
        });
        this.wsText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_WS), factory));
        this.wsText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    PortabilitySection.this.applyValue("ws", text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void textDirty(FormEntry text) {
                PortabilitySection.this.forceDirty();
            }
        });
        this.limitTextWidth(this.wsText);
        this.wsButton = factory.createButton(container, editLabel, 8);
        this.wsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)PortabilitySection.this.wsText.getControl().getDisplay(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Choice[] choices = FeatureEntryPropertySource.getWSChoices();
                        PortabilitySection.access$3(5.access$0(this.this$1), PortabilitySection.access$4(5.access$0(this.this$1)), choices);
                    }
                });
            }

            static /* synthetic */ PortabilitySection access$0(5 var0) {
                return var0.PortabilitySection.this;
            }
        });
        if (!this.reactToSelections) {
            this.nlText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_NL), factory));
            this.nlText.addFormTextListener(new IFormTextListener(){

                public void textValueChanged(FormEntry text) {
                    try {
                        PortabilitySection.this.applyValue("nl", text.getValue());
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }

                public void textDirty(FormEntry text) {
                    PortabilitySection.this.forceDirty();
                }
            });
            this.limitTextWidth(this.nlText);
            this.nlButton = factory.createButton(container, editLabel, 8);
            this.nlButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    BusyIndicator.showWhile((Display)PortabilitySection.this.nlText.getControl().getDisplay(), (Runnable)new Runnable(this){
                        private final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public void run() {
                            Choice[] choices = FeatureEntryPropertySource.getNLChoices();
                            PortabilitySection.access$3(8.access$0(this.this$1), PortabilitySection.access$5(8.access$0(this.this$1)), choices);
                        }
                    });
                }

                static /* synthetic */ PortabilitySection access$0(8 var0) {
                    return var0.PortabilitySection.this;
                }
            });
        }
        this.archText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_ARCH), factory));
        this.archText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    PortabilitySection.this.applyValue("arch", text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void textDirty(FormEntry text) {
                PortabilitySection.this.forceDirty();
            }
        });
        this.limitTextWidth(this.archText);
        this.archButton = factory.createButton(container, editLabel, 8);
        this.archButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                BusyIndicator.showWhile((Display)PortabilitySection.this.archText.getControl().getDisplay(), (Runnable)new Runnable(this){
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        Choice[] choices = FeatureEntryPropertySource.getArchChoices();
                        PortabilitySection.access$3(11.access$0(this.this$1), PortabilitySection.access$6(11.access$0(this.this$1)), choices);
                    }
                });
            }

            static /* synthetic */ PortabilitySection access$0(11 var0) {
                return var0.PortabilitySection.this;
            }
        });
        factory.paintBordersFor(container);
        return container;
    }

    private void limitTextWidth(FormEntry entry) {
        GridData gd = (GridData)entry.getControl().getLayoutData();
        gd.widthHint = this.reactToSelections ? 30 : 150;
    }

    private void openPortabilityChoiceDialog(FormEntry text, Choice[] choices) {
        String value = text.getValue();
        PortabilityChoicesDialog dialog = new PortabilityChoicesDialog(PDEPlugin.getActiveWorkbenchShell(), choices, value);
        dialog.create();
        dialog.getShell().setText(PDEPlugin.getResourceString(KEY_DIALOG_TITLE));
        int result = dialog.open();
        if (result == 0) {
            value = dialog.getValue();
            text.setValue(value);
        }
    }

    private IFeature getFeature() {
        IFeatureModel model = (IFeatureModel)this.getFormPage().getModel();
        return model.getFeature();
    }

    private void applyValue(String property, String value) throws CoreException {
        if (this.reactToSelections) {
            if (this.currentInput == null) {
                return;
            }
            Iterator iter = this.currentInput.iterator();
            while (iter.hasNext()) {
                IEnvironment env = (IEnvironment)iter.next();
                this.applyValue(env, property, value);
            }
        } else {
            this.applyValue((IEnvironment)this.getFeature(), property, value);
        }
    }

    private void setValue(String property) {
        if (this.reactToSelections) {
            if (this.currentInput == null) {
                this.clearField(property);
            } else if (this.currentInput.size() == 1) {
                this.setValue((IEnvironment)this.currentInput.getFirstElement(), property);
            } else {
                IEnvironment leader = null;
                String lvalue = null;
                Iterator iter = this.currentInput.iterator();
                while (iter.hasNext()) {
                    String nvalue;
                    IEnvironment next = (IEnvironment)iter.next();
                    if (leader == null) {
                        nvalue = this.getValue(next, property);
                        if (nvalue == null) break;
                        leader = next;
                        lvalue = nvalue;
                        continue;
                    }
                    nvalue = this.getValue(next, property);
                    if (nvalue != null && lvalue.equals(nvalue)) continue;
                    leader = null;
                    break;
                }
                if (leader == null) {
                    this.clearField(property);
                } else {
                    this.setValue(leader, property);
                }
            }
        } else {
            this.setValue((IEnvironment)this.getFeature(), property);
        }
    }

    private String getValue(IEnvironment obj, String property) {
        if (property.equals("os")) {
            return obj.getOS();
        }
        if (property.equals("ws")) {
            return obj.getWS();
        }
        if (property.equals("arch")) {
            return obj.getArch();
        }
        return null;
    }

    private void applyValue(IEnvironment obj, String property, String value) throws CoreException {
        if (property.equals("nl")) {
            ((IFeature)obj).setNL(value);
        } else if (property.equals("os")) {
            obj.setOS(value);
        } else if (property.equals("ws")) {
            obj.setWS(value);
        } else if (property.equals("arch")) {
            obj.setArch(value);
        }
    }

    private void setValue(IEnvironment obj, String property) {
        if (property.equals("nl")) {
            this.setIfDefined(this.nlText, ((IFeature)obj).getNL());
        } else if (property.equals("os")) {
            this.setIfDefined(this.osText, obj.getOS());
        } else if (property.equals("ws")) {
            this.setIfDefined(this.wsText, obj.getWS());
        } else if (property.equals("arch")) {
            this.setIfDefined(this.archText, obj.getArch());
        }
    }

    private void forceDirty() {
        this.setDirty(true);
        IModel model = (IModel)this.getFormPage().getModel();
        if (model instanceof IEditable) {
            IEditable editable = (IEditable)model;
            editable.setDirty(true);
            this.getFormPage().getEditor().fireSaveNeeded();
        }
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public void initialize(Object input) {
        IFeatureModel model = (IFeatureModel)input;
        this.enableForInput(model.isEditable());
        this.update(input);
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public boolean isDirty() {
        return this.osText.isDirty() || this.wsText.isDirty() || this.nlText != null && this.nlText.isDirty() || this.archText.isDirty();
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.updateNeeded = true;
        }
    }

    public void setFocus() {
        if (this.osText != null) {
            this.osText.getControl().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, String value) {
        formText.setValue(value, true);
    }

    private void setIfDefined(Text text, String value) {
        if (value != null) {
            text.setText(value);
        } else {
            text.setText("");
        }
    }

    public void update() {
        if (this.updateNeeded) {
            this.update(this.getFormPage().getModel());
        }
    }

    private void enableForInput(boolean enable) {
        this.osText.getControl().setEditable(enable);
        this.wsText.getControl().setEditable(enable);
        if (this.nlText != null) {
            this.nlText.getControl().setEditable(enable);
        }
        this.archText.getControl().setEditable(enable);
        this.osButton.setEnabled(enable);
        this.wsButton.setEnabled(enable);
        if (this.nlButton != null) {
            this.nlButton.setEnabled(enable);
        }
        this.archButton.setEnabled(enable);
    }

    private void clearFields() {
        this.osText.setValue(null, true);
        this.wsText.setValue(null, true);
        if (this.nlText != null) {
            this.nlText.setValue(null, true);
        }
        this.archText.setValue(null, true);
    }

    private void clearField(String property) {
        if (property.equals("os")) {
            this.osText.setValue(null, true);
        } else if (property.equals("ws")) {
            this.wsText.setValue(null, true);
        } else if (property.equals("arch")) {
            this.archText.setValue(null, true);
        }
    }

    public void update(Object input) {
        if (this.reactToSelections && this.currentInput == null) {
            this.clearFields();
            this.enableForInput(false);
            return;
        }
        this.enableForInput(true);
        this.setValue("os");
        this.setValue("ws");
        this.setValue("arch");
        if (this.nlText != null) {
            this.setValue("nl");
        }
        this.updateNeeded = false;
    }

    public void sectionChanged(FormSection source, int changeType, Object changeObject) {
        if (changeObject instanceof IStructuredSelection) {
            this.currentInput = (IStructuredSelection)changeObject;
            if (this.currentInput.isEmpty()) {
                this.currentInput = null;
            }
        } else {
            this.currentInput = null;
        }
        this.update(null);
    }

    static /* synthetic */ void access$3(PortabilitySection portabilitySection, FormEntry formEntry, Choice[] choiceArray) {
        portabilitySection.openPortabilityChoiceDialog(formEntry, choiceArray);
    }
}

