/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.pde.core.plugin.IPlugin;
import org.eclipse.pde.core.plugin.IPluginBase;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.internal.core.feature.FeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureImport;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeaturePlugin;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.feature.ReferenceWizardPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.help.WorkbenchHelp;

public class NewFeatureRequireWizardPage
extends ReferenceWizardPage {
    public static final String KEY_TITLE = "FeatureEditor.RequiresSection.newPlugin.title";
    public static final String KEY_DESC = "FeatureEditor.RequiresSection.newPlugin.desc";
    public static final String KEY_ADDING = "FeatureEditor.RequiresSection.newPlugin.adding";
    public static final String KEY_UPDATING = "FeatureEditor.RequiresSection.newPlugin.updating";

    public NewFeatureRequireWizardPage(IFeatureModel model) {
        super(model, true);
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
    }

    protected boolean isOnTheList(IPluginModelBase candidate) {
        IPluginBase plugin = candidate.getPluginBase();
        IFeatureImport[] imports = this.model.getFeature().getImports();
        int i = 0;
        while (i < imports.length) {
            IFeatureImport fimport = imports[i];
            if (plugin.getId().equals(fimport.getId())) {
                return true;
            }
            ++i;
        }
        IFeaturePlugin[] fplugins = this.model.getFeature().getPlugins();
        int i2 = 0;
        while (i2 < fplugins.length) {
            IFeaturePlugin fplugin = fplugins[i2];
            if (plugin.getId().equals(fplugin.getId())) {
                return true;
            }
            ++i2;
        }
        return false;
    }

    protected void doAdd(Object[] candidates, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(PDEPlugin.getResourceString(KEY_ADDING), candidates.length + 1);
        IFeature feature = this.model.getFeature();
        IFeatureImport[] added = new IFeatureImport[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IPluginModelBase candidate = (IPluginModelBase)candidates[i];
            IPluginBase pluginBase = candidate.getPluginBase();
            monitor.subTask(pluginBase.getTranslatedName());
            FeatureImport fimport = (FeatureImport)this.model.getFactory().createImport();
            fimport.setPlugin((IPlugin)candidate.getPluginBase());
            fimport.setId(pluginBase.getId());
            added[i] = fimport;
            monitor.worked(1);
            ++i;
        }
        monitor.subTask("");
        monitor.setTaskName(PDEPlugin.getResourceString(KEY_UPDATING));
        feature.addImports(added);
        monitor.worked(1);
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)"org.eclipse.pde.doc.user.feature_add_required_wizard");
    }
}

