/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureInfo;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.XMLConfiguration;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.PDEPartitionScanner;
import org.eclipse.pde.internal.ui.editor.text.TextUtil;
import org.eclipse.swt.SWT;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class InfoSection
extends PDEFormSection {
    private static final String SECTION_TITLE = "FeatureEditor.InfoSection.title";
    private static final String KEY_APPLY = "Actions.apply.flabel";
    private static final String KEY_RESET = "Actions.reset.flabel";
    private static final String SECTION_DESC = "FeatureEditor.InfoSection.desc";
    private static final String KEY_INFO = "FeatureEditor.InfoSection.info";
    private static final String KEY_URL = "FeatureEditor.InfoSection.url";
    private static final String KEY_TEXT = "FeatureEditor.InfoSection.text";
    private static final String KEY_INFO_DESCRIPTION = "FeatureEditor.info.description";
    private static final String KEY_INFO_LICENSE = "FeatureEditor.info.license";
    private static final String KEY_INFO_COPYRIGHT = "FeatureEditor.info.copyright";
    private IDocument document;
    private IDocumentPartitioner partitioner;
    private SourceViewerConfiguration sourceConfiguration;
    private SourceViewer sourceViewer;
    private CCombo sectionCombo;
    private Text urlText;
    private Button applyButton;
    private Button resetButton;
    private Object element;
    private int elementIndex;
    private IColorManager colorManager;
    private FormWidgetFactory factory;
    private boolean ignoreChange;

    public InfoSection(PDEFormPage page, IColorManager colorManager) {
        super(page);
        this.setHeaderPainted(false);
        this.setAddSeparator(false);
        String description = PDEPlugin.getResourceString(SECTION_DESC);
        this.setDescription(TextUtil.createMultiLine(description, 80));
        this.colorManager = colorManager;
        this.sourceConfiguration = new XMLConfiguration(colorManager);
        this.document = new Document();
        this.partitioner = new DefaultPartitioner((IPartitionTokenScanner)new PDEPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        this.partitioner.connect(this.document);
        this.document.setDocumentPartitioner(this.partitioner);
    }

    public void commitChanges(boolean onSave) {
        this.handleApply();
        if (onSave) {
            this.setDirty(false);
            this.resetButton.setEnabled(false);
        }
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.factory = factory;
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.marginWidth = 2;
        layout.marginHeight = 2;
        layout.verticalSpacing = 9;
        container.setLayout((Layout)layout);
        Label label = factory.createLabel(container, null);
        GridData gd = new GridData();
        gd.horizontalSpan = 3;
        label.setLayoutData((Object)gd);
        factory.createLabel(container, PDEPlugin.getResourceString(KEY_INFO));
        int borderStyle = !SWT.getPlatform().equals("motif") ? 0x800000 : 2048;
        int comboStyle = 8 | borderStyle;
        this.sectionCombo = new CCombo(container, comboStyle);
        this.sectionCombo.setBackground(factory.getBackgroundColor());
        gd = new GridData(768);
        this.sectionCombo.setLayoutData((Object)gd);
        this.initializeSectionCombo();
        factory.createLabel(container, null);
        factory.createLabel(container, PDEPlugin.getResourceString(KEY_URL));
        if (!SWT.getPlatform().equals("motif")) {
            this.urlText = factory.createText(container, null, 4 | borderStyle);
            this.urlText.addModifyListener(new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    InfoSection.this.infoModified();
                }
            });
            gd = new GridData(768);
            this.urlText.setLayoutData((Object)gd);
        } else {
            Composite textContainer = this.createText(container, factory);
            gd = new GridData(768);
            textContainer.setLayoutData((Object)gd);
        }
        factory.createLabel(container, null);
        label = factory.createLabel(container, PDEPlugin.getResourceString(KEY_TEXT));
        gd = new GridData(2);
        label.setLayoutData((Object)gd);
        int styles = 834;
        this.sourceViewer = new SourceViewer(container, null, styles);
        this.sourceViewer.configure(this.sourceConfiguration);
        this.sourceViewer.setDocument(this.document);
        this.sourceViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                InfoSection.this.updateSelection(event.getSelection());
            }
        });
        StyledText styledText = this.sourceViewer.getTextWidget();
        styledText.setFont(JFaceResources.getTextFont());
        styledText.setMenu(this.getFormPage().getEditor().getContextMenu());
        if (!SWT.getPlatform().equals("motif")) {
            factory.paintBordersFor(container);
        }
        Control[] children = container.getChildren();
        Control control = children[children.length - 1];
        gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        Composite buttonContainer = factory.createComposite(container);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        buttonContainer.setLayout((Layout)layout);
        gd = new GridData(1040);
        buttonContainer.setLayoutData((Object)gd);
        this.applyButton = factory.createButton(buttonContainer, PDEPlugin.getResourceString(KEY_APPLY), 8);
        this.applyButton.setEnabled(false);
        gd = new GridData(770);
        this.applyButton.setLayoutData((Object)gd);
        this.applyButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoSection.this.handleApply();
            }
        });
        this.resetButton = factory.createButton(buttonContainer, PDEPlugin.getResourceString(KEY_RESET), 8);
        this.resetButton.setEnabled(false);
        gd = new GridData(770);
        this.resetButton.setLayoutData((Object)gd);
        this.resetButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                InfoSection.this.handleReset();
            }
        });
        return container;
    }

    private Composite createText(Composite parent, FormWidgetFactory factory) {
        Composite textContainer = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 1;
        layout.marginHeight = 2;
        textContainer.setLayout((Layout)layout);
        factory.paintBordersFor(textContainer);
        this.urlText = factory.createText(textContainer, null);
        this.urlText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                InfoSection.this.infoModified();
            }
        });
        GridData gd = new GridData(1808);
        this.urlText.setLayoutData((Object)gd);
        return textContainer;
    }

    private void updateSelection(ISelection selection) {
        this.getFormPage().getEditor().setSelection(selection);
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals("cut")) {
            this.sourceViewer.doOperation(3);
            return true;
        }
        if (actionId.equals("copy")) {
            this.sourceViewer.doOperation(4);
            return true;
        }
        if (actionId.equals("paste")) {
            this.sourceViewer.doOperation(5);
            return true;
        }
        if (actionId.equals("delete")) {
            this.sourceViewer.doOperation(6);
            return true;
        }
        if (actionId.equals("undo")) {
            this.sourceViewer.doOperation(1);
            return true;
        }
        if (actionId.equals("redo")) {
            this.sourceViewer.doOperation(2);
            return true;
        }
        return false;
    }

    public void expandTo(Object input) {
        if (input instanceof IFeatureInfo) {
            IFeatureInfo info = (IFeatureInfo)input;
            int index = info.getIndex();
            this.sectionCombo.select(index);
            this.updateEditorInput(info, true);
        }
    }

    private void handleApply() {
        this.handleApply(null, this.sectionCombo.getSelectionIndex());
    }

    private void handleApply(IFeatureInfo info, int index) {
        String urlName = this.urlText.getText();
        String text = this.document.get();
        this.updateInfoText(info, urlName, text, index);
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
    }

    private void updateInfoText(IFeatureInfo targetInfo, String urlText, String text, int index) {
        String url = null;
        if (urlText.length() > 0) {
            url = urlText;
        }
        try {
            IFeatureModel model = (IFeatureModel)this.getFormPage().getModel();
            IFeature feature = model.getFeature();
            IFeatureInfo info = targetInfo;
            if (info == null) {
                info = feature.getFeatureInfo(index);
            }
            if (targetInfo == null && info == null) {
                info = model.getFactory().createInfo(index);
                feature.setFeatureInfo(info, index);
            }
            info.setURL(url);
            info.setDescription(text);
        }
        catch (CoreException coreException) {}
    }

    protected void fillContextMenu(IMenuManager manager) {
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void updateInfoURL(URL url) {
    }

    private void handleReset() {
        this.updateEditorInput(this.element, false);
    }

    public void initialize(Object model) {
        IFeatureModel featureModel = (IFeatureModel)model;
        this.document.addDocumentListener(new IDocumentListener(){

            public void documentChanged(DocumentEvent e) {
                InfoSection.this.infoModified();
            }

            public void documentAboutToBeChanged(DocumentEvent e) {
            }
        });
        this.urlText.setEditable(featureModel.isEditable());
        this.sourceViewer.getTextWidget().setEditable(featureModel.isEditable());
        featureModel.addModelChangedListener((IModelChangedListener)this);
        this.updateEditorInput(featureModel.getFeature().getFeatureInfo(0), false);
    }

    public void dispose() {
        IFeatureModel featureModel = (IFeatureModel)this.getFormPage().getModel();
        featureModel.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    private void infoModified() {
        IFeatureModel featureModel = (IFeatureModel)this.getFormPage().getModel();
        if (!this.ignoreChange && featureModel instanceof IEditable) {
            this.setDirty(true);
            ((IEditable)featureModel).setDirty(true);
            this.getFormPage().getEditor().fireSaveNeeded();
        }
        this.applyButton.setEnabled(true);
        this.resetButton.setEnabled(true);
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            IFeatureModel model = (IFeatureModel)this.getFormPage().getModel();
            int index = this.sectionCombo.getSelectionIndex();
            IFeatureInfo info = model.getFeature().getFeatureInfo(index);
            this.setDirty(false);
            this.element = null;
            this.elementIndex = -1;
            this.updateEditorInput(info, false);
        }
    }

    private void initializeSectionCombo() {
        this.sectionCombo.setItems(new String[]{PDEPlugin.getResourceString(KEY_INFO_DESCRIPTION), PDEPlugin.getResourceString(KEY_INFO_COPYRIGHT), PDEPlugin.getResourceString(KEY_INFO_LICENSE)});
        this.sectionCombo.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IFeatureModel model = (IFeatureModel)InfoSection.this.getFormPage().getModel();
                IFeature feature = model.getFeature();
                int index = InfoSection.this.sectionCombo.getSelectionIndex();
                IFeatureInfo info = feature.getFeatureInfo(index);
                InfoSection.this.updateEditorInput(info, true);
            }
        });
        this.sectionCombo.pack();
        this.sectionCombo.select(0);
    }

    private String resolveObjectName(Object object) {
        if (object instanceof IFeatureObject) {
            return ((IFeatureObject)object).getLabel();
        }
        return object.toString();
    }

    public void setFocus() {
        this.sourceViewer.getTextWidget().setFocus();
    }

    private void commitPrevious() {
        IFeatureInfo previous = (IFeatureInfo)this.element;
        this.handleApply(previous, this.elementIndex);
    }

    public void updateEditorInput(Object input, boolean commitPrevious) {
        if (this.isDirty() && commitPrevious) {
            this.commitPrevious();
        }
        this.ignoreChange = true;
        String text = "";
        String url = null;
        if (input instanceof IFeatureInfo) {
            IFeatureInfo info = (IFeatureInfo)input;
            text = info.getDescription();
            url = info.getURL();
        }
        text = text == null ? "" : TextUtil.createMultiLine(text, 60, false);
        this.document.set(text);
        if (url == null) {
            this.urlText.setText("");
        } else {
            this.urlText.setText(url.toString());
        }
        this.applyButton.setEnabled(false);
        this.resetButton.setEnabled(false);
        this.element = input;
        this.elementIndex = this.sectionCombo.getSelectionIndex();
        this.ignoreChange = false;
    }

    public boolean canPaste(Clipboard clipboard) {
        return this.sourceViewer.canDoOperation(5);
    }
}

