/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.feature.FeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureChild;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.WizardCheckboxTablePart;
import org.eclipse.pde.internal.ui.wizards.ListUtil;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class IncludeFeaturesWizardPage
extends WizardPage {
    public static final String KEY_TITLE = "FeatureEditor.IncludedFeaturesSection.new.title";
    public static final String KEY_DESC = "FeatureEditor.IncludedFeaturesSection.new.desc";
    public static final String KEY_FEATURES = "FeatureEditor.IncludedFeaturesSection.new.label";
    public static final String KEY_ADDING = "FeatureEditor.IncludedFeaturesSection.new.adding";
    public static final String KEY_UPDATING = "FeatureEditor.IncludedFeaturesSection.new.updating";
    private IFeatureModel model;
    private TablePart checkboxTablePart;
    private CheckboxTableViewer pluginViewer;

    public IncludeFeaturesWizardPage(IFeatureModel model) {
        super("IncludeFeaturesPage");
        this.model = model;
        this.setTitle(PDEPlugin.getResourceString(KEY_TITLE));
        this.setDescription(PDEPlugin.getResourceString(KEY_DESC));
        this.setPageComplete(false);
        this.checkboxTablePart = new TablePart();
        PDEPlugin.getDefault().getLabelProvider().connect((Object)this);
    }

    public void dispose() {
        PDEPlugin.getDefault().getLabelProvider().disconnect((Object)this);
        super.dispose();
    }

    public void createControl(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        this.createPluginList(container);
        this.initialize();
        this.setControl((Control)container);
        Dialog.applyDialogFont((Control)container);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.feature_included_features_wizard");
    }

    protected void createPluginList(Composite parent) {
        this.checkboxTablePart.createControl(parent);
        this.pluginViewer = this.checkboxTablePart.getTableViewer();
        this.pluginViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        this.pluginViewer.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        this.pluginViewer.addFilter(new ViewerFilter(){

            public boolean select(Viewer v, Object parent, Object object) {
                if (object instanceof IFeatureModel) {
                    IFeatureModel model = (IFeatureModel)object;
                    return !IncludeFeaturesWizardPage.this.isOnTheList(model);
                }
                return true;
            }
        });
        GridData gd = (GridData)this.checkboxTablePart.getControl().getLayoutData();
        gd.heightHint = 300;
    }

    private boolean isOnTheList(IFeatureModel candidate) {
        IFeatureChild[] features = this.model.getFeature().getIncludedFeatures();
        IFeature cfeature = candidate.getFeature();
        if (this.isThisModel(cfeature)) {
            return true;
        }
        int i = 0;
        while (i < features.length) {
            IFeatureChild child = features[i];
            if (child.getId().equals(cfeature.getId()) && child.getVersion().equals(cfeature.getVersion())) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean isThisModel(IFeature cfeature) {
        IFeature thisFeature = this.model.getFeature();
        return cfeature.getId().equals(thisFeature.getId()) && cfeature.getVersion().equals(thisFeature.getVersion());
    }

    public void init(IWorkbench workbench) {
    }

    private void initialize() {
        this.pluginViewer.setInput((Object)this.model.getFeature());
        this.checkboxTablePart.setSelection(new Object[0]);
    }

    private Object[] getChoices() {
        WorkspaceModelManager mng = PDECore.getDefault().getWorkspaceModelManager();
        return mng.getWorkspaceFeatureModels();
    }

    public boolean finish() {
        final Object[] candidates = this.checkboxTablePart.getSelection();
        IRunnableWithProgress op = new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    IncludeFeaturesWizardPage.this.doAdd(candidates, monitor);
                }
                catch (CoreException e) {
                    throw new InvocationTargetException(e);
                }
            }
        };
        try {
            this.getContainer().run(false, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            PDEPlugin.logException(e);
            return false;
        }
        return true;
    }

    private void doAdd(Object[] candidates, IProgressMonitor monitor) throws CoreException {
        monitor.beginTask(PDEPlugin.getResourceString(KEY_ADDING), candidates.length + 1);
        IFeature feature = this.model.getFeature();
        IFeatureChild[] added = new IFeatureChild[candidates.length];
        int i = 0;
        while (i < candidates.length) {
            IFeatureModel candidate = (IFeatureModel)candidates[i];
            String name = candidate.getFeature().getLabel();
            monitor.subTask(candidate.getResourceString(name));
            FeatureChild child = (FeatureChild)this.model.getFactory().createChild();
            child.loadFrom(candidate.getFeature());
            added[i] = child;
            monitor.worked(1);
            ++i;
        }
        monitor.subTask("");
        monitor.setTaskName(PDEPlugin.getResourceString(KEY_UPDATING));
        feature.addIncludedFeatures(added);
        monitor.worked(1);
    }

    class PluginContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        PluginContentProvider() {
        }

        public Object[] getElements(Object parent) {
            return IncludeFeaturesWizardPage.this.getChoices();
        }
    }

    class TablePart
    extends WizardCheckboxTablePart {
        public TablePart() {
            super(PDEPlugin.getResourceString(IncludeFeaturesWizardPage.KEY_FEATURES));
        }

        public void updateCounter(int count) {
            super.updateCounter(count);
            IncludeFeaturesWizardPage.this.setPageComplete(count > 0);
        }

        protected StructuredViewer createStructuredViewer(Composite parent, int style, FormWidgetFactory factory) {
            StructuredViewer viewer = super.createStructuredViewer(parent, style, factory);
            viewer.setSorter(ListUtil.FEATURE_SORTER);
            return viewer;
        }
    }
}

