/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureInstallHandler;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureAdvancedPage;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.update.ui.forms.internal.FormEntry;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.IFormTextListener;

public class HandlerSection
extends PDEFormSection {
    public static final String SECTION_TITLE = "FeatureEditor.HandlerSection.title";
    public static final String SECTION_DESC = "FeatureEditor.HandlerSection.desc";
    public static final String SECTION_URL = "FeatureEditor.HandlerSection.url";
    public static final String SECTION_LIBRARY = "FeatureEditor.HandlerSection.library";
    public static final String SECTION_HANDLER = "FeatureEditor.HandlerSection.handler";
    private FormEntry urlText;
    private FormEntry libraryText;
    private FormEntry handlerText;
    private boolean updateNeeded;

    public HandlerSection(FeatureAdvancedPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
    }

    public boolean canPaste(Clipboard clipboard) {
        return clipboard.getContents((Transfer)TextTransfer.getInstance()) != null;
    }

    public void commitChanges(boolean onSave) {
        this.urlText.commit();
        this.libraryText.commit();
        this.handlerText.commit();
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        IFeatureModel model = (IFeatureModel)this.getFormPage().getModel();
        final IFeature feature = model.getFeature();
        this.urlText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_URL), factory));
        this.urlText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    HandlerSection.this.setURL(feature, text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void textDirty(FormEntry text) {
                HandlerSection.this.forceDirty();
            }
        });
        this.libraryText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_LIBRARY), factory));
        this.libraryText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    HandlerSection.this.setLibrary(feature, text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void textDirty(FormEntry text) {
                HandlerSection.this.forceDirty();
            }
        });
        this.handlerText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_HANDLER), factory));
        this.handlerText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    HandlerSection.this.setHandler(feature, text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void textDirty(FormEntry text) {
                HandlerSection.this.forceDirty();
            }
        });
        factory.paintBordersFor(container);
        return container;
    }

    private void setURL(IFeature feature, String value) throws CoreException {
        IFeatureInstallHandler handler = this.getHandler(feature);
        try {
            URL url = new URL(value);
            handler.setURL(url);
        }
        catch (MalformedURLException e) {
            PDEPlugin.logException(e);
        }
    }

    private void setLibrary(IFeature feature, String value) throws CoreException {
        IFeatureInstallHandler handler = this.getHandler(feature);
        handler.setLibrary(value);
    }

    private void setHandler(IFeature feature, String value) throws CoreException {
        IFeatureInstallHandler handler = this.getHandler(feature);
        handler.setHandlerName(value);
    }

    private IFeatureInstallHandler getHandler(IFeature feature) throws CoreException {
        IFeatureInstallHandler handler = feature.getInstallHandler();
        if (handler == null) {
            handler = feature.getModel().getFactory().createInstallHandler();
            feature.setInstallHandler(handler);
        }
        return handler;
    }

    private void forceDirty() {
        this.setDirty(true);
        IModel model = (IModel)this.getFormPage().getModel();
        if (model instanceof IEditable) {
            IEditable editable = (IEditable)model;
            editable.setDirty(true);
            this.getFormPage().getEditor().fireSaveNeeded();
        }
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public void initialize(Object input) {
        IFeatureModel model = (IFeatureModel)input;
        this.update(input);
        if (!model.isEditable()) {
            this.urlText.getControl().setEditable(false);
            this.libraryText.getControl().setEditable(false);
            this.handlerText.getControl().setEditable(false);
        }
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public boolean isDirty() {
        return this.urlText.isDirty() || this.libraryText.isDirty() || this.handlerText.isDirty();
    }

    public void modelChanged(IModelChangedEvent e) {
        if (e.getChangeType() == 99) {
            this.updateNeeded = true;
        }
    }

    public void setFocus() {
        if (this.urlText != null) {
            this.urlText.getControl().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, Object value) {
        if (value != null) {
            formText.setValue(value.toString(), true);
        }
    }

    private void setIfDefined(Text text, Object value) {
        if (value != null) {
            text.setText(value.toString());
        }
    }

    public void update() {
        if (this.updateNeeded) {
            this.update(this.getFormPage().getModel());
        }
    }

    public void update(Object input) {
        IFeatureModel model = (IFeatureModel)input;
        IFeature feature = model.getFeature();
        IFeatureInstallHandler handler = feature.getInstallHandler();
        if (handler != null) {
            this.setIfDefined(this.urlText, (Object)handler.getURL());
            this.setIfDefined(this.libraryText, (Object)handler.getLibrary());
            this.setIfDefined(this.handlerText, (Object)handler.getHandlerName());
        }
        this.updateNeeded = false;
    }
}

