/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.internal.core.ifeature.IFeature;
import org.eclipse.pde.internal.core.ifeature.IFeatureModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEFormSection;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditor;
import org.eclipse.pde.internal.ui.editor.feature.FeatureEditorContributor;
import org.eclipse.pde.internal.ui.editor.feature.FeatureFormPage;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.ResourceSelectionDialog;
import org.eclipse.update.ui.forms.internal.FormEntry;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;
import org.eclipse.update.ui.forms.internal.IFormTextListener;

public class FeatureSpecSection
extends PDEFormSection {
    public static final String SECTION_TITLE = "FeatureEditor.SpecSection.title";
    public static final String SECTION_DESC = "FeatureEditor.SpecSection.desc";
    public static final String SECTION_ID = "FeatureEditor.SpecSection.id";
    public static final String SECTION_NAME = "FeatureEditor.SpecSection.name";
    public static final String SECTION_VERSION = "FeatureEditor.SpecSection.version";
    public static final String SECTION_PROVIDER = "FeatureEditor.SpecSection.provider";
    public static final String SECTION_PLUGIN = "FeatureEditor.SpecSection.plugin";
    public static final String SECTION_IMAGE = "FeatureEditor.SpecSection.image";
    public static final String SECTION_BROWSE = "FeatureEditor.SpecSection.browse";
    public static final String SECTION_PRIMARY = "FeatureEditor.SpecSection.primary";
    public static final String SECTION_EXCLUSIVE = "FeatureEditor.SpecSection.exclusive";
    public static final String SECTION_CREATE_JAR = "FeatureEditor.SpecSection.createJar";
    public static final String SECTION_SYNCHRONIZE = "FeatureEditor.SpecSection.synchronize";
    public static final String KEY_BAD_VERSION_TITLE = "FeatureEditor.SpecSection.badVersionTitle";
    public static final String KEY_BAD_VERSION_MESSAGE = "FeatureEditor.SpecSection.badVersionMessage";
    private FormEntry idText;
    private FormEntry titleText;
    private FormEntry versionText;
    private FormEntry providerText;
    private FormEntry pluginText;
    private FormEntry imageText;
    private Button browseImageButton;
    private Button primaryButton;
    private Button exclusiveButton;
    private Button createJarButton;
    private Button synchronizeButton;
    private boolean updateNeeded;

    public FeatureSpecSection(FeatureFormPage page) {
        super(page);
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
    }

    public void commitChanges(boolean onSave) {
        IFeatureModel model = (IFeatureModel)this.getFormPage().getModel();
        IFeature feature = model.getFeature();
        this.titleText.commit();
        this.providerText.commit();
        this.pluginText.commit();
        this.idText.commit();
        this.versionText.commit();
        this.imageText.commit();
        try {
            feature.setPrimary(this.primaryButton.getSelection());
            feature.setExclusive(this.exclusiveButton.getSelection());
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        Composite container = factory.createComposite(parent);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.verticalSpacing = 9;
        layout.horizontalSpacing = 6;
        container.setLayout((Layout)layout);
        final IFeatureModel model = (IFeatureModel)this.getFormPage().getModel();
        final IFeature feature = model.getFeature();
        this.idText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_ID), factory, 2));
        this.idText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    feature.setId(text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void textDirty(FormEntry text) {
                FeatureSpecSection.this.forceDirty();
            }
        });
        this.idText.getControl().setEditable(false);
        this.titleText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_NAME), factory, 2));
        this.titleText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    feature.setLabel(text.getValue());
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
                FeatureSpecSection.this.getFormPage().getForm().setHeadingText(model.getResourceString(feature.getLabel()));
                ((FeatureEditor)FeatureSpecSection.this.getFormPage().getEditor()).updateTitle();
            }

            public void textDirty(FormEntry text) {
                FeatureSpecSection.this.forceDirty();
            }
        });
        this.versionText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_VERSION), factory, 2));
        this.versionText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                if (!FeatureSpecSection.this.verifySetVersion(feature, text.getValue())) {
                    FeatureSpecSection.this.warnBadVersionFormat(text.getValue());
                    text.setValue(feature.getVersion());
                }
            }

            public void textDirty(FormEntry text) {
                FeatureSpecSection.this.forceDirty();
            }
        });
        this.providerText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_PROVIDER), factory, 2));
        this.providerText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    feature.setProviderName(FeatureSpecSection.this.getNonNullValue(text.getValue()));
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void textDirty(FormEntry text) {
                FeatureSpecSection.this.forceDirty();
            }
        });
        this.pluginText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_PLUGIN), factory, 2));
        this.pluginText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    feature.setPlugin(FeatureSpecSection.this.getNonNullValue(text.getValue()));
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void textDirty(FormEntry text) {
                FeatureSpecSection.this.forceDirty();
            }
        });
        this.imageText = new FormEntry(this.createText(container, PDEPlugin.getResourceString(SECTION_IMAGE), factory));
        this.imageText.addFormTextListener(new IFormTextListener(){

            public void textValueChanged(FormEntry text) {
                try {
                    feature.setImageName(FeatureSpecSection.this.getNonNullValue(text.getValue()));
                }
                catch (CoreException e) {
                    PDEPlugin.logException(e);
                }
            }

            public void textDirty(FormEntry text) {
                FeatureSpecSection.this.forceDirty();
            }
        });
        GridData gd = (GridData)this.imageText.getControl().getLayoutData();
        gd.grabExcessHorizontalSpace = true;
        this.browseImageButton = factory.createButton(container, PDEPlugin.getResourceString(SECTION_BROWSE), 8);
        this.browseImageButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureSpecSection.this.handleBrowseImage();
            }
        });
        gd = (GridData)this.idText.getControl().getLayoutData();
        gd.widthHint = 150;
        Composite checkContainer = factory.createComposite(container);
        gd = new GridData(256);
        gd.horizontalSpan = 3;
        checkContainer.setLayoutData((Object)gd);
        GridLayout blayout = new GridLayout();
        checkContainer.setLayout((Layout)blayout);
        blayout.numColumns = 2;
        blayout.marginWidth = 0;
        blayout.marginHeight = 0;
        this.primaryButton = factory.createButton(checkContainer, PDEPlugin.getResourceString(SECTION_PRIMARY), 32);
        gd = new GridData(256);
        this.primaryButton.setLayoutData((Object)gd);
        this.primaryButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    feature.setPrimary(FeatureSpecSection.this.primaryButton.getSelection());
                }
                catch (CoreException ex) {
                    PDEPlugin.logException(ex);
                }
            }
        });
        this.exclusiveButton = factory.createButton(checkContainer, PDEPlugin.getResourceString(SECTION_EXCLUSIVE), 32);
        gd = new GridData(256);
        this.exclusiveButton.setLayoutData((Object)gd);
        this.exclusiveButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    feature.setExclusive(FeatureSpecSection.this.exclusiveButton.getSelection());
                }
                catch (CoreException ex) {
                    PDEPlugin.logException(ex);
                }
            }
        });
        Composite buttonContainer = factory.createComposite(container);
        gd = new GridData(128);
        gd.horizontalSpan = 3;
        buttonContainer.setLayoutData((Object)gd);
        blayout = new GridLayout();
        buttonContainer.setLayout((Layout)blayout);
        blayout.makeColumnsEqualWidth = true;
        blayout.numColumns = 2;
        blayout.marginWidth = 0;
        this.createJarButton = factory.createButton(buttonContainer, PDEPlugin.getResourceString(SECTION_CREATE_JAR), 8);
        this.createJarButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureSpecSection.this.handleCreateJar();
            }
        });
        gd = new GridData(770);
        this.createJarButton.setLayoutData((Object)gd);
        this.synchronizeButton = factory.createButton(buttonContainer, PDEPlugin.getResourceString(SECTION_SYNCHRONIZE), 8);
        this.synchronizeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                FeatureSpecSection.this.handleSynchronize();
            }
        });
        gd = new GridData(770);
        this.synchronizeButton.setLayoutData((Object)gd);
        factory.paintBordersFor(container);
        return container;
    }

    private String getNonNullValue(String value) {
        return value.length() > 0 ? value : null;
    }

    private void forceDirty() {
        this.setDirty(true);
        IModel model = (IModel)this.getFormPage().getModel();
        if (model instanceof IEditable) {
            IEditable editable = (IEditable)model;
            editable.setDirty(true);
            this.getFormPage().getEditor().fireSaveNeeded();
        }
    }

    private boolean verifySetVersion(IFeature feature, String value) {
        try {
            PluginVersionIdentifier pvi = new PluginVersionIdentifier(value);
            feature.setVersion(pvi.toString());
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    private void warnBadVersionFormat(String text) {
        MessageDialog.openError((Shell)PDEPlugin.getActiveWorkbenchShell(), (String)PDEPlugin.getResourceString(KEY_BAD_VERSION_TITLE), (String)PDEPlugin.getResourceString(KEY_BAD_VERSION_MESSAGE));
    }

    public void dispose() {
        IFeatureModel model = (IFeatureModel)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    private void handleCreateJar() {
        final FeatureEditorContributor contributor = (FeatureEditorContributor)this.getFormPage().getEditor().getContributor();
        BusyIndicator.showWhile((Display)this.createJarButton.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                contributor.getBuildAction().run();
            }
        });
    }

    private void handleSynchronize() {
        final FeatureEditorContributor contributor = (FeatureEditorContributor)this.getFormPage().getEditor().getContributor();
        BusyIndicator.showWhile((Display)this.synchronizeButton.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                contributor.getSynchronizeAction().run();
            }
        });
    }

    private void handleBrowseImage() {
        IFeatureModel model = (IFeatureModel)this.getFormPage().getModel();
        IResource resource = model.getUnderlyingResource();
        final IProject project = resource.getProject();
        BusyIndicator.showWhile((Display)this.primaryButton.getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ResourceSelectionDialog dialog = new ResourceSelectionDialog(FeatureSpecSection.this.primaryButton.getShell(), (IAdaptable)project, null);
                dialog.open();
                Object[] result = dialog.getResult();
                if (result == null || result.length == 0) {
                    return;
                }
                IResource resource = (IResource)result[0];
                FeatureSpecSection.this.acceptImage(resource);
            }
        });
    }

    private void acceptImage(IResource resource) {
        IPath path = resource.getProjectRelativePath();
        this.imageText.setValue(path.toString());
    }

    public void initialize(Object input) {
        IFeatureModel model = (IFeatureModel)input;
        this.update(input);
        if (!model.isEditable()) {
            this.idText.getControl().setEditable(false);
            this.titleText.getControl().setEditable(false);
            this.versionText.getControl().setEditable(false);
            this.providerText.getControl().setEditable(false);
            this.pluginText.getControl().setEditable(false);
            this.imageText.getControl().setEditable(false);
            this.primaryButton.setEnabled(false);
            this.exclusiveButton.setEnabled(false);
            this.createJarButton.setEnabled(false);
            this.synchronizeButton.setEnabled(false);
            this.browseImageButton.setEnabled(false);
        }
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public boolean isDirty() {
        return this.titleText.isDirty() || this.idText.isDirty() || this.providerText.isDirty() || this.pluginText.isDirty() || this.versionText.isDirty() || this.imageText.isDirty();
    }

    public void modelChanged(IModelChangedEvent e) {
        Object[] objs;
        if (e.getChangeType() == 99) {
            this.updateNeeded = true;
        } else if (e.getChangeType() == 3 && (objs = e.getChangedObjects()).length > 0 && objs[0] instanceof IFeature) {
            this.updateNeeded = true;
            if (this.getFormPage().isVisible()) {
                this.update();
            }
        }
    }

    public void setFocus() {
        if (this.idText != null) {
            this.idText.getControl().setFocus();
        }
    }

    private void setIfDefined(FormEntry formText, String value) {
        if (value != null) {
            formText.setValue(value, true);
        }
    }

    private void setIfDefined(Text text, String value) {
        if (value != null) {
            text.setText(value);
        }
    }

    public void update() {
        if (this.updateNeeded) {
            this.update(this.getFormPage().getModel());
        }
    }

    public void update(Object input) {
        IFeatureModel model = (IFeatureModel)input;
        IFeature feature = model.getFeature();
        this.setIfDefined(this.idText, feature.getId());
        this.setIfDefined(this.titleText, feature.getLabel());
        this.getFormPage().getForm().setHeadingText(model.getResourceString(feature.getLabel()));
        this.setIfDefined(this.versionText, feature.getVersion());
        this.setIfDefined(this.providerText, feature.getProviderName());
        this.setIfDefined(this.pluginText, feature.getPlugin());
        this.setIfDefined(this.imageText, feature.getImageName());
        this.primaryButton.setSelection(feature.isPrimary());
        this.exclusiveButton.setSelection(feature.isExclusive());
        this.updateNeeded = false;
    }

    public boolean canPaste(Clipboard clipboard) {
        return clipboard.getContents((Transfer)TextTransfer.getInstance()) != null;
    }
}

