/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.feature;

import java.util.Vector;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.pde.internal.core.ifeature.IFeatureObject;
import org.eclipse.pde.internal.ui.editor.ModifiedTextPropertyDescriptor;
import org.eclipse.ui.views.properties.ComboBoxPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertyDescriptor;
import org.eclipse.ui.views.properties.IPropertySource;
import org.eclipse.ui.views.properties.PropertyDescriptor;

public abstract class FeaturePropertySource
implements IPropertySource {
    protected IFeatureObject object;

    public FeaturePropertySource(IFeatureObject object) {
        this.object = object;
    }

    protected PropertyDescriptor createTextPropertyDescriptor(String name, String displayName) {
        if (this.isEditable()) {
            return new ModifiedTextPropertyDescriptor(name, displayName);
        }
        return new PropertyDescriptor((Object)name, displayName);
    }

    protected PropertyDescriptor createChoicePropertyDescriptor(String name, String displayName, final String[] choices) {
        if (this.isEditable()) {
            ComboBoxPropertyDescriptor desc = new ComboBoxPropertyDescriptor((Object)name, displayName, choices);
            desc.setLabelProvider((ILabelProvider)new LabelProvider(){

                public String getText(Object obj) {
                    Integer index = (Integer)obj;
                    return choices[index];
                }
            });
            return desc;
        }
        return new PropertyDescriptor((Object)name, displayName);
    }

    public Object getEditableValue() {
        return null;
    }

    public boolean isEditable() {
        return this.object.getModel().isEditable();
    }

    public boolean isPropertySet(Object property) {
        return false;
    }

    public void resetPropertyValue(Object property) {
    }

    protected IPropertyDescriptor[] toDescriptorArray(Vector result) {
        Object[] array = new IPropertyDescriptor[result.size()];
        result.copyInto(array);
        return array;
    }

    public abstract IPropertyDescriptor[] getPropertyDescriptors();

    public abstract Object getPropertyValue(Object var1);

    public abstract void setPropertyValue(Object var1, Object var2);
}

