/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import java.util.Vector;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.dialogs.SelectionDialog;
import org.eclipse.ui.help.WorkbenchHelp;

public class VariableSelectionDialog
extends SelectionDialog {
    public static final String DIALOG_LABEL = "BuildEditor.VariableSection.dialogLabel";
    public static final String DIALOG_LIST = "BuildEditor.VariableSection.dialogList";
    private TableViewer variableTable;
    private String selectedVariable;
    private IBuildModel model;
    private Image variableImage = PDEPluginImages.DESC_BUILD_VAR_OBJ.createImage();
    private Text resultText;
    private static final String[] supportedVariables = new String[]{"bin.includes", "bin.excludes", "src.includes", "src.excludes", "custom", "jars.extra.classpath", "jars.compile.order"};

    public VariableSelectionDialog(Shell parentShell, IBuildModel model) {
        super(parentShell);
        this.model = model;
    }

    public boolean close() {
        this.variableImage.dispose();
        return super.close();
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        this.getOkButton().setEnabled(false);
    }

    public Control createDialogArea(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        container.setLayout((Layout)layout);
        container.setLayoutData((Object)new GridData(1808));
        Label label = new Label(container, 0);
        label.setText(PDEPlugin.getResourceString(DIALOG_LABEL));
        this.resultText = new Text(container, 2052);
        this.resultText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                VariableSelectionDialog.this.getOkButton().setEnabled(VariableSelectionDialog.this.resultText.getText().length() > 0);
            }
        });
        GridData gd = new GridData(768);
        this.resultText.setLayoutData((Object)gd);
        Table table = new Table(container, 67584);
        TableLayout tlayout = new TableLayout();
        TableColumn tableColumn = new TableColumn(table, 0);
        tableColumn.setText(PDEPlugin.getResourceString(DIALOG_LIST));
        ColumnWeightData cLayout = new ColumnWeightData(100, true);
        tlayout.addColumnData((ColumnLayoutData)cLayout);
        table.setLayout((Layout)tlayout);
        gd = new GridData(1808);
        gd.horizontalSpan = 2;
        table.setLayoutData((Object)gd);
        this.variableTable = new TableViewer(table);
        this.variableTable.setContentProvider((IContentProvider)new TableContentProvider());
        this.variableTable.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        this.variableTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                ISelection sel = e.getSelection();
                Object obj = ((IStructuredSelection)sel).getFirstElement();
                VariableSelectionDialog.this.resultText.setText(obj != null ? obj.toString() : "");
            }
        });
        this.variableTable.setInput((Object)this.model);
        WorkbenchHelp.setHelp((Control)container, (String)"org.eclipse.pde.doc.user.build_add_variable");
        return container;
    }

    private Object[] getRemainingVariables() {
        IBuild build = this.model.getBuild();
        Vector<String> remaining = new Vector<String>();
        int i = 0;
        while (i < supportedVariables.length) {
            String variable = supportedVariables[i];
            if (build.getEntry(variable) == null) {
                remaining.add(variable);
            }
            ++i;
        }
        return remaining.toArray();
    }

    public String getSelectedVariable() {
        return this.selectedVariable;
    }

    protected void okPressed() {
        this.selectedVariable = this.resultText.getText();
        super.okPressed();
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object input) {
            return VariableSelectionDialog.this.getRemainingVariables();
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return VariableSelectionDialog.this.variableImage;
        }
    }
}

