/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuild;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.pde.internal.ui.editor.build.VariableSelectionDialog;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.pde.internal.ui.util.SWTUtil;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Item;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class VariableSection
extends TableSection
implements IModelChangedListener {
    public static final String SECTION_TITLE = "BuildEditor.VariableSection.title";
    public static final String DIALOG_TITLE = "BuildEditor.VariableSection.dialogTitle";
    public static final String POPUP_NEW_VARIABLE = "BuildEditor.VariableSection.newVariable";
    public static final String POPUP_DELETE = "BuildEditor.VariableSection.delete";
    public static final String SECTION_NEW = "BuildEditor.VariableSection.new";
    public static final String SECTION_DESC = "BuildEditor.VariableSection.desc";
    private FormWidgetFactory factory;
    private TableViewer variableTable;

    public VariableSection(BuildPage page) {
        super(page, new String[]{PDEPlugin.getResourceString(SECTION_NEW)});
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.factory = factory;
        Composite container = this.createClientContainer(parent, 2, factory);
        EditableTablePart tablePart = this.getTablePart();
        IBuildModel model = (IBuildModel)this.getFormPage().getModel();
        tablePart.setEditable(model.isEditable());
        this.createViewerPartControl(container, 65536, 2, factory);
        this.variableTable = tablePart.getTableViewer();
        this.variableTable.setContentProvider((IContentProvider)new TableContentProvider());
        this.variableTable.setLabelProvider((IBaseLabelProvider)PDEPlugin.getDefault().getLabelProvider());
        factory.paintBordersFor(container);
        return container;
    }

    protected void selectionChanged(IStructuredSelection selection) {
        Object item = selection.getFirstElement();
        this.fireSelectionNotification(item);
        this.getFormPage().setSelection((ISelection)selection);
    }

    protected void entryModified(Object object, String newValue) {
        Item item = (Item)object;
        final IBuildEntry entry = (IBuildEntry)item.getData();
        try {
            if (newValue.equals(entry.getName())) {
                return;
            }
            entry.setName(newValue);
            this.setDirty(true);
            this.commitChanges(false);
            this.variableTable.getTable().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    VariableSection.this.variableTable.update((Object)entry, null);
                }
            });
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleNew();
        }
    }

    public void dispose() {
        IBuildModel model = (IBuildModel)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals("delete")) {
            this.handleDelete();
            return true;
        }
        return false;
    }

    public void expandTo(Object object) {
        this.variableTable.setSelection((ISelection)new StructuredSelection(object), true);
    }

    protected void fillContextMenu(IMenuManager manager) {
        IModel model = (IModel)this.getFormPage().getModel();
        if (!model.isEditable()) {
            return;
        }
        ISelection selection = this.variableTable.getSelection();
        manager.add((IAction)new Action(PDEPlugin.getResourceString(POPUP_NEW_VARIABLE)){

            public void run() {
                VariableSection.this.handleNew();
            }
        });
        if (!selection.isEmpty()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

                public void run() {
                    VariableSection.this.handleDelete();
                }
            });
        }
        manager.add((IContributionItem)new Separator());
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleDelete() {
        Object object = ((IStructuredSelection)this.variableTable.getSelection()).getFirstElement();
        if (object != null && object instanceof IBuildEntry) {
            IBuildEntry entry = (IBuildEntry)object;
            IBuild build = entry.getModel().getBuild();
            try {
                build.remove(entry);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleNew() {
        final IBuildModel model = (IBuildModel)this.getFormPage().getModel();
        final IBuild build = model.getBuild();
        BusyIndicator.showWhile((Display)this.variableTable.getTable().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                VariableSelectionDialog dialog = new VariableSelectionDialog(PDEPlugin.getActiveWorkbenchShell(), model);
                dialog.create();
                dialog.getShell().setText(PDEPlugin.getResourceString(VariableSection.DIALOG_TITLE));
                SWTUtil.setDialogSize((Dialog)dialog, 300, 350);
                if (dialog.open() == 0) {
                    IBuildEntry entry = model.getFactory().createEntry(dialog.getSelectedVariable());
                    try {
                        build.add(entry);
                    }
                    catch (CoreException e) {
                        PDEPlugin.logException(e);
                    }
                }
            }
        });
    }

    public void initialize(Object input) {
        IBuildModel model = (IBuildModel)input;
        this.variableTable.setInput((Object)model);
        this.setReadOnly(!model.isEditable());
        this.getTablePart().setButtonEnabled(0, model.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.variableTable.refresh();
            return;
        }
        Object changeObject = event.getChangedObjects()[0];
        if (changeObject instanceof IBuildEntry) {
            if (event.getChangeType() == 1) {
                this.variableTable.add(changeObject);
            } else if (event.getChangeType() == 2) {
                this.variableTable.remove(changeObject);
            } else if (event.getChangedProperty() == null) {
                this.variableTable.update(changeObject, null);
            }
        }
    }

    public void setFocus() {
        this.variableTable.getTable().setFocus();
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IBuildModel) {
                Object[] result = ((IBuildModel)parent).getBuild().getBuildEntries();
                return result;
            }
            return new Object[0];
        }
    }
}

