/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import java.io.Serializable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.TableSection;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.pde.internal.ui.elements.DefaultContentProvider;
import org.eclipse.pde.internal.ui.parts.EditableTablePart;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Item;
import org.eclipse.update.ui.forms.internal.FormSection;
import org.eclipse.update.ui.forms.internal.FormWidgetFactory;

public class TokenSection
extends TableSection
implements IModelChangedListener {
    public static final String SECTION_TITLE = "BuildEditor.TokenSection.title";
    public static final String POPUP_NEW_TOKEN = "BuildEditor.TokenSection.newToken";
    public static final String POPUP_DELETE = "BuildEditor.TokenSection.delete";
    public static final String ENTRY = "BuildEditor.TokenSection.entry";
    public static final String SECTION_NEW = "BuildEditor.TokenSection.new";
    public static final String SECTION_DESC = "BuildEditor.TokenSection.desc";
    private FormWidgetFactory factory;
    private TableViewer entryTable;
    private IBuildEntry currentVariable;

    public TokenSection(BuildPage page) {
        super(page, new String[]{PDEPlugin.getResourceString(SECTION_NEW)});
        this.setHeaderText(PDEPlugin.getResourceString(SECTION_TITLE));
        this.setDescription(PDEPlugin.getResourceString(SECTION_DESC));
    }

    public Composite createClient(Composite parent, FormWidgetFactory factory) {
        this.factory = factory;
        this.initializeImages();
        Composite container = this.createClientContainer(parent, 2, factory);
        EditableTablePart tablePart = this.getTablePart();
        IModel model = (IModel)this.getFormPage().getModel();
        tablePart.setEditable(model.isEditable());
        this.createViewerPartControl(container, 65536, 2, factory);
        this.entryTable = tablePart.getTableViewer();
        this.entryTable.setContentProvider((IContentProvider)new TableContentProvider());
        this.entryTable.setLabelProvider((IBaseLabelProvider)new TableLabelProvider());
        factory.paintBordersFor(container);
        this.entryTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
            }
        });
        return container;
    }

    protected void buttonSelected(int index) {
        if (index == 0) {
            this.handleNew();
        }
    }

    protected void selectionChanged(IStructuredSelection selection) {
        Object item = selection.getFirstElement();
        this.fireSelectionNotification(item);
        this.getFormPage().setSelection((ISelection)selection);
    }

    protected void entryModified(Object entry, String newValue) {
        Item item = (Item)entry;
        final Token token = (Token)item.getData();
        try {
            this.currentVariable.renameToken(token.name, newValue.toString());
            token.name = newValue.toString();
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
        this.entryTable.getTable().getDisplay().asyncExec(new Runnable(){

            public void run() {
                TokenSection.this.entryTable.update((Object)token, null);
            }
        });
    }

    public void dispose() {
        IBuildModel model = (IBuildModel)this.getFormPage().getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
        super.dispose();
    }

    public boolean doGlobalAction(String actionId) {
        if (actionId.equals("delete")) {
            this.handleDelete();
            return true;
        }
        return false;
    }

    protected void fillContextMenu(IMenuManager manager) {
        IModel model = (IModel)this.getFormPage().getModel();
        if (!model.isEditable()) {
            return;
        }
        ISelection selection = this.entryTable.getSelection();
        manager.add((IAction)new Action(PDEPlugin.getResourceString(POPUP_NEW_TOKEN)){

            public void run() {
                TokenSection.this.handleNew();
            }
        });
        if (!selection.isEmpty()) {
            manager.add((IContributionItem)new Separator());
            manager.add((IAction)new Action(PDEPlugin.getResourceString(POPUP_DELETE)){

                public void run() {
                    TokenSection.this.handleDelete();
                }
            });
        }
        manager.add((IContributionItem)new Separator());
        this.getFormPage().getEditor().getContributor().contextMenuAboutToShow(manager);
    }

    private void handleDelete() {
        IBuildEntry entry;
        IBuildModel buildModel = (IBuildModel)this.getFormPage().getModel();
        if (!buildModel.isEditable()) {
            return;
        }
        Object object = ((IStructuredSelection)this.entryTable.getSelection()).getFirstElement();
        if (object != null && object instanceof Token && (entry = this.currentVariable) != null) {
            try {
                entry.removeToken(object.toString());
                this.entryTable.remove(object);
            }
            catch (CoreException e) {
                PDEPlugin.logException(e);
            }
        }
    }

    private void handleNew() {
        if (this.currentVariable == null) {
            return;
        }
        try {
            Token token = new Token(PDEPlugin.getResourceString(ENTRY));
            this.currentVariable.addToken(token.toString());
            this.entryTable.add((Object)token);
            this.entryTable.editElement((Object)token, 0);
        }
        catch (CoreException e) {
            PDEPlugin.logException(e);
        }
    }

    public void initialize(Object input) {
        IBuildModel model = (IBuildModel)input;
        this.setReadOnly(!model.isEditable());
        this.getTablePart().setButtonEnabled(0, model.isEditable());
        model.addModelChangedListener((IModelChangedListener)this);
    }

    private void initializeImages() {
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.entryTable.refresh();
            return;
        }
    }

    public void sectionChanged(FormSection source, int changeType, Object changeObject) {
        IBuildEntry variable = (IBuildEntry)changeObject;
        this.update(variable);
    }

    public void setFocus() {
        this.entryTable.getTable().setFocus();
    }

    private void update(IBuildEntry variable) {
        this.currentVariable = variable;
        this.entryTable.setInput((Object)this.currentVariable);
    }

    static class Token
    implements Serializable {
        String name;

        public Token(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }

    class TableContentProvider
    extends DefaultContentProvider
    implements IStructuredContentProvider {
        TableContentProvider() {
        }

        public Object[] getElements(Object parent) {
            if (parent instanceof IBuildEntry) {
                IBuildEntry entry = (IBuildEntry)parent;
                return this.createTokens(entry.getTokens());
            }
            return new Object[0];
        }

        Object[] createTokens(String[] tokens) {
            Object[] result = new Token[tokens.length];
            int i = 0;
            while (i < tokens.length) {
                result[i] = new Token(tokens[i]);
                ++i;
            }
            return result;
        }
    }

    class TableLabelProvider
    extends LabelProvider
    implements ITableLabelProvider {
        TableLabelProvider() {
        }

        public String getColumnText(Object obj, int index) {
            return obj.toString();
        }

        public Image getColumnImage(Object obj, int index) {
            return null;
        }
    }
}

