/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.core.IModel;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.core.PDECore;
import org.eclipse.pde.internal.core.WorkspaceModelManager;
import org.eclipse.pde.internal.core.build.ExternalBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageEditor;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.pde.internal.ui.editor.build.BuildSourcePage;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IStorageEditorInput;

public class BuildPropertiesEditor
extends PDEMultiPageEditor {
    public static final String BUILD_PAGE_TITLE = "BuildEditor.BuildPage.title";
    public static final String BUILD_PAGE = "BuildPage";
    public static final String SOURCE_PAGE = "SourcePage";
    private boolean storageModel = false;

    protected Object createModel(Object input) throws CoreException {
        if (input instanceof IFile) {
            return this.createResourceModel((IFile)input);
        }
        if (input instanceof IStorage) {
            return this.createStorageModel((IStorage)input);
        }
        return null;
    }

    protected void createPages() {
        this.firstPageId = BUILD_PAGE;
        this.formWorkbook.setFirstPageSelected(false);
        BuildPage buildPage = new BuildPage(this, PDEPlugin.getResourceString(BUILD_PAGE_TITLE));
        this.addPage(BUILD_PAGE, buildPage);
        this.addPage(SOURCE_PAGE, new BuildSourcePage(this));
    }

    private IBuildModel createResourceModel(IFile file) throws CoreException {
        InputStream stream = null;
        stream = file.getContents(false);
        WorkspaceModelManager provider = PDECore.getDefault().getWorkspaceModelManager();
        provider.connect((Object)file, (Object)this);
        IBuildModel model = (IBuildModel)provider.getModel((Object)file, (Object)this);
        try {
            model.load(stream, false);
        }
        catch (CoreException coreException) {}
        try {
            stream.close();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        return model;
    }

    private IBuildModel createStorageModel(IStorage storage) throws CoreException {
        InputStream stream = null;
        stream = storage.getContents();
        ExternalBuildModel model = new ExternalBuildModel("");
        model.load(stream, false);
        try {
            stream.close();
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
        this.storageModel = true;
        return model;
    }

    public void dispose() {
        super.dispose();
        WorkspaceModelManager provider = PDECore.getDefault().getWorkspaceModelManager();
        IModel model = (IModel)this.getModel();
        if (this.storageModel) {
            model.dispose();
        } else {
            provider.disconnect((Object)model.getUnderlyingResource(), (Object)this);
        }
    }

    public IPDEEditorPage getHomePage() {
        return this.getPage(BUILD_PAGE);
    }

    protected String getSourcePageId() {
        return SOURCE_PAGE;
    }

    public String getTitle() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof IStorageEditorInput && !(input instanceof IFileEditorInput)) {
            return ((IStorageEditorInput)input).getName();
        }
        return super.getTitle();
    }

    protected boolean isModelDirty(Object model) {
        return model != null && model instanceof IEditable && model instanceof IModel && ((IModel)model).isEditable() && ((IEditable)model).isDirty();
    }

    protected boolean isValidContentType(IEditorInput input) {
        String name = input.getName().toLowerCase();
        if (input instanceof IStorageEditorInput && !(input instanceof IFileEditorInput)) {
            return name.startsWith("build.properties");
        }
        return name.equals("build.properties");
    }

    protected boolean updateModel() {
        IBuildModel model = (IBuildModel)this.getModel();
        IDocument document = this.getDocumentProvider().getDocument((Object)this.getEditorInput());
        String text = document.get();
        boolean cleanModel = true;
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(text.getBytes("UTF8"));
            try {
                model.reload((InputStream)stream, false);
                if (model instanceof IEditable) {
                    ((IEditable)model).setDirty(false);
                    this.fireSaveNeeded();
                }
            }
            catch (CoreException coreException) {
                cleanModel = false;
            }
            try {
                ((InputStream)stream).close();
            }
            catch (IOException iOException) {}
        }
        catch (UnsupportedEncodingException e) {
            PDEPlugin.logException(e);
        }
        return cleanModel;
    }
}

