/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor.build;

import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.pde.core.IModelChangedEvent;
import org.eclipse.pde.core.IModelChangedListener;
import org.eclipse.pde.core.build.IBuildEntry;
import org.eclipse.pde.core.build.IBuildModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEPluginImages;
import org.eclipse.pde.internal.ui.editor.FormOutlinePage;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEFormPage;
import org.eclipse.pde.internal.ui.editor.build.BuildPage;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;

public class BuildOutlinePage
extends FormOutlinePage {
    private Image variableImage = PDEPlugin.getDefault().getLabelProvider().get(PDEPluginImages.DESC_BUILD_VAR_OBJ);

    public BuildOutlinePage(PDEFormPage formPage) {
        super(formPage);
    }

    protected ITreeContentProvider createContentProvider() {
        return new ContentProvider();
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        IBuildModel model = (IBuildModel)this.formPage.getModel();
        model.addModelChangedListener((IModelChangedListener)this);
    }

    protected ILabelProvider createLabelProvider() {
        return new OutlineLabelProvider();
    }

    public void dispose() {
        super.dispose();
        IBuildModel model = (IBuildModel)this.formPage.getModel();
        model.removeModelChangedListener((IModelChangedListener)this);
    }

    Image getObjectImage(Object obj) {
        if (obj instanceof IBuildEntry) {
            return this.variableImage;
        }
        return null;
    }

    String getObjectLabel(Object obj) {
        if (obj instanceof IBuildEntry) {
            return ((IBuildEntry)obj).getName();
        }
        return null;
    }

    public IPDEEditorPage getParentPage(Object item) {
        if (item instanceof IBuildEntry) {
            return this.formPage.getEditor().getPage("BuildPage");
        }
        return super.getParentPage(item);
    }

    IBuildEntry[] getVariables() {
        IBuildModel model = (IBuildModel)this.formPage.getModel();
        return model.getBuild().getBuildEntries();
    }

    public void modelChanged(IModelChangedEvent event) {
        if (event.getChangeType() == 99) {
            this.treeViewer.refresh();
            this.treeViewer.expandAll();
            return;
        }
        Object object = event.getChangedObjects()[0];
        if (event.getChangeType() == 3) {
            this.treeViewer.update(object, null);
        } else {
            IPDEEditorPage parent = null;
            if (object instanceof String) {
                return;
            }
            if (object instanceof IBuildEntry) {
                parent = this.getParentPage(object);
            }
            if (parent != null) {
                if (event.getChangeType() == 1) {
                    this.treeViewer.add((Object)parent, object);
                } else {
                    this.treeViewer.remove(object);
                }
            } else {
                this.treeViewer.refresh();
                this.treeViewer.expandAll();
            }
        }
    }

    class ContentProvider
    extends FormOutlinePage.BasicContentProvider {
        ContentProvider() {
            super(BuildOutlinePage.this);
        }

        public Object[] getChildren(Object parent) {
            if (parent instanceof BuildPage) {
                return BuildOutlinePage.this.getVariables();
            }
            return super.getChildren(parent);
        }

        public Object getParent(Object child) {
            return super.getParent(child);
        }
    }

    class OutlineLabelProvider
    extends FormOutlinePage.BasicLabelProvider {
        OutlineLabelProvider() {
            super(BuildOutlinePage.this);
        }

        public String getText(Object obj) {
            String label = BuildOutlinePage.this.getObjectLabel(obj);
            if (label != null) {
                return label;
            }
            return super.getText(obj);
        }

        public Image getImage(Object obj) {
            Image image = BuildOutlinePage.this.getObjectImage(obj);
            if (image != null) {
                return image;
            }
            return super.getImage(obj);
        }
    }
}

