/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import org.eclipse.jface.text.ITextDoubleClickStrategy;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.IPresentationDamager;
import org.eclipse.jface.text.presentation.IPresentationReconciler;
import org.eclipse.jface.text.presentation.IPresentationRepairer;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.source.IAnnotationHover;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.pde.internal.ui.editor.XMLDoubleClickStrategy;
import org.eclipse.pde.internal.ui.editor.text.AnnotationHover;
import org.eclipse.pde.internal.ui.editor.text.IColorManager;
import org.eclipse.pde.internal.ui.editor.text.NonRuleBasedDamagerRepairer;
import org.eclipse.pde.internal.ui.editor.text.PDEScanner;
import org.eclipse.pde.internal.ui.editor.text.PDETagScanner;

public class XMLConfiguration
extends SourceViewerConfiguration {
    private XMLDoubleClickStrategy doubleClickStrategy;
    private PDETagScanner tagScanner;
    private PDEScanner pdeScanner;
    private IColorManager colorManager;

    public XMLConfiguration(IColorManager colorManager) {
        this.colorManager = colorManager;
    }

    public String[] getConfiguredContentTypes(ISourceViewer sourceViewer) {
        return new String[]{"__dftl_partition_content_type", "__xml_comment", "__xml_tag"};
    }

    public ITextDoubleClickStrategy getDoubleClickStrategy(ISourceViewer sourceViewer, String contentType) {
        if (this.doubleClickStrategy == null) {
            this.doubleClickStrategy = new XMLDoubleClickStrategy();
        }
        return this.doubleClickStrategy;
    }

    protected PDEScanner getPDEScanner() {
        if (this.pdeScanner == null) {
            this.pdeScanner = new PDEScanner(this.colorManager);
            this.pdeScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor("editor.color.default"))));
        }
        return this.pdeScanner;
    }

    protected PDETagScanner getPDETagScanner() {
        if (this.tagScanner == null) {
            this.tagScanner = new PDETagScanner(this.colorManager);
            this.tagScanner.setDefaultReturnToken((IToken)new Token((Object)new TextAttribute(this.colorManager.getColor("editor.color.tag"))));
        }
        return this.tagScanner;
    }

    public IPresentationReconciler getPresentationReconciler(ISourceViewer sourceViewer) {
        PresentationReconciler reconciler = new PresentationReconciler();
        DefaultDamagerRepairer dr = new DefaultDamagerRepairer((ITokenScanner)this.getPDEScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__dftl_partition_content_type");
        reconciler.setRepairer((IPresentationRepairer)dr, "__dftl_partition_content_type");
        dr = new DefaultDamagerRepairer((ITokenScanner)this.getPDETagScanner());
        reconciler.setDamager((IPresentationDamager)dr, "__xml_tag");
        reconciler.setRepairer((IPresentationRepairer)dr, "__xml_tag");
        NonRuleBasedDamagerRepairer ndr = new NonRuleBasedDamagerRepairer(new TextAttribute(this.colorManager.getColor("editor.color.xml_comment")));
        reconciler.setDamager((IPresentationDamager)ndr, "__xml_comment");
        reconciler.setRepairer((IPresentationRepairer)ndr, "__xml_comment");
        return reconciler;
    }

    public IAnnotationHover getAnnotationHover(ISourceViewer sourceViewer) {
        return new AnnotationHover();
    }
}

