/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.ui.texteditor.AbstractDocumentProvider;

public abstract class StreamDocumentProvider
extends AbstractDocumentProvider {
    private IDocumentPartitioner partitioner;
    private String enc;

    public StreamDocumentProvider(IDocumentPartitioner partitioner, String encoding) {
        this.partitioner = partitioner;
        this.enc = encoding;
    }

    protected IDocumentPartitioner getPartitioner() {
        return this.partitioner;
    }

    protected String getEncoding() {
        return this.enc;
    }

    protected IAnnotationModel createAnnotationModel(Object element) throws CoreException {
        return null;
    }

    protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean force) throws CoreException {
    }

    protected void setDocumentContent(IDocument document, InputStream contentStream) {
        try {
            InputStreamReader in = this.enc == null ? new InputStreamReader(contentStream) : new InputStreamReader(contentStream, this.enc);
            int chunkSize = contentStream.available();
            StringBuffer buffer = new StringBuffer(chunkSize);
            char[] readBuffer = new char[chunkSize];
            int n = in.read(readBuffer);
            while (n > 0) {
                buffer.append(readBuffer);
                n = in.read(readBuffer);
            }
            ((Reader)in).close();
            document.set(buffer.toString());
        }
        catch (IOException e) {
            PDEPlugin.logException(e);
        }
    }

    public long getSynchronizationStamp(Object element) {
        return 0L;
    }

    public long getModificationStamp(Object element) {
        return 0L;
    }

    public boolean isDeleted(Object element) {
        return false;
    }

    protected IDocument createEmptyDocument() {
        return new Document();
    }
}

