/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;

public class PDEMultiSelectionProvider
implements ISelectionProvider {
    private Vector listeners = new Vector();
    private ISelection selection;
    private PDESourcePage sourcePage;

    public void setSourcePage(PDESourcePage sourcePage) {
        this.sourcePage = sourcePage;
        this.hookSourceSelectionProvider();
    }

    private void hookSourceSelectionProvider() {
        if (this.sourcePage == null) {
            return;
        }
        ISelectionProvider sourceProvider = this.sourcePage.getSelectionProvider();
        sourceProvider.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent e) {
                if (PDEMultiSelectionProvider.this.sourcePage.isVisible()) {
                    PDEMultiSelectionProvider.this.setSelection(e.getSelection());
                }
            }
        });
    }

    public PDESourcePage getSourcePage() {
        return this.sourcePage;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.addElement(listener);
    }

    public ISelection getSelection() {
        if (this.sourcePage != null && this.sourcePage.isVisible()) {
            return this.sourcePage.getSelectionProvider().getSelection();
        }
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.removeElement(listener);
    }

    public synchronized void setSelection(ISelection selection) {
        this.selection = selection;
        SelectionChangedEvent event = new SelectionChangedEvent((ISelectionProvider)this, selection);
        Iterator iter = ((AbstractList)((Vector)this.listeners.clone())).iterator();
        while (iter.hasNext()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)iter.next();
            listener.selectionChanged(event);
        }
    }
}

