/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.rules.DefaultPartitioner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageEditor;
import org.eclipse.pde.internal.ui.editor.StorageDocumentProvider;
import org.eclipse.pde.internal.ui.editor.SystemFileDocumentProvider;
import org.eclipse.pde.internal.ui.editor.text.PDEPartitionScanner;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.dialogs.ContainerGenerator;
import org.eclipse.ui.editors.text.FileDocumentProvider;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ResourceMarkerAnnotationModel;

public abstract class PDEMultiPageXMLEditor
extends PDEMultiPageEditor {
    protected IDocumentPartitioner createDocumentPartitioner() {
        DefaultPartitioner partitioner = new DefaultPartitioner((IPartitionTokenScanner)new PDEPartitionScanner(), new String[]{"__xml_tag", "__xml_comment"});
        return partitioner;
    }

    protected IDocumentProvider createDocumentProvider(Object input) {
        Object documentProvider = null;
        if (input instanceof IFile) {
            documentProvider = new UTF8FileDocumentProvider();
        } else if (input instanceof File) {
            documentProvider = new SystemFileDocumentProvider(this.createDocumentPartitioner(), "UTF8");
        } else if (input instanceof IStorage) {
            documentProvider = new StorageDocumentProvider(this.createDocumentPartitioner(), "UTF8");
        }
        return documentProvider;
    }

    protected class UTF8FileDocumentProvider
    extends FileDocumentProvider {
        protected UTF8FileDocumentProvider() {
        }

        public IDocument createDocument(Object element) throws CoreException {
            IDocumentPartitioner partitioner;
            IDocument document = super.createDocument(element);
            if (document != null && (partitioner = PDEMultiPageXMLEditor.this.createDocumentPartitioner()) != null) {
                partitioner.connect(document);
                document.setDocumentPartitioner(partitioner);
            }
            return document;
        }

        protected void setDocumentContent(IDocument document, InputStream contentStream, String encoding) throws CoreException {
            block10: {
                InputStreamReader in = null;
                try {
                    try {
                        in = new InputStreamReader((InputStream)new BufferedInputStream(contentStream), "UTF8");
                        StringBuffer buffer = new StringBuffer();
                        char[] readBuffer = new char[2048];
                        int n = in.read(readBuffer);
                        while (n > 0) {
                            buffer.append(readBuffer, 0, n);
                            n = in.read(readBuffer);
                        }
                        document.set(buffer.toString());
                    }
                    catch (IOException x) {
                        PDEPlugin.logException(x);
                    }
                }
                catch (Throwable throwable) {
                    Object var8_10 = null;
                    if (in != null) {
                        try {
                            ((Reader)in).close();
                        }
                        catch (IOException iOException) {}
                    }
                    throw throwable;
                }
                Object var8_11 = null;
                if (in == null) break block10;
                try {
                    ((Reader)in).close();
                }
                catch (IOException iOException) {}
            }
        }

        protected void doSaveDocument(IProgressMonitor monitor, Object element, IDocument document, boolean overwrite) throws CoreException {
            if (element instanceof IFileEditorInput) {
                InputStream stream;
                block14: {
                    IFileEditorInput input = (IFileEditorInput)element;
                    stream = null;
                    try {
                        try {
                            stream = new ByteArrayInputStream(document.get().getBytes("UTF8"));
                            IFile file = input.getFile();
                            if (file.exists()) {
                                FileDocumentProvider.FileInfo info = (FileDocumentProvider.FileInfo)this.getElementInfo(element);
                                if (info != null && !overwrite) {
                                    this.checkSynchronizationState(info.fModificationStamp, (IResource)file);
                                }
                                file.setContents(stream, overwrite, true, monitor);
                                if (info != null) {
                                    ResourceMarkerAnnotationModel model = (ResourceMarkerAnnotationModel)info.fModel;
                                    model.updateMarkers(info.fDocument);
                                    info.fModificationStamp = this.computeModificationStamp((IResource)file);
                                }
                                break block14;
                            }
                            try {
                                monitor.beginTask("Saving", 2000);
                                ContainerGenerator generator = new ContainerGenerator(file.getParent().getFullPath());
                                generator.generateContainer((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                                file.create(stream, false, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                            }
                            catch (Throwable throwable) {
                                Object var9_11 = null;
                                monitor.done();
                                throw throwable;
                            }
                            Object var9_12 = null;
                            monitor.done();
                        }
                        catch (UnsupportedEncodingException unsupportedEncodingException) {}
                    }
                    catch (Throwable throwable) {
                        Object var11_15 = null;
                        try {
                            stream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                }
                Object var11_16 = null;
                try {
                    stream.close();
                }
                catch (IOException iOException) {}
            } else {
                super.doSaveDocument(monitor, element, document, overwrite);
            }
        }
    }
}

