/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.editor;

import java.util.Hashtable;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.action.SubMenuManager;
import org.eclipse.jface.action.SubStatusLineManager;
import org.eclipse.jface.action.SubToolBarManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.pde.core.IEditable;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.editor.IPDEEditorPage;
import org.eclipse.pde.internal.ui.editor.PDEMultiPageEditor;
import org.eclipse.pde.internal.ui.editor.PDESourcePage;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.EditorActionBarContributor;
import org.eclipse.ui.texteditor.BasicTextEditorActionContributor;
import org.eclipse.ui.texteditor.IUpdate;

public abstract class PDEEditorContributor
extends EditorActionBarContributor {
    public static final String ACTIONS_SAVE = "EditorActions.save";
    public static final String ACTIONS_CUT = "EditorActions.cut";
    public static final String ACTIONS_COPY = "EditorActions.copy";
    public static final String ACTIONS_PASTE = "EditorActions.paste";
    public static final String ACTIONS_REVERT = "EditorActions.revert";
    private SubMenuManager subMenuManager;
    private SubStatusLineManager subStatusManager;
    private SubToolBarManager subToolbarManager;
    private PDEMultiPageEditor editor;
    private IPDEEditorPage page;
    private SaveAction saveAction;
    private RevertAction revertAction;
    private ClipboardAction cutAction;
    private ClipboardAction copyAction;
    private ClipboardAction pasteAction;
    private Hashtable globalActions = new Hashtable();
    private String menuName;
    private BasicTextEditorActionContributor sourceContributor;

    public PDEEditorContributor(String menuName) {
        this.menuName = menuName;
        this.sourceContributor = new BasicTextEditorActionContributor();
        this.makeActions();
    }

    private void addGlobalAction(String id) {
        GlobalAction action = new GlobalAction(id);
        this.addGlobalAction(id, action);
    }

    private void addGlobalAction(String id, Action action) {
        this.globalActions.put(id, action);
    }

    public void addClipboardActions(IMenuManager mng) {
        mng.add((IAction)this.cutAction);
        mng.add((IAction)this.copyAction);
        mng.add((IAction)this.pasteAction);
        mng.add((IContributionItem)new Separator());
        mng.add((IAction)this.revertAction);
    }

    public void contextMenuAboutToShow(IMenuManager mng) {
        this.contextMenuAboutToShow(mng, true);
    }

    public void contextMenuAboutToShow(IMenuManager mng, boolean addClipboard) {
        if (this.editor != null) {
            this.updateSelectableActions(this.editor.getSelection());
        }
        if (addClipboard) {
            this.addClipboardActions(mng);
        }
        mng.add((IAction)this.saveAction);
    }

    public void contributeToMenu(IMenuManager mm) {
        this.subMenuManager = new SubMenuManager(mm);
        this.sourceContributor.contributeToMenu((IMenuManager)this.subMenuManager);
    }

    public void contributeToStatusLine(IStatusLineManager slm) {
        this.subStatusManager = new SubStatusLineManager(slm);
        this.sourceContributor.contributeToStatusLine((IStatusLineManager)this.subStatusManager);
    }

    public void contributeToToolBar(IToolBarManager tbm) {
        this.subToolbarManager = new SubToolBarManager(tbm);
        this.sourceContributor.contributeToToolBar((IToolBarManager)this.subToolbarManager);
    }

    public PDEMultiPageEditor getEditor() {
        return this.editor;
    }

    public IAction getGlobalAction(String id) {
        return (IAction)this.globalActions.get(id);
    }

    public IAction getSaveAction() {
        return this.saveAction;
    }

    public IStatusLineManager getStatusLineManager() {
        return this.getActionBars().getStatusLineManager();
    }

    protected void makeActions() {
        this.cutAction = new CutAction();
        this.copyAction = new CopyAction();
        this.pasteAction = new PasteAction();
        this.addGlobalAction("cut", this.cutAction);
        this.addGlobalAction("copy", this.copyAction);
        this.addGlobalAction("paste", this.pasteAction);
        this.addGlobalAction("delete");
        this.addGlobalAction("undo");
        this.addGlobalAction("redo");
        this.addGlobalAction("selectAll");
        this.addGlobalAction("find");
        this.addGlobalAction("bookmark");
        this.saveAction = new SaveAction();
        this.saveAction.setText(PDEPlugin.getResourceString(ACTIONS_SAVE));
        this.revertAction = new RevertAction();
        this.revertAction.setText(PDEPlugin.getResourceString(ACTIONS_REVERT));
    }

    public void setActiveEditor(IEditorPart targetEditor) {
        if (this.editor != null) {
            this.editor.updateUndo(null, null);
        }
        if (targetEditor instanceof PDESourcePage) {
            PDESourcePage page = (PDESourcePage)targetEditor;
            PDEPlugin.getActivePage().activate((IWorkbenchPart)page.getEditor());
            return;
        }
        this.editor = (PDEMultiPageEditor)targetEditor;
        this.editor.updateUndo(this.getGlobalAction("undo"), this.getGlobalAction("redo"));
        IPDEEditorPage page = this.editor.getCurrentPage();
        this.setActivePage(page);
        this.updateSelectableActions(this.editor.getSelection());
    }

    public void setActivePage(IPDEEditorPage newPage) {
        IPDEEditorPage oldPage = this.page;
        this.page = newPage;
        if (newPage == null) {
            return;
        }
        this.updateActions();
        if (oldPage != null && !oldPage.isSource() && !newPage.isSource()) {
            return;
        }
        IActionBars bars = this.getActionBars();
        PDESourcePage sourcePage = null;
        if (newPage instanceof PDESourcePage) {
            sourcePage = (PDESourcePage)newPage;
        }
        this.subMenuManager.setVisible(sourcePage != null);
        this.subStatusManager.setVisible(sourcePage != null);
        this.subToolbarManager.setVisible(sourcePage != null);
        this.sourceContributor.setActiveEditor((IEditorPart)sourcePage);
        bars.setGlobalActionHandler("delete", this.page.getAction("delete"));
        bars.setGlobalActionHandler("undo", this.page.getAction("undo"));
        bars.setGlobalActionHandler("redo", this.page.getAction("redo"));
        bars.setGlobalActionHandler("cut", this.page.getAction("cut"));
        bars.setGlobalActionHandler("copy", this.page.getAction("copy"));
        bars.setGlobalActionHandler("paste", this.page.getAction("paste"));
        bars.setGlobalActionHandler("selectAll", this.page.getAction("selectAll"));
        bars.setGlobalActionHandler("find", this.page.getAction("find"));
        bars.setGlobalActionHandler("bookmark", this.page.getAction("bookmark"));
        bars.updateActionBars();
    }

    public void updateActions() {
        this.saveAction.update();
        this.revertAction.update();
    }

    public void updateSelectableActions(ISelection selection) {
        if (this.editor != null) {
            this.cutAction.selectionChanged(selection);
            this.copyAction.selectionChanged(selection);
            this.pasteAction.selectionChanged(selection);
        }
    }

    class GlobalAction
    extends Action
    implements IUpdate {
        private String id;

        public GlobalAction(String id) {
            this.id = id;
        }

        public void run() {
            PDEEditorContributor.this.editor.performGlobalAction(this.id);
            PDEEditorContributor.this.updateSelectableActions(PDEEditorContributor.this.editor.getSelection());
        }

        public void update() {
            PDEEditorContributor.this.getActionBars().updateActionBars();
        }
    }

    class ClipboardAction
    extends GlobalAction {
        public ClipboardAction(String id) {
            super(id);
            this.setEnabled(false);
        }

        public void selectionChanged(ISelection selection) {
        }

        public boolean isEditable() {
            if (PDEEditorContributor.this.editor == null) {
                return false;
            }
            Object model = PDEEditorContributor.this.editor.getModel();
            if (model instanceof IEditable) {
                return ((IEditable)model).isEditable();
            }
            return false;
        }
    }

    class CutAction
    extends ClipboardAction {
        public CutAction() {
            super("cut");
            this.setText(PDEPlugin.getResourceString(PDEEditorContributor.ACTIONS_CUT));
        }

        public void selectionChanged(ISelection selection) {
            this.setEnabled(this.isEditable() && PDEEditorContributor.this.editor.canCopy(selection));
        }
    }

    class CopyAction
    extends ClipboardAction {
        public CopyAction() {
            super("copy");
            this.setText(PDEPlugin.getResourceString(PDEEditorContributor.ACTIONS_COPY));
        }

        public void selectionChanged(ISelection selection) {
            this.setEnabled(PDEEditorContributor.this.editor.canCopy(selection));
        }
    }

    class PasteAction
    extends ClipboardAction {
        public PasteAction() {
            super("paste");
            this.setText(PDEPlugin.getResourceString(PDEEditorContributor.ACTIONS_PASTE));
        }

        public void selectionChanged(ISelection selection) {
            this.setEnabled(this.isEditable() && PDEEditorContributor.this.editor.canPasteFromClipboard());
        }
    }

    class SaveAction
    extends Action
    implements IUpdate {
        public void run() {
            if (PDEEditorContributor.this.editor != null) {
                PDEPlugin.getActivePage().saveEditor((IEditorPart)PDEEditorContributor.this.editor, false);
            }
        }

        public void update() {
            if (PDEEditorContributor.this.editor != null) {
                this.setEnabled(PDEEditorContributor.this.editor.isDirty());
            } else {
                this.setEnabled(false);
            }
        }
    }

    class RevertAction
    extends Action
    implements IUpdate {
        public void run() {
            if (PDEEditorContributor.this.editor != null) {
                PDEEditorContributor.this.editor.doRevert();
            }
        }

        public void update() {
            if (PDEEditorContributor.this.editor != null) {
                this.setEnabled(PDEEditorContributor.this.editor.isDirty());
            } else {
                this.setEnabled(false);
            }
        }
    }
}

