/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.xdom.io;

import com.sap.aii.util.log.api.Logger;
import com.sap.aii.util.xml.api.XMLServices;
import com.sap.aii.util.xml.xdom.XDOMException;
import com.sap.aii.util.xml.xdom.XDOMFactory;
import com.sap.aii.util.xml.xdom.XDocument;
import com.sap.aii.util.xml.xdom.io.XDOMSAXHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XDOMInputter {
    private static final Logger log = Logger.getLogger((String)(class$com$sap$aii$util$xml$xdom$io$XDOMInputter == null ? (class$com$sap$aii$util$xml$xdom$io$XDOMInputter = XDOMInputter.class$("com.sap.aii.util.xml.xdom.io.XDOMInputter")) : class$com$sap$aii$util$xml$xdom$io$XDOMInputter).getName());
    private XDOMFactory factory = null;
    private SAXParser parser = null;
    static /* synthetic */ Class class$com$sap$aii$util$xml$xdom$io$XDOMInputter;

    public XDOMInputter() {
        this.factory = new XDOMFactory();
    }

    public XDOMInputter(XDOMFactory f) {
        this.factory = f;
    }

    public XDocument read(InputSource in) throws XDOMException {
        return this.parse(in);
    }

    public XDocument read(URL url) throws XDOMException {
        XDocument doc;
        try {
            InputSource is = new InputSource(url.openStream());
            doc = this.parse(is);
        }
        catch (IOException ex) {
            log.error("IOException in XDOMInputter", (Throwable)ex);
            throw new XDOMException(ex);
        }
        return doc;
    }

    public XDocument read(String string) throws XDOMException {
        return this.parse(new InputSource(new StringReader(string)));
    }

    public XDocument read(Reader in) throws XDOMException {
        return this.parse(new InputSource(in));
    }

    public XDocument read(InputStream in) throws XDOMException {
        return this.parse(new InputSource(in));
    }

    public XDocument read(File file) throws XDOMException {
        FileInputStream in;
        try {
            in = new FileInputStream(file);
        }
        catch (FileNotFoundException ex) {
            throw new XDOMException(ex);
        }
        return this.parse(new InputSource(in));
    }

    public void setFactory(XDOMFactory f) throws XDOMException {
        this.factory = f;
    }

    private XDocument parse(InputSource src) throws XDOMException {
        try {
            if (this.factory == null) {
                throw new XDOMException(XDOMException.createMsg_NULL_FACTORY());
            }
            if (this.parser == null) {
                SAXParserFactory saxf = null;
                saxf = XMLServices.getParserFactory();
                try {
                    this.parser = saxf.newSAXParser();
                }
                catch (ParserConfigurationException ex) {
                    throw new XDOMException(XDOMException.createMsg_PARSER_CONF(), ex);
                }
            }
            XDOMSAXHandler handler = new XDOMSAXHandler(this.factory);
            this.parser.parse(src, (DefaultHandler)handler);
            return handler.getDocument();
        }
        catch (IOException ioe) {
            throw new XDOMException(ioe);
        }
        catch (SAXException se) {
            throw new XDOMException(se);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

