/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.xdom.impl;

import com.sap.aii.util.xml.xdom.StructureCorruptingException;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.XName;
import com.sap.aii.util.xml.xdom.XNamespace;
import com.sap.aii.util.xml.xdom.impl.XElementImpl;
import com.sap.aii.util.xml.xdom.impl.XNameImpl;

public class XAttributeImpl
implements XAttribute {
    private static final long serialVersionUID = 42L;
    private XName name;
    private String value;
    private XElement parent;

    private XAttributeImpl(String name, String value) {
        this.name = new XNameImpl(name);
        this.value = value != null ? value : "";
    }

    public XAttributeImpl(XName name, String value) {
        this.name = name;
        this.value = value != null ? value : "";
    }

    public void setParent(XElement newParent) {
        if (null != this.parent && null != newParent) {
            throw new StructureCorruptingException(StructureCorruptingException.createMsg_PARENT());
        }
        this.parent = newParent;
    }

    public XName getName() {
        this.normalizeNamespace();
        return this.name;
    }

    public String getValue() {
        return this.value;
    }

    public XElement getParent() {
        return this.parent;
    }

    public String getLocalName() {
        return this.name.getLocalName();
    }

    public String getQualifiedName() {
        this.normalizeNamespace();
        return this.name.getQualifiedName();
    }

    public void setValue(String newValue) {
        this.value = newValue;
    }

    public boolean equals(Object o) {
        if (!(o instanceof XAttribute)) {
            return false;
        }
        XAttribute a = (XAttribute)o;
        return this.name.equals(a.getName()) && this.value.equals(a.getValue());
    }

    public int hashCode() {
        return this.name.hashCode() ^ this.value.hashCode();
    }

    void normalizeNamespace() {
        if (this.parent != null && this.parent instanceof XElementImpl) {
            XElementImpl xei = (XElementImpl)this.parent;
            XNamespace ns = this.name.getNamespace();
            XNamespace res = xei.normalizeNamespace(ns, true);
            ((XNameImpl)this.name).setNamespace(res);
        }
    }

    public String toString() {
        return this.name.toString() + " value=\"" + this.value + "\"";
    }

    public Object clone() {
        XAttributeImpl clone = new XAttributeImpl((XName)this.name.clone(), this.value);
        return clone;
    }
}

