/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.jdom;

import com.sap.aii.util.xml.jdom.Attribute;
import com.sap.aii.util.xml.jdom.Namespace;
import com.sap.aii.util.xml.xdom.InvalidArgumentException;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XDOMFactory;
import com.sap.aii.util.xml.xdom.XData;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.XName;
import com.sap.aii.util.xml.xdom.XNamespace;
import com.sap.aii.util.xml.xdom.XText;
import java.io.Serializable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;

public class Element
implements Serializable,
Cloneable {
    private static final long serialVersionUID = 42L;
    private static XDOMFactory f = new XDOMFactory();
    private XElement elem;

    private Element(XElement elem) {
        this.elem = elem;
    }

    public Element(String name) {
        try {
            this.elem = f.newXElement(name);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public Element(String name, String uri) {
        try {
            this.elem = f.newXElement(name, uri);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public Element(String name, String prefix, String uri) {
        try {
            this.elem = f.newXElement(name, f.newXNamespace(prefix, uri));
        }
        catch (InvalidArgumentException ex) {
            // empty catch block
        }
    }

    public Element(String name, Namespace namespace) {
        try {
            this.elem = f.newXElement(name, namespace.unwrap());
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
    }

    public static Element wrap(XElement elem) {
        return elem == null ? null : new Element(elem);
    }

    public XElement unwrap() {
        return this.elem;
    }

    public Element setName(String name) {
        try {
            this.elem.setName(f.newXName(name, this.elem.getNamespace()));
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
        return this;
    }

    public String getName() {
        return this.elem.getName().getLocalName();
    }

    public Namespace getNamespace() {
        return Namespace.wrap(this.elem.getNamespace());
    }

    public Namespace getNamespace(String prefix) {
        XNamespace ns = null;
        ns = this.elem.getNamespace(prefix);
        return Namespace.wrap(ns);
    }

    public String getNamespacePrefix() {
        return this.elem.getNamespace().getPrefix();
    }

    public String getNamespaceURI() {
        return this.elem.getNamespace().getURI();
    }

    public Element getParent() {
        return Element.wrap(this.elem.getParent());
    }

    public String getQualifiedName() {
        return this.elem.getQualifiedName();
    }

    public Element addContent(String text) {
        this.elem.add(text);
        return this;
    }

    public Element addContent(Element e) {
        this.elem.add(e.unwrap());
        return this;
    }

    public boolean removeContent(Element e) {
        return null != this.elem.remove(e.unwrap());
    }

    public void addNamespaceDeclaration(Namespace namespace) {
        this.elem.add(namespace.unwrap());
    }

    public Element addAttribute(String name, String value) {
        try {
            this.elem.setAttribute(name, value);
        }
        catch (InvalidArgumentException invalidArgumentException) {
            // empty catch block
        }
        return this;
    }

    public Element addAttribute(Attribute attr) {
        this.elem.add(attr.unwrap());
        return this;
    }

    public Attribute getAttribute(String name) {
        return Attribute.wrap(this.elem.getAttribute(name));
    }

    public Attribute getAttribute(String name, Namespace ns) {
        XName xname = null;
        try {
            xname = f.newXName(name, ns.unwrap());
        }
        catch (InvalidArgumentException ex) {
            // empty catch block
        }
        return Attribute.wrap(this.elem.getAttribute(xname));
    }

    public List getAttributes() {
        return Element.wrapList(this.elem.getAttributes());
    }

    public String getAttributeValue(String name) {
        return this.elem.getAttributeValue(name);
    }

    public String getAttributeValue(String name, Namespace ns) {
        String value = null;
        try {
            value = this.elem.getAttributeValue(f.newXName(name, ns.unwrap()));
        }
        catch (InvalidArgumentException ex) {
            // empty catch block
        }
        return value;
    }

    public boolean removeAttribute(String name) {
        this.elem.removeAttribute(name);
        return true;
    }

    public Element getChild(String name) {
        return this.getChild(name, Namespace.NO_NAMESPACE);
    }

    public Element getChild(String name, Namespace ns) {
        XElement el = null;
        try {
            XName n = f.newXName(name, ns.unwrap());
            Iterator it = this.elem.getMixedContent().iterator();
            while (it.hasNext()) {
                XElement e;
                Object o = it.next();
                if (!(o instanceof XElement) || !n.equals((e = (XElement)o).getName())) continue;
                el = e;
                break;
            }
        }
        catch (InvalidArgumentException ex) {
            // empty catch block
        }
        return Element.wrap(el);
    }

    public String getChildText(String name) {
        Element e = this.getChild(name);
        return e == null ? null : e.getText();
    }

    public String getChildText(String name, Namespace ns) {
        Element e = this.getChild(name, ns);
        return e == null ? null : e.getText();
    }

    public String getChildTextTrim(String name) {
        String s = this.getChildText(name);
        return s == null ? null : s.trim();
    }

    public String getChildTextTrim(String name, Namespace ns) {
        String s = this.getChildText(name, ns);
        return s == null ? null : s.trim();
    }

    public List getChildren() {
        return Element.wrapList(this.elem.getSubElements());
    }

    public List getChildren(String name) {
        return this.getChildren(name, Namespace.NO_NAMESPACE);
    }

    public List getChildren(String name, Namespace ns) {
        Vector<XElement> v = new Vector<XElement>();
        try {
            XDOMFactory f = new XDOMFactory();
            XName n = f.newXName(name, ns.unwrap());
            Iterator it = this.elem.getMixedContent().iterator();
            while (it.hasNext()) {
                XElement e;
                Object o = it.next();
                if (!(o instanceof XElement) || !n.equals((e = (XElement)o).getName())) continue;
                v.add(e);
            }
        }
        catch (InvalidArgumentException ex) {
            // empty catch block
        }
        return Element.wrapList(v);
    }

    public List getMixedContent() {
        return Element.wrapList(this.elem.getMixedContent());
    }

    public boolean removeChild(String name) {
        Element child = this.getChild(name);
        if (child != null) {
            return null != this.elem.remove(child.unwrap());
        }
        return false;
    }

    public boolean removeChildren() {
        this.elem.removeAll();
        return true;
    }

    public boolean isRootElement() {
        return null == this.elem.getParent();
    }

    public boolean hasMixedContent() {
        boolean elems = false;
        boolean data = false;
        Iterator i = this.elem.getMixedContent().iterator();
        while (i.hasNext()) {
            Object o = i.next();
            if (!elems && o instanceof XElement) {
                elems = true;
            }
            if (!data && o instanceof XData) {
                data = true;
            }
            if (data && elems) break;
        }
        return data && elems;
    }

    public boolean hasChildren() {
        return this.elem.getMixedContent().size() != 0;
    }

    public String getText() {
        return this.elem.getText();
    }

    public String getTextTrim() {
        return this.elem.getText().trim();
    }

    public Element setText(String text) {
        this.elem.removeAll();
        this.elem.add(text);
        return this;
    }

    public Object clone() {
        return Element.wrap((XElement)this.elem.clone());
    }

    public final boolean equals(Object obj) {
        return obj instanceof Element && this.elem.equals(((Element)obj).elem);
    }

    public final int hashCode() {
        return this.elem.hashCode();
    }

    public List getAdditionalNamespaces() {
        return Element.wrapList(this.elem.getAdditionalNamespaces());
    }

    public List getAllNamespaces() {
        return Element.wrapList(this.elem.getAllNamespaces());
    }

    private static List wrapList(List list) {
        return Element.wrapList(list.toArray());
    }

    private static List wrapList(Object[] list) {
        LinkedList<Object> nl = new LinkedList<Object>();
        int i = 0;
        while (i < list.length) {
            Object obj = list[i];
            if (obj instanceof XElement) {
                obj = Element.wrap((XElement)obj);
            } else if (obj instanceof XAttribute) {
                obj = Attribute.wrap((XAttribute)obj);
            } else if (obj instanceof XNamespace) {
                obj = Namespace.wrap((XNamespace)obj);
            } else if (obj instanceof XText) {
                obj = ((XText)obj).getText();
            }
            nl.add(obj);
            ++i;
        }
        return nl;
    }

    private static List unwrapList(List list) {
        LinkedList nl = new LinkedList();
        Iterator i = list.iterator();
        while (i.hasNext()) {
            Object obj = i.next();
            if (obj instanceof Element) {
                obj = ((Element)obj).unwrap();
            } else if (obj instanceof Attribute) {
                obj = ((Attribute)obj).unwrap();
            } else if (obj instanceof Namespace) {
                obj = ((Namespace)obj).unwrap();
            }
            nl.add(obj);
        }
        return nl;
    }
}

