/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.api;

import com.sap.aii.util.xml.api.SAXElement;
import com.sap.aii.util.xml.api.SAXHandler;
import com.sap.aii.util.xml.api.XiSAXException;
import com.sap.aii.util.xml.xdom.XAttribute;
import com.sap.aii.util.xml.xdom.XDOMFactory;
import com.sap.aii.util.xml.xdom.XElement;
import com.sap.aii.util.xml.xdom.XName;
import com.sap.aii.util.xml.xdom.XNamespace;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import org.xml.sax.Attributes;

class XdomControler
extends SAXHandler {
    private static final XDOMFactory factory = new XDOMFactory();
    private Map elements = new WeakHashMap();

    XdomControler() {
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws XiSAXException {
        XElement father;
        super.startElement(uri, localName, qName, attributes);
        SAXElement element = this.getElement();
        if (this.elements.get(element) == null && (father = this.getFather(element)) != null) {
            this.constructXElement(element, father);
        }
    }

    public void endElement(String uri, String localName, String qName) throws XiSAXException {
        SAXElement element = this.getElement();
        XElement x = (XElement)this.elements.get(element);
        if (x != null) {
            x.add(element.getText());
        }
        super.endElement(uri, localName, qName);
    }

    XElement getXElement() {
        return this.getXElement(this.getElement());
    }

    private XElement getXElement(SAXElement element) {
        XElement ret = (XElement)this.elements.get(element);
        if (ret == null) {
            ret = this.constructXElement(element, this.getFather(element));
        }
        return ret;
    }

    private XElement constructXElement(SAXElement element, XElement father) {
        Iterator nsm = element.getPrefixMapping(false).entrySet().iterator();
        HashSet<XNamespace> namespaces = new HashSet<XNamespace>();
        XNamespace nsp = null;
        String elementNsp = element.getNamespace();
        while (nsm.hasNext()) {
            Map.Entry entry = nsm.next();
            String prefix = (String)entry.getKey();
            String url = (String)entry.getValue();
            XNamespace next = factory.newXNamespace(prefix, url);
            if (elementNsp == url) {
                nsp = next;
                continue;
            }
            namespaces.add(next);
        }
        XElement ret = nsp == null ? factory.newXElement(element.getName(), elementNsp) : factory.newXElement(element.getName(), nsp);
        Iterator nsps = namespaces.iterator();
        while (nsps.hasNext()) {
            ret.add((XNamespace)nsps.next());
        }
        Attributes attributes = element.getAttributes();
        int num = attributes.getLength();
        int i = 0;
        while (i < num) {
            XName name = factory.newXName(attributes.getLocalName(i), attributes.getURI(i));
            XAttribute att = factory.newXAttribute(name, attributes.getValue(i));
            ret.add(att);
            ++i;
        }
        if (father != null) {
            father.add(ret);
        }
        this.elements.put(element, ret);
        return ret;
    }

    private XElement getFather(SAXElement element) {
        return (XElement)this.elements.get(element.getParent());
    }
}

