/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.api;

import com.sap.aii.util.misc.api.BabelMessage;
import com.sap.aii.util.misc.api.BaseException;
import com.sap.aii.util.xml.api.SAXElement;
import com.sap.aii.util.xml.api.XdomConsumer;
import com.sap.aii.util.xml.api.XdomHandler;
import com.sap.aii.util.xml.api.XiSAXException;
import com.sap.aii.util.xml.xdom.XElement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import org.xml.sax.Attributes;

class XdomControlHandler
extends XdomHandler {
    Set consumers = new HashSet();
    private boolean inUse = false;
    private Map consumers4Elements;

    XdomControlHandler() {
    }

    public void startDocument() throws XiSAXException {
        if (this.inUse) {
            throw new XiSAXException((Exception)new BaseException(new BabelMessage("com.sap.aii.util.xml.api.rb_exception.HANDLER_CONC")));
        }
        this.inUse = true;
        this.consumers4Elements = new WeakHashMap();
        super.startDocument();
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws XiSAXException {
        SAXElement element = this.getElement();
        Iterator it = this.consumers.iterator();
        boolean required = false;
        HashSet<XdomConsumer> targets = null;
        while (it.hasNext()) {
            XdomConsumer consumer = (XdomConsumer)it.next();
            if (!consumer.decide(element)) continue;
            if (!required) {
                required = true;
                targets = new HashSet<XdomConsumer>();
            }
            targets.add(consumer);
        }
        if (required) {
            this.getXElement();
            this.consumers4Elements.put(element, targets);
        }
        super.startElement(uri, localName, qName, attributes);
    }

    public void endElement(String uri, String localName, String qName) throws XiSAXException {
        SAXElement saxElement = this.getElement();
        Set targets = (Set)this.consumers4Elements.get(saxElement);
        if (targets != null) {
            XElement element = this.getXElement();
            Iterator it = targets.iterator();
            while (it.hasNext()) {
                XdomConsumer consumer = (XdomConsumer)it.next();
                consumer.consume(element, saxElement);
            }
        }
        super.endElement(uri, localName, qName);
    }

    public void endDocument() throws XiSAXException {
        this.inUse = false;
        super.endDocument();
    }

    void addConsumer(XdomConsumer consumer) {
        this.consumers.add(consumer);
    }

    void removeConsumer(XdomConsumer consumer) {
        this.consumers.remove(consumer);
    }
}

