/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.api;

import com.sap.aii.util.misc.api.Util;
import com.sap.aii.util.xml.api.TransformationConstants;
import com.sap.aii.util.xml.xdom.XDOMFactory;
import com.sap.aii.util.xml.xdom.XElement;
import java.net.URLEncoder;

public class TransformationServices {
    private static final XDOMFactory f = new XDOMFactory();
    public static final String FACET_MAXLENGTH = "maxLength";
    public static final String FACET_TOTALDIGITS = "totalDigits";
    public static final String FACET_PATTERN = "pattern";
    public static final String FACET_FRACTIONDIGITS = "fractionDigits";
    public static final String FACET_LENGTH = "length";
    public static final int INPUT_AND_OUTPUT = 0;
    public static final int INPUT = 1;
    public static final int OUTPUT = 2;
    public static final int INPUT_OUTPUT_FAULT = 3;
    public static final int INPUT_FAULT = 4;
    public static final int OUTPUT_FAULT = 5;

    public static XElement getWSDLDefinitions(String targetNamespace) {
        XElement def = f.newXElement("definitions", TransformationConstants.wsdlns);
        if (targetNamespace != null) {
            def.add(f.newXAttribute("targetNamespace", targetNamespace));
        }
        return def;
    }

    public static XElement getWSDLTypes() {
        XElement types = f.newXElement("types", TransformationConstants.wsdlns);
        return types;
    }

    public static XElement getWSDLMessageElement(String messageName) {
        XElement message = f.newXElement("message", TransformationConstants.wsdlns);
        if (messageName != null) {
            message.add(f.newXAttribute("name", messageName));
        }
        return message;
    }

    public static XElement getWSDLMessagePart(String nameValue, String elementValue) {
        XElement part = f.newXElement("part", TransformationConstants.wsdlns);
        if (nameValue != null) {
            part.add(f.newXAttribute("name", nameValue));
        }
        if (elementValue != null) {
            part.add(f.newXAttribute("element", elementValue));
        }
        return part;
    }

    public static XElement getWSDLPortType(String portTypeName) {
        XElement portType = f.newXElement("portType", TransformationConstants.wsdlns);
        if (portTypeName != null) {
            portType.add(f.newXAttribute("name", portTypeName));
        }
        return portType;
    }

    public static XElement getWSDLPorttypeOperation(String name) {
        XElement operation = f.newXElement("operation", TransformationConstants.wsdlns);
        if (name != null) {
            operation.add(f.newXAttribute("name", name));
        }
        return operation;
    }

    public static XElement getWSDLInputMessage(String messageName) {
        XElement input = f.newXElement("input", TransformationConstants.wsdlns);
        if (messageName != null) {
            input.add(f.newXAttribute("message", messageName));
        }
        return input;
    }

    public static XElement getWSDLOutputMessage(String messageName) {
        XElement output = f.newXElement("output", TransformationConstants.wsdlns);
        if (messageName != null) {
            output.add(f.newXAttribute("message", messageName));
        }
        return output;
    }

    public static XElement getWSDLFaultMessage(String messageName, String name) {
        XElement fault = f.newXElement("fault", TransformationConstants.wsdlns);
        if (messageName != null) {
            fault.add(f.newXAttribute("message", messageName));
        }
        if (name != null) {
            fault.add(f.newXAttribute("name", name));
        }
        return fault;
    }

    public static XElement getWSDLBinding(String nameValue, String typeValue) {
        XElement binding = f.newXElement("binding", TransformationConstants.wsdlns);
        if (nameValue != null) {
            binding.add(f.newXAttribute("name", nameValue));
        }
        if (typeValue != null) {
            binding.add(f.newXAttribute("type", typeValue));
        }
        return binding;
    }

    public static XElement getWSDLService(String serviceName) {
        XElement service = f.newXElement("service", TransformationConstants.wsdlns);
        if (serviceName != null) {
            service.add(f.newXAttribute("name", serviceName));
        }
        return service;
    }

    public static XElement getWSDLServicePort(String portName, String binding) {
        XElement port = f.newXElement("port", TransformationConstants.wsdlns);
        if (portName != null) {
            port.add(f.newXAttribute("name", portName));
        }
        if (binding != null) {
            port.add(f.newXAttribute("binding", binding));
        }
        return port;
    }

    public static XElement getSchema(String targetNamespace) {
        XElement schema = f.newXElement("schema", TransformationConstants.xsdns);
        if (targetNamespace != null) {
            schema.add(f.newXAttribute("targetNamespace", targetNamespace));
        }
        return schema;
    }

    public static XElement getAttributeXElement(String name) {
        XElement attrib = f.newXElement("attribute", TransformationConstants.xsdns);
        if (name != null) {
            attrib.add(f.newXAttribute("name", name));
        }
        return attrib;
    }

    public static XElement getImportElement(String namespace) {
        XElement imp = f.newXElement("import", TransformationConstants.xsdns);
        if (namespace != null) {
            imp.add(f.newXAttribute("namespace", namespace));
        }
        return imp;
    }

    public static XElement getComplexType(String name) {
        XElement complexType = f.newXElement("complexType", TransformationConstants.xsdns);
        if (name != null) {
            complexType.add(f.newXAttribute("name", name));
        }
        return complexType;
    }

    public static XElement getSimpleType(String name) {
        XElement simpleType = f.newXElement("simpleType", TransformationConstants.xsdns);
        if (name != null) {
            simpleType.add(f.newXAttribute("name", name));
        }
        return simpleType;
    }

    public static XElement getElement(String name) {
        XElement element = f.newXElement("element", TransformationConstants.xsdns);
        if (name != null) {
            element.add(f.newXAttribute("name", name));
        }
        return element;
    }

    public static XElement getElement(String name, String minOccurs, String maxOccurs) {
        XElement element = TransformationServices.getElement(name);
        if (minOccurs != null) {
            element.add(f.newXAttribute("minOccurs", minOccurs));
        }
        if (maxOccurs != null) {
            element.add(f.newXAttribute("maxOccurs", maxOccurs));
        }
        return element;
    }

    public static XElement getSequence() {
        XElement sequence = f.newXElement("sequence", TransformationConstants.xsdns);
        return sequence;
    }

    public static XElement getRestriction(String baseType) {
        XElement restriction = f.newXElement("restriction", TransformationConstants.xsdns);
        if (baseType != null) {
            restriction.add(f.newXAttribute("base", baseType));
        }
        return restriction;
    }

    public static XElement getFacetXElement(String name, String value) {
        if (name == null) {
            return null;
        }
        XElement facet = f.newXElement(name, TransformationConstants.xsdns);
        if (value != null) {
            facet.add(f.newXAttribute("value", value));
        }
        return facet;
    }

    public static XElement getEnumeration() {
        XElement xElement = f.newXElement("enumeration", TransformationConstants.xsdns);
        return xElement;
    }

    public static XElement getUnion() {
        XElement union = f.newXElement("union", TransformationConstants.xsdns);
        return union;
    }

    public static XElement getPattern() {
        XElement pat = f.newXElement(FACET_PATTERN, TransformationConstants.xsdns);
        return pat;
    }

    public static String getValueFromXlinkHref(String key, String hrefValue) {
        int pos = hrefValue.indexOf(key + "=");
        if (pos > -1) {
            int end = hrefValue.indexOf("&", pos);
            int start = pos + key.length() + 1;
            if (end > -1) {
                return hrefValue.substring(start, end);
            }
            return hrefValue.substring(start);
        }
        return "";
    }

    public static String getMetaDocumentation(XElement root, String language) {
        XElement[] descriptionList;
        XElement descriptor = root.getSubElement("descriptor", "urn:sap-com:ifr:v2:metamodel");
        String docu = "";
        if (descriptor != null && (descriptionList = descriptor.getSubElements("description", "urn:sap-com:ifr:v2:metamodel")) != null && descriptionList.length > 0) {
            if (language != null) {
                int i = 0;
                while (i < descriptionList.length) {
                    if (language.equals(descriptionList[i].getAttributeValue("language"))) {
                        docu = descriptionList[i].getText();
                    }
                    if (docu != null) {
                        docu.trim();
                    }
                    ++i;
                }
            } else {
                docu = descriptionList[0].getText();
                if (docu != null) {
                    docu.trim();
                }
            }
        }
        return docu;
    }

    public static XElement getWSDLDocumentation(String docu) {
        XElement doc = f.newXElement("documentation", TransformationConstants.wsdlns);
        if (docu != null) {
            doc.add(docu);
        }
        return doc;
    }

    public static XElement getXSDAnnotationDocu(String documentation, String language) {
        XElement annotation = f.newXElement("annotation", TransformationConstants.xsdns);
        XElement docu = f.newXElement("documentation", TransformationConstants.xsdns);
        if (language != null) {
            docu.add(f.newXAttribute(f.newXName("lang", XDOMFactory.XML_NAMESPACE), language));
        }
        docu.add(documentation);
        annotation.add(docu);
        return annotation;
    }

    public static XElement getWSDLBindingPart(String interfaceName, String targetNamespacePrefix, String portType, String[] operationNames, int[] inputOutputFault, String[][] faultNames) {
        String pname = null;
        pname = targetNamespacePrefix != null ? targetNamespacePrefix + ":" + portType : portType;
        XElement binding = TransformationServices.getWSDLBinding(interfaceName + "Binding", pname);
        XElement soapBinding = f.newXElement("binding", TransformationConstants.soapns);
        soapBinding.add(f.newXAttribute("style", "document"));
        soapBinding.add(f.newXAttribute("transport", "http://schemas.xmlsoap.org/soap/http"));
        binding.add(soapBinding);
        XElement soapBody = f.newXElement("body", TransformationConstants.soapns);
        soapBody.add(f.newXAttribute("use", "literal"));
        XElement input = f.newXElement("input", "http://schemas.xmlsoap.org/wsdl/");
        input.add((XElement)soapBody.clone());
        XElement output = f.newXElement("output", "http://schemas.xmlsoap.org/wsdl/");
        output.add((XElement)soapBody.clone());
        XElement soapOperation = f.newXElement("operation", TransformationConstants.soapns);
        soapOperation.add(f.newXAttribute("soapAction", "http://sap.com/xi/WebService/soap1.1"));
        int i = 0;
        while (i < operationNames.length) {
            XElement operation = f.newXElement("operation", "http://schemas.xmlsoap.org/wsdl/");
            operation.add(f.newXAttribute("name", operationNames[i]));
            operation.add((XElement)soapOperation.clone());
            if (inputOutputFault[i] == 0 || inputOutputFault[i] == 1 || inputOutputFault[i] == 4 || inputOutputFault[i] == 3) {
                operation.add((XElement)input.clone());
            }
            if (inputOutputFault[i] == 0 || inputOutputFault[i] == 2 || inputOutputFault[i] == 5 || inputOutputFault[i] == 3) {
                operation.add((XElement)output.clone());
            }
            if (inputOutputFault[i] == 4 || inputOutputFault[i] == 5 || inputOutputFault[i] == 3) {
                int j = 0;
                while (j < faultNames[i].length) {
                    XElement fault = f.newXElement("fault", "http://schemas.xmlsoap.org/wsdl/");
                    fault.add(f.newXAttribute("name", faultNames[i][j]));
                    XElement soapBodyFault = f.newXElement("fault", TransformationConstants.soapns);
                    soapBodyFault.add(f.newXAttribute("use", "literal"));
                    soapBodyFault.add(f.newXAttribute("name", faultNames[i][j]));
                    fault.add(soapBodyFault);
                    operation.add(fault);
                    ++j;
                }
            }
            binding.add(operation);
            ++i;
        }
        return binding;
    }

    public static XElement getWSDLServicePart(String interfaceName, String operationName, String targetNamespacePrefix, String addressLocation) {
        XElement service = TransformationServices.getWSDLService(interfaceName + "Service");
        service.add(TransformationServices.getWSDLDocumentation("My " + interfaceName + " " + operationName + " service"));
        String iname = null;
        iname = targetNamespacePrefix != null ? targetNamespacePrefix + ":" + interfaceName : interfaceName;
        XElement port = TransformationServices.getWSDLServicePort(interfaceName + "Port", iname + "Binding");
        service.add(port);
        port.add(f.newXElement("address", TransformationConstants.soapns).add(f.newXAttribute("location", addressLocation)));
        return service;
    }

    public static String escapeName(String name) {
        if (name == null) {
            return null;
        }
        if (name.length() == 0) {
            return "";
        }
        StringBuffer b = new StringBuffer();
        byte[] by = name.getBytes();
        int i = 0;
        while (i < name.length()) {
            char c = name.charAt(i);
            if (i == 0 && (Character.isDigit(c) || c == '.')) {
                b.append("_--");
                b.append(Util.byteToHex((byte)by[i]));
            } else if (Character.isLetterOrDigit(c) || c == '_' || c == '.') {
                b.append(c);
            } else if (c == '/') {
                b.append("_-");
            } else {
                b.append("_--");
                b.append(Util.byteToHex((byte)by[i]));
            }
            ++i;
        }
        return b.toString();
    }

    public static XElement getServicePart(String bsname, String soapLocation, String fromNamespace, String fromName, String interfaceName, String operationName, String targetNamespacePrefix) {
        String queryPart = "";
        if (bsname != null) {
            queryPart = soapLocation.indexOf("?") >= 0 ? "&" : "?";
            queryPart = queryPart + "version=1.0&From.Interface=" + URLEncoder.encode(fromNamespace + "^" + fromName) + "&From.Name=" + URLEncoder.encode(bsname);
        }
        return TransformationServices.getWSDLServicePart(interfaceName, operationName, targetNamespacePrefix, soapLocation + queryPart);
    }
}

