/*
 * Decompiled with CFR 0.152.
 */
package com.sap.aii.util.xml.api;

import com.sap.aii.util.xml.api.ControlledSAXHandler;
import com.sap.aii.util.xml.api.CopyControler;
import com.sap.aii.util.xml.api.SAXElement;
import com.sap.aii.util.xml.api.XMLException;
import com.sap.aii.util.xml.api.XMLMemory;
import com.sap.aii.util.xml.api.XMLMemoryStream;
import com.sap.aii.util.xml.api.XMLStream;
import com.sap.aii.util.xml.api.XiSAXException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.xml.sax.Attributes;

public class SAXCopyHandler
extends ControlledSAXHandler {
    private XMLStream xml = null;
    private Set copied = new HashSet();

    public SAXCopyHandler() {
        this(new XMLMemoryStream());
    }

    public SAXCopyHandler(XMLStream xml) {
        super(new CopyControler());
        ((CopyControler)this.getControler()).setControled(this);
        this.xml = xml;
    }

    public XMLMemory getCopy() throws XMLException {
        return ((XMLMemoryStream)this.xml).toXML();
    }

    public XMLStream getCopyStream() {
        return this.xml;
    }

    public void startElement(String uri, String localName, String qName, Attributes attributes) throws XiSAXException {
        Map.Entry entry;
        String myDefNamespace;
        SAXElement element = this.getElement();
        String streamDefNamespace = this.xml.getDefaultNamespace();
        if (streamDefNamespace == null) {
            streamDefNamespace = "";
        }
        if ((myDefNamespace = element.getDefaultNamespace()) == null) {
            myDefNamespace = "";
        }
        Set namespaces = element.getPrefixMapping(false).entrySet();
        String prefix = null;
        if (uri.equals(myDefNamespace) && uri.equals(streamDefNamespace)) {
            try {
                this.xml.openTag(localName);
            }
            catch (XMLException e) {
                throw new XiSAXException((Exception)((Object)e));
            }
        }
        Iterator nit = namespaces.iterator();
        while (nit.hasNext() && prefix == null) {
            entry = nit.next();
            if (!uri.equals(entry.getValue())) continue;
            prefix = (String)entry.getKey();
        }
        try {
            if (prefix == null) {
                this.xml.openTag(uri, localName);
            } else if ("".equals(prefix)) {
                this.xml.openTag(localName);
                this.xml.setDefaultNamespace(uri);
            } else {
                this.xml.openTag(prefix, uri, localName);
            }
        }
        catch (XMLException e) {
            throw new XiSAXException((Exception)((Object)e));
        }
        nit = namespaces.iterator();
        while (nit.hasNext()) {
            entry = nit.next();
            String thisprefix = (String)entry.getKey();
            if (thisprefix.equals(prefix)) continue;
            try {
                this.xml.addNamespace(thisprefix, (String)entry.getValue());
            }
            catch (XMLException e) {
                throw new XiSAXException((Exception)((Object)e));
            }
        }
        int length = attributes.getLength();
        int i = 0;
        while (i < length) {
            String buri = attributes.getURI(i);
            try {
                if ("".equals(buri)) {
                    this.xml.addAttr(attributes.getLocalName(i), attributes.getValue(i));
                } else {
                    this.xml.addAttr(buri, attributes.getLocalName(i), attributes.getValue(i));
                }
            }
            catch (XMLException e) {
                throw new XiSAXException((Exception)((Object)e));
            }
            ++i;
        }
        this.copied.add(element);
    }

    void closeElement(SAXElement element) throws XiSAXException {
        if (this.copied.remove(element)) {
            try {
                this.xml.closeTag();
            }
            catch (XMLException e) {
                throw new XiSAXException((Exception)((Object)e));
            }
        }
    }

    public void characters(char[] ch, int start, int length) throws XiSAXException {
        try {
            this.xml.addText(new String(ch, start, length));
        }
        catch (XMLException e) {
            throw new XiSAXException((Exception)((Object)e));
        }
    }

    public void processingInstruction(String target, String data) throws XiSAXException {
        try {
            this.xml.addPI(target, data);
        }
        catch (XMLException e) {
            throw new XiSAXException((Exception)((Object)e));
        }
    }
}

