/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildtool;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.BuildActionSequence;
import com.sap.tc.buildplugin.api.BuildActionSeverity;
import com.sap.tc.buildplugin.api.BuildInfo;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IBuildPlugin;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.api.ILocalBuildProperties;
import com.sap.tc.buildtool.BuildResult;
import com.sap.tc.buildtool.BuildToolException;
import com.sap.tc.buildtool.IllegalPluginDescriptorException;
import com.sap.tc.buildtool.JarHandler;
import com.sap.tc.buildtool.LogFile;
import com.sap.tc.buildtool.PackageChecker;
import com.sap.tc.buildtool.PluginInstantiateException;
import com.sap.tc.buildtool.PluginLoadException;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.logging.Location;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Properties;

public class PluginHandler {
    private File pluginRoot;
    private BuildResult buildResult;
    private BuildInfo buildInfo;
    private JarHandler jarHandler;
    private static final int CONTINUE_BUILD = 0;
    private static final int STOP_BUILD = 1;
    private static final String DC_SETTINGS = "tc" + File.separator + "bi" + File.separator + "settings";
    private static final String JDK_FILE = ".versions";
    private static final String JDK_SUFFIX = "_HOME";
    private static final String JDK_KEY = "jdk";
    private static final String JDK_PREFIX = "JDK";
    private static final String ANT_JDK_VERSION = "ant_jdk_version";
    private static final String ANT_FORK_COMPILE = "ant_fork_compile";
    private static final String DEFAULT_JDK = "DEFAULT";
    private static Location loc = Location.getLocation((String)"com.sap.tc.buildtool.PluginHandler");
    private Properties descriptorProperties;
    private static final String DESCRIPTOR_NAME = ".buildplugin";
    private static final String PLUGIN_CLASSNAME = "plugin.classname";
    private String errMsg = "";
    private String buildLogFile = "";
    StringBuffer myMessageBuffer = new StringBuffer(500);
    String lineSep = System.getProperty("line.separator");
    LogFile myLogFile = new LogFile();
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$lang$Object;

    protected PluginHandler(File _pluginRoot) throws BuildToolException {
        this.pluginRoot = _pluginRoot;
        this.buildInfo = new BuildInfo();
        this.buildResult = new BuildResult(0);
        this.buildInfo.setAbsolutePluginRoot(this.pluginRoot);
    }

    public PluginHandler(IDevelopmentComponentInfo developmentComponentInfo, File pluginRoot) throws BuildToolException {
        this(pluginRoot);
        this.buildInfo.setDevelopmentComponentInfo(developmentComponentInfo);
    }

    public PluginHandler(IDevelopmentComponentInfo developmentComponentInfo, File pluginRoot, String target) throws BuildToolException {
        this(developmentComponentInfo, pluginRoot);
        this.buildInfo.setTarget(target);
    }

    public PluginHandler(IDevelopmentComponentInfo developmentComponentInfo, File pluginRoot, String target, boolean isLocalBuild, boolean isRebuild) throws BuildToolException {
        this(developmentComponentInfo, pluginRoot);
        this.buildInfo.setTarget(target);
        this.buildInfo.setIsRebuild(isRebuild);
        this.buildInfo.setIsLocalBuild(isLocalBuild);
    }

    public PluginHandler(IDevelopmentComponentInfo developmentComponentInfo, JarHandler jarHandler, File pluginRoot, String target, boolean isLocalBuild, boolean isRebuild) throws BuildToolException {
        this(developmentComponentInfo, pluginRoot);
        this.buildInfo.setTarget(target);
        this.buildInfo.setIsRebuild(isRebuild);
        this.buildInfo.setIsLocalBuild(isLocalBuild);
        this.jarHandler = jarHandler;
    }

    public BuildResult testExecute() {
        return this.execute();
    }

    public BuildResult execute() {
        this.jarHandler.prepareExecution();
        switch (this.jarHandler.checkFileModification(loc)) {
            case -1: {
                loc.warningT("Library update failed.");
                break;
            }
            case 1: {
                loc.infoT("Libraries updated");
                break;
            }
        }
        try {
            try {
                String strPath;
                File addLibDir;
                String buildLogDir = this.buildInfo.getDevelopmentComponentInfo().getVariantGenFolder() + "logs";
                File buildLog = new File(buildLogDir);
                if (!buildLog.exists()) {
                    buildLog.mkdirs();
                }
                this.buildLogFile = buildLogDir + File.separator + "build.log";
                String pluginClassname = this.getPluginClassName();
                loc.infoT("Plugin-Classname:" + pluginClassname);
                Object[] loadPathes = this.buildInfo.getDevelopmentComponentInfo().getInfrastructurePathList().toArray();
                int i = 0;
                while (i < loadPathes.length) {
                    addLibDir = new File(loadPathes[i] + IBuildInfo.PLUGIN_LIBS);
                    this.loadPluginLibs(addLibDir);
                    ++i;
                }
                boolean isForkedRequired = this.isForkCompile();
                if (isForkedRequired) {
                    String desiredJdkVersion = this.getDesiredJdkVersion();
                    String jdkHome = this.getJdkHomeForCompiler(desiredJdkVersion);
                    String jdkCompilerPath = this.getCompilerExePath(jdkHome);
                    this.buildInfo.setCompilerExecutable(jdkCompilerPath);
                    loc.infoT("JDK compiler : " + jdkCompilerPath);
                    strPath = jdkHome + File.separator + "lib" + File.separator + "tools.jar";
                } else {
                    strPath = this.getJDKPath();
                }
                if (strPath == null) {
                    this.errMsg = "Error: No -D<version>_HOME=<path> for an allowed version found, compilation will NOT work";
                    this.myMessageBuffer = new StringBuffer(500);
                    this.myMessageBuffer.insert(0, this.lineSep);
                    this.myMessageBuffer.append(this.errMsg);
                    this.myMessageBuffer.append(this.lineSep);
                    this.myLogFile.setErrorMessage(this.myMessageBuffer.toString());
                    this.myLogFile.writeLogFile(this.buildLogFile, false);
                    throw new BuildToolException(this.errMsg);
                }
                addLibDir = new File(strPath);
                this.loadPluginLib(addLibDir);
                this.handlePluginCommunication(pluginClassname);
                loc.infoT("classloading took " + this.jarHandler.getClassLoadingTime() + " ms");
                BuildResult buildResult = this.buildResult;
                Object var13_14 = null;
                this.jarHandler.releaseJars();
                return buildResult;
            }
            catch (BuildToolException e) {
                this.buildResult = new BuildResult(3);
                this.buildResult.setBuildLogPath(this.buildLogFile);
                this.buildResult.setProblemCause(e);
                loc.traceThrowableT(500, this.errMsg, (Throwable)e);
                BuildResult buildResult = this.buildResult;
                Object var13_15 = null;
                this.jarHandler.releaseJars();
                return buildResult;
            }
        }
        catch (Throwable throwable) {
            Object var13_16 = null;
            this.jarHandler.releaseJars();
            throw throwable;
        }
    }

    public String getJDKPath() {
        String jdkPath = null;
        Hashtable<String, String> h = new Hashtable<String, String>();
        Object[] ifrPathes = this.buildInfo.getDevelopmentComponentInfo().getInfrastructurePathList().toArray();
        int i = 0;
        block6: while (i < ifrPathes.length) {
            String path = (String)ifrPathes[i];
            if (path.indexOf(DC_SETTINGS) != -1) {
                String key;
                block14: {
                    File propFile = new File(path + File.separator + JDK_FILE);
                    Properties jdkProps = new Properties();
                    try {
                        if (propFile.exists()) {
                            String entry;
                            FileInputStream in = null;
                            try {
                                in = new FileInputStream(propFile);
                                jdkProps.load(in);
                                Object var11_10 = null;
                                this.closeInputStream(in);
                            }
                            catch (Throwable throwable) {
                                Object var11_11 = null;
                                this.closeInputStream(in);
                                throw throwable;
                            }
                            int j = 1;
                            while ((entry = jdkProps.getProperty(key = JDK_KEY + j)) != null) {
                                loc.infoT("BuildTool allows JDK version: " + entry);
                                String libs = jdkProps.getProperty(entry);
                                libs = Util.replaceSlashWithSeparator((String)libs);
                                h.put(entry, libs);
                                ++j;
                            }
                            break block14;
                        }
                        this.errMsg = "Error: No file .versionsfound. Compilation will not work";
                        this.myMessageBuffer = new StringBuffer(500);
                        this.myMessageBuffer.insert(0, this.lineSep);
                        this.myMessageBuffer.append(this.lineSep);
                        this.myMessageBuffer.append(this.errMsg);
                        this.myMessageBuffer.append(this.lineSep);
                        this.myLogFile.setErrorMessage(this.myMessageBuffer.toString());
                        this.myLogFile.writeLogFile(this.buildLogFile, false);
                        throw new BuildToolException(this.errMsg);
                    }
                    catch (FileNotFoundException fnf) {
                        loc.traceThrowableT(500, "Thrown exception: ", (Throwable)fnf);
                    }
                    catch (IOException ioe) {
                        loc.traceThrowableT(500, "Thrown exception: ", (Throwable)ioe);
                    }
                    catch (BuildToolException bte) {
                        loc.traceThrowableT(500, "Thrown exception: ", (Throwable)bte);
                    }
                }
                Enumeration el = h.keys();
                while (el.hasMoreElements()) {
                    String vmProp;
                    ILocalBuildProperties bprops = this.buildInfo.getDevelopmentComponentInfo().getLocalBuildProperties();
                    String systemJDKProp = bprops.getProperty(vmProp = (key = (String)el.nextElement()) + JDK_SUFFIX);
                    if (systemJDKProp == null) continue;
                    jdkPath = systemJDKProp + File.separator + h.get(key);
                    break block6;
                }
                break;
            }
            ++i;
        }
        if (jdkPath == null) {
            String allowedVersions = "";
            Enumeration el = h.keys();
            while (el.hasMoreElements()) {
                String key = (String)el.nextElement();
                allowedVersions = allowedVersions + key + ", ";
            }
            if (allowedVersions.endsWith(", ")) {
                allowedVersions = allowedVersions.substring(0, allowedVersions.lastIndexOf(", "));
            }
            this.myMessageBuffer = new StringBuffer(500);
            this.myMessageBuffer.insert(0, this.lineSep);
            this.myMessageBuffer.append("BuildTool allows JDK version(s): ");
            this.myMessageBuffer.append(allowedVersions);
            this.myLogFile.setErrorMessage(this.myMessageBuffer.toString());
            this.myLogFile.writeLogFile(this.buildLogFile, true);
        }
        return jdkPath;
    }

    private void closeInputStream(InputStream in) {
        if (in != null) {
            try {
                in.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private boolean isForkCompile() {
        boolean returnValue = false;
        List myList = this.buildInfo.getDevelopmentComponentInfo().getCurrentBuildVariant().getBuildOptionNames();
        if (myList == null) {
            return false;
        }
        Iterator iter2 = myList.iterator();
        while (iter2.hasNext()) {
            String forkCompile;
            Iterator iter3;
            String prop2key = (String)iter2.next();
            if (!prop2key.equals(ANT_FORK_COMPILE) || !(iter3 = this.buildInfo.getDevelopmentComponentInfo().getCurrentBuildVariant().getBuildOptionValues(ANT_FORK_COMPILE).iterator()).hasNext() || !(forkCompile = (String)iter3.next()).equalsIgnoreCase("true") && !forkCompile.equalsIgnoreCase("yes") && !forkCompile.equalsIgnoreCase("on")) continue;
            returnValue = true;
        }
        return returnValue;
    }

    private String getDesiredJdkVersion() {
        String desiredJdkVersion = DEFAULT_JDK;
        List myList = this.buildInfo.getDevelopmentComponentInfo().getCurrentBuildVariant().getBuildOptionNames();
        Iterator iter2 = myList.iterator();
        while (iter2.hasNext()) {
            Iterator iter3;
            String prop2key = (String)iter2.next();
            if (!prop2key.equals(ANT_JDK_VERSION) || !(iter3 = this.buildInfo.getDevelopmentComponentInfo().getCurrentBuildVariant().getBuildOptionValues(ANT_JDK_VERSION).iterator()).hasNext()) continue;
            desiredJdkVersion = (String)iter3.next();
        }
        return desiredJdkVersion;
    }

    private String getJdkHomeForCompiler(String desiredJdkVersion) throws BuildToolException {
        String javaHome;
        String jdkHomePath = null;
        if (desiredJdkVersion != null) {
            String soughtKey = JDK_PREFIX + desiredJdkVersion + JDK_SUFFIX;
            try {
                jdkHomePath = this.buildInfo.getDevelopmentComponentInfo().getLocalBuildProperties().getProperty(soughtKey);
            }
            catch (IllegalArgumentException ex) {
                String message = "jdk home not found for " + desiredJdkVersion;
                if (desiredJdkVersion != DEFAULT_JDK) {
                    throw new BuildToolException(message);
                }
                loc.infoT(message + " will default to running VM");
            }
        }
        if (jdkHomePath == null && (javaHome = System.getProperty("java.home")) != null) {
            File javaHomeFile = new File(javaHome);
            if (javaHome.endsWith("jre")) {
                jdkHomePath = javaHomeFile.getParent();
            }
            loc.infoT("no JDK specified , defaulting to " + jdkHomePath);
        }
        return jdkHomePath;
    }

    private String getCompilerExePath(String jdkHomePath) {
        String osName;
        String returnValue = null;
        if (jdkHomePath != null) {
            returnValue = jdkHomePath + File.separator + "bin" + File.separator + "javac";
        }
        if ((osName = System.getProperty("os.name").toLowerCase(Locale.US)).startsWith("windows")) {
            returnValue = returnValue + ".exe";
        }
        return returnValue;
    }

    public String getPluginClassName() throws IllegalPluginDescriptorException {
        this.descriptorProperties = new Properties();
        BufferedInputStream inStream = null;
        try {
            try {
                FileInputStream in = new FileInputStream(new File(this.pluginRoot, DESCRIPTOR_NAME));
                inStream = new BufferedInputStream(in);
                this.descriptorProperties.load(inStream);
            }
            catch (IOException e) {
                this.errMsg = "ERROR: Exception occurred while trying to read the BuildPlugin name from " + this.pluginRoot.getAbsolutePath() + File.separatorChar + DESCRIPTOR_NAME;
                loc.traceThrowableT(500, this.errMsg, (Throwable)e);
                throw new IllegalPluginDescriptorException(this.errMsg);
            }
            Object var4_4 = null;
            this.closeInputStream(inStream);
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            this.closeInputStream(inStream);
            throw throwable;
        }
        return this.descriptorProperties.getProperty(PLUGIN_CLASSNAME);
    }

    private void loadPluginLibs(File pluginLibdir) throws BuildToolException {
        String archivesNames = "";
        try {
            FilenameFilter ff = new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    String suffix = ".jar";
                    if (name.length() > suffix.length()) {
                        return name.substring(name.length() - suffix.length()).equalsIgnoreCase(suffix);
                    }
                    return false;
                }
            };
            loc.infoT("load libraries in " + pluginLibdir.getAbsolutePath());
            File[] libDirElements = pluginLibdir.listFiles(ff);
            if (libDirElements != null) {
                int i = 0;
                while (i < libDirElements.length) {
                    if (!libDirElements[i].isDirectory()) {
                        archivesNames = archivesNames + libDirElements[i].getName() + " ";
                        this.jarHandler.addJarPath(libDirElements[i]);
                    }
                    ++i;
                }
                loc.infoT("add archives: " + archivesNames);
            }
        }
        catch (ClassNotFoundException e) {
            String msg = "error during loading plugin libraries";
            loc.traceThrowableT(500, msg, (Throwable)e);
            throw new PluginLoadException(pluginLibdir.getName(), e);
        }
    }

    private void loadPluginLib(File pluginLib) throws BuildToolException {
        try {
            if (!pluginLib.exists()) {
                this.errMsg = "Error: File " + pluginLib.getAbsolutePath() + " doesn't exist";
                this.myMessageBuffer = new StringBuffer(500);
                this.myMessageBuffer.insert(0, this.lineSep);
                this.myMessageBuffer.append(this.errMsg);
                this.myMessageBuffer.append(this.lineSep);
                this.myLogFile.setErrorMessage(this.myMessageBuffer.toString());
                this.myLogFile.writeLogFile(this.buildLogFile, false);
                throw new BuildToolException(this.errMsg);
            }
            loc.infoT("load single lib " + pluginLib.getAbsolutePath());
            this.jarHandler.addJarPath(pluginLib);
        }
        catch (ClassNotFoundException e) {
            throw new PluginLoadException(pluginLib.getName(), e);
        }
    }

    private IBuildPlugin getBuildPluginInstance(String pluginClassname) throws PluginInstantiateException {
        IBuildPlugin buildPlugin;
        try {
            loc.infoT("instantiating Class " + pluginClassname);
            Class buildPluginClass = this.jarHandler.loadClass(pluginClassname);
            buildPlugin = (IBuildPlugin)buildPluginClass.newInstance();
        }
        catch (Exception e) {
            throw new PluginInstantiateException(pluginClassname, e);
        }
        return buildPlugin;
    }

    private void handlePluginCommunication(String pluginClassname) throws BuildToolException {
        IBuildPlugin buildPlugin = this.getBuildPluginInstance(pluginClassname);
        loc.infoT("plugin Name  : " + buildPlugin.getName());
        BuildActionSequence buildActionSequence = buildPlugin.getBuildActions(this.buildInfo);
        buildActionSequence.add(buildActionSequence.size(), new PackageChecker(this.buildInfo));
        ListIterator li = ((AbstractList)buildActionSequence).listIterator();
        loc.infoT("number of Actions: " + buildActionSequence.size());
        this.prepareSession();
        while (li.hasNext()) {
            IBuildAction buildAction = (IBuildAction)li.next();
            loc.infoT("executing Action " + buildAction);
            buildAction.execute();
            if (this.handleActionResult(buildAction.getBuildActionResult(), buildAction.getBuildActionSeverity()) != 1) continue;
            loc.infoT("error: build stopped");
            this.disposeSession();
            return;
        }
        this.disposeSession();
    }

    private void prepareSession() {
        try {
            Class c = this.jarHandler.loadClass("com.sap.tc.buildplugin.BuildSessionManager");
            if (c != null) {
                Method declaredMethod = c.getDeclaredMethod("createSession", new Class[0]);
                Object o = declaredMethod.invoke(null, new Object[0]);
                Method setter = o.getClass().getDeclaredMethod("set", class$java$lang$String == null ? (class$java$lang$String = PluginHandler.class$("java.lang.String")) : class$java$lang$String, class$java$lang$Object == null ? (class$java$lang$Object = PluginHandler.class$("java.lang.Object")) : class$java$lang$Object);
                setter.invoke(o, "BuildInfo", this.buildInfo);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private void disposeSession() {
        try {
            Class c = this.jarHandler.loadClass("com.sap.tc.buildplugin.BuildSessionManager");
            Method declaredMethod = c.getDeclaredMethod("disposeSession", new Class[0]);
            declaredMethod.invoke(null, new Object[0]);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    private int handleActionResult(BuildActionResult buildActionResult, BuildActionSeverity buildActionSeverity) {
        this.buildResult.evaluateBuildActionResult(buildActionResult);
        int buildstatus = 0;
        switch (buildActionResult.getBuildActionRC()) {
            case 0: {
                loc.infoT("Build Action finished successfully");
                break;
            }
            case 1: {
                loc.infoT("warning: Build Action finished successfully with warnings");
                break;
            }
            case 2: {
                if (buildActionSeverity.getSeverity() != 0) break;
                buildstatus = 1;
                loc.infoT("error: Build Action terminated with errors");
                break;
            }
            case 3: {
                if (buildActionSeverity.getSeverity() != 0) break;
                buildstatus = 1;
                loc.infoT("error: Build Action terminated with system errors");
            }
        }
        return buildstatus;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

