/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildtool;

import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

class PluginClassLoader
extends ClassLoader {
    private List jarFiles;
    private Map jarCache;
    private AccessControlContext accessControlContext;
    private Location loc = Location.getLocation((Class)(class$com$sap$tc$buildtool$PluginClassLoader == null ? (class$com$sap$tc$buildtool$PluginClassLoader = PluginClassLoader.class$("com.sap.tc.buildtool.PluginClassLoader")) : class$com$sap$tc$buildtool$PluginClassLoader));
    private long timeElapsed;
    static /* synthetic */ Class class$com$sap$tc$buildtool$PluginClassLoader;

    public PluginClassLoader(ClassLoader parentClassLoader) {
        super(parentClassLoader);
        this.jarFiles = new ArrayList();
        this.jarCache = new HashMap();
        this.accessControlContext = AccessController.getContext();
    }

    public String identity() {
        return super.toString();
    }

    void resetTimer() {
        this.timeElapsed = 0L;
    }

    public void addClassSource(File jarfile) {
        if (jarfile != null) {
            List list = this.jarFiles;
            synchronized (list) {
                this.jarFiles.add(jarfile);
            }
        }
    }

    public byte[] getClassDefinition(String name) throws ClassNotFoundException {
        List list = this.jarFiles;
        synchronized (list) {
            String fileName = name.replace('.', '/') + ".class";
            Iterator iter = this.jarFiles.iterator();
            while (iter.hasNext()) {
                File jarfile = (File)iter.next();
                byte[] classDefinition = this.load(jarfile, fileName);
                if (classDefinition == null) continue;
                byte[] byArray = classDefinition;
                return byArray;
            }
            StringBuffer error = new StringBuffer(1000);
            error.append("No class ");
            error.append(name);
            error.append(" in ");
            iter = this.jarFiles.iterator();
            while (iter.hasNext()) {
                File jarFile = (File)iter.next();
                error.append(jarFile.getPath());
                if (!iter.hasNext()) continue;
                error.append(';');
            }
            throw new ClassNotFoundException(error.toString());
        }
    }

    private byte[] load(File jarfile, String name) {
        if (this.jarContains(jarfile, name)) {
            try {
                if (this.loc.beDebug()) {
                    this.loc.debugT("Loading " + name + " from " + jarfile.getAbsolutePath());
                }
                return this.loadContent(jarfile, name);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    private byte[] loadContent(File jarfile, String name) throws IOException {
        ZipEntry zipentry;
        CacheEntry entry = this.getCacheEntry(jarfile);
        if (entry != null && (zipentry = entry.jarFile.getEntry(name)) != null) {
            return this.loadEntryContent(entry.jarFile, zipentry);
        }
        return null;
    }

    private boolean jarContains(File jarfile, String fileName) {
        CacheEntry entry = this.getCacheEntry(jarfile);
        if (entry != null) {
            return entry.nameSet.contains(fileName);
        }
        return false;
    }

    private CacheEntry getCacheEntry(File jarfile) {
        CacheEntry entry = (CacheEntry)this.jarCache.get(jarfile);
        if (entry == null) {
            JarFile jf;
            try {
                jf = new JarFile(jarfile);
            }
            catch (IOException e) {
                return null;
            }
            HashSet<String> nameset = new HashSet<String>();
            Enumeration<JarEntry> enumeration = jf.entries();
            while (enumeration.hasMoreElements()) {
                ZipEntry zentry = enumeration.nextElement();
                nameset.add(zentry.getName());
            }
            entry = new CacheEntry(jf, nameset);
            this.jarCache.put(jarfile, entry);
        } else if (entry.jarFile == null) {
            try {
                entry.jarFile = new JarFile(jarfile);
            }
            catch (IOException e) {
                return null;
            }
        }
        return entry;
    }

    void releaseJars() {
        Iterator iterator = this.jarCache.values().iterator();
        while (iterator.hasNext()) {
            CacheEntry entry = (CacheEntry)iterator.next();
            entry.releaseJar();
        }
        this.jarCache.clear();
    }

    /*
     * WARNING - void declaration
     */
    private byte[] loadEntryContent(JarFile jarFile, ZipEntry jarEntry) throws IOException {
        int size = (int)jarEntry.getSize();
        if (size == -1) {
            ByteArrayOutputStream baos = new ByteArrayOutputStream(24576);
            byte[] buffer = new byte[4096];
            InputStream in = jarFile.getInputStream(jarEntry);
            try {
                int n;
                while ((n = in.read(buffer, 0, buffer.length)) > 0) {
                    void var7_10;
                    baos.write(buffer, 0, (int)var7_10);
                }
                Object var9_12 = null;
            }
            catch (Throwable throwable) {
                Object var9_13 = null;
                in.close();
                throw throwable;
            }
            in.close();
            return baos.toByteArray();
        }
        byte[] content = new byte[size];
        InputStream in = jarFile.getInputStream(jarEntry);
        try {
            int offset = 0;
            while (offset < size) {
                int l = in.read(content, offset, size - offset);
                offset += l;
            }
            Object var11_15 = null;
        }
        catch (Throwable throwable) {
            Object var11_16 = null;
            in.close();
            throw throwable;
        }
        in.close();
        return content;
    }

    public long getTimeElapsed() {
        return this.timeElapsed;
    }

    protected Class findClass(final String name) throws ClassNotFoundException {
        try {
            List list = this.jarFiles;
            synchronized (list) {
                long t0 = System.currentTimeMillis();
                Class result = (Class)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() throws ClassNotFoundException {
                        byte[] classDefinition = PluginClassLoader.this.getClassDefinition(name);
                        return PluginClassLoader.super.defineClass(name, classDefinition, 0, classDefinition.length);
                    }
                }, this.accessControlContext);
                this.timeElapsed += System.currentTimeMillis() - t0;
                Class clazz = result;
                return clazz;
            }
        }
        catch (PrivilegedActionException exception) {
            throw new ClassNotFoundException(exception.getException().getMessage());
        }
    }

    protected String findLibrary(String libname) {
        return null;
    }

    public URL getResourceLocation(String name) {
        List list = this.jarFiles;
        synchronized (list) {
            URL resourceLocation = null;
            Iterator iter = this.jarFiles.iterator();
            while (iter.hasNext() && resourceLocation == null) {
                File jar = (File)iter.next();
                resourceLocation = this.getResourceLocation(jar, name);
                if (resourceLocation == null) continue;
                URL uRL = resourceLocation;
                return uRL;
            }
            URL uRL = resourceLocation;
            return uRL;
        }
    }

    private URL getResourceLocation(File jarfile, String name) {
        while (name.startsWith("/")) {
            name = name.substring(1);
        }
        if (this.jarContains(jarfile, name)) {
            try {
                URL url = new URL("jar:" + jarfile.toURL() + "!/" + name);
                if (this.loc.beDebug()) {
                    this.loc.debugT("URL for resource " + name + ":" + url.toString());
                }
                return url;
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        return null;
    }

    protected URL findResource(final String name) {
        try {
            if (this.loc.beDebug()) {
                this.loc.debugT("Looking for resource " + name);
            }
            List list = this.jarFiles;
            synchronized (list) {
                URL uRL = (URL)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                    public Object run() {
                        return PluginClassLoader.this.getResourceLocation(name);
                    }
                }, this.accessControlContext);
                return uRL;
            }
        }
        catch (PrivilegedActionException exception) {
            return null;
        }
    }

    protected Enumeration findResources(String name) {
        List list = this.jarFiles;
        synchronized (list) {
            Vector<URL> l = new Vector<URL>();
            URL url = this.findResource(name);
            if (url != null) {
                l.add(url);
            }
            Enumeration enumeration = l.elements();
            return enumeration;
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class CacheEntry {
        JarFile jarFile;
        Set nameSet;

        public CacheEntry(JarFile jarFile, Set nameSet) {
            this.jarFile = jarFile;
            this.nameSet = nameSet;
        }

        public void releaseJar() {
            if (this.jarFile != null) {
                try {
                    this.jarFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.jarFile = null;
            }
        }
    }
}

