/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildtool;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.BuildActionSeverity;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildtool.LogFile;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public class PackageChecker
implements IBuildAction {
    private static int ESTIMATED_MESSAGE_SIZE = 500;
    private static Location loc = Location.getLocation((Class)(class$com$sap$tc$buildtool$PackageChecker == null ? (class$com$sap$tc$buildtool$PackageChecker = PackageChecker.class$("com.sap.tc.buildtool.PackageChecker")) : class$com$sap$tc$buildtool$PackageChecker));
    private IDevelopmentComponentInfo myDevelopmentComponentInfo;
    private BuildActionResult result;
    private BuildActionSeverity severity;
    private String logFilePath;
    static /* synthetic */ Class class$com$sap$tc$buildtool$PackageChecker;

    public PackageChecker(IBuildInfo theInfo) {
        this.myDevelopmentComponentInfo = theInfo.getDevelopmentComponentInfo();
        this.result = new BuildActionResult();
        this.logFilePath = this.myDevelopmentComponentInfo.getVariantGenFolder() + "logs" + File.separator + "build.log";
        this.result.setBuildLogPath(this.logFilePath);
        this.severity = new BuildActionSeverity();
        this.severity.setStopOnError();
    }

    public String[] listSourcePackages() {
        String basePath;
        String thisMethod = "listSourcePackages()";
        ArrayList sourcePackages = new ArrayList();
        DevelopmentComponent myComponent = this.myDevelopmentComponentInfo.getCurrentComponent();
        if (myComponent == null) {
            if (loc.beDebug()) {
                loc.debugT(thisMethod, "null component");
            }
            return new String[0];
        }
        if (loc.beDebug()) {
            loc.debugT(thisMethod, "searching source packages for DC {0}", new Object[]{myComponent.getName()});
        }
        if ((basePath = this.myDevelopmentComponentInfo.getComponentRootFolder()) == null) {
            if (loc.beDebug()) {
                loc.debugT(thisMethod, "null basepath");
            }
            return new String[0];
        }
        List myList = myComponent.getPackageFolders();
        if (myList == null) {
            if (loc.beDebug()) {
                loc.debugT(thisMethod, "null source folders");
            }
            return new String[0];
        }
        Iterator iter = myList.iterator();
        while (iter.hasNext()) {
            String thePath = (String)iter.next();
            if (loc.beDebug()) {
                loc.debugT(thisMethod, "searching source packages for DC {0} source folder {1}", new Object[]{myComponent.getName(), thePath});
            }
            File theFile = new File(basePath, thePath);
            this.processSourcePath(theFile, "", sourcePackages);
        }
        String[] returnStrings = new String[sourcePackages.size()];
        System.arraycopy(sourcePackages.toArray(), 0, returnStrings, 0, sourcePackages.size());
        return returnStrings;
    }

    public String[] listUnreservedPackages() {
        String thisMethod = "listUnreservedPackages";
        if (loc.beDebug()) {
            loc.debugT(thisMethod, "listing unreserved packages");
        }
        String[] allPackages = this.listSourcePackages();
        String[] reservedPackages = this.myDevelopmentComponentInfo.getReservedPackageNames();
        ArrayList<String> myList = new ArrayList<String>();
        int icounter = 0;
        while (icounter < allPackages.length) {
            boolean found = false;
            String soughtString = allPackages[icounter];
            int icounter2 = 0;
            while (icounter2 < reservedPackages.length) {
                String myString = reservedPackages[icounter2];
                if (myString != null && soughtString != null && myString.equals(soughtString)) {
                    found = true;
                    break;
                }
                ++icounter2;
            }
            if (!found) {
                myList.add(soughtString);
            }
            ++icounter;
        }
        String[] returnStrings = new String[myList.size()];
        System.arraycopy(myList.toArray(), 0, returnStrings, 0, myList.size());
        return returnStrings;
    }

    private void processSourcePath(File aFile, String relPath, List sourcePackages) {
        String thisMethod = "processSourcePath()";
        if (loc.beDebug()) {
            loc.debugT(thisMethod, "inspecting path {0} package {1}", new Object[]{aFile, relPath});
        }
        String[] theFiles = aFile.list();
        boolean processed = false;
        if (theFiles == null) {
            return;
        }
        if (theFiles.length == 0) {
            return;
        }
        int acounter = 0;
        while (acounter < theFiles.length) {
            File testFile = new File(aFile, theFiles[acounter]);
            if (!processed && theFiles[acounter].endsWith(".java")) {
                if (testFile.isFile() && !sourcePackages.contains(relPath)) {
                    if (!relPath.equals("")) {
                        sourcePackages.add(relPath);
                    }
                    processed = true;
                }
            } else if (testFile.isDirectory()) {
                String newPath = null;
                newPath = relPath.equals("") ? theFiles[acounter] : relPath + "." + theFiles[acounter];
                this.processSourcePath(testFile, newPath, sourcePackages);
            }
            ++acounter;
        }
    }

    public BuildActionResult execute() {
        if (!this.myDevelopmentComponentInfo.isNameReservationCheckRequired()) {
            this.result.setBuildActionRC(0);
            return this.result;
        }
        String[] unreservedPackages = this.listUnreservedPackages();
        if (unreservedPackages.length != 0) {
            StringBuffer myMessageBuffer = new StringBuffer(ESTIMATED_MESSAGE_SIZE);
            String lineSep = System.getProperty("line.separator");
            if (unreservedPackages.length == 1) {
                myMessageBuffer.append("Package ");
            } else {
                myMessageBuffer.append("Packages ");
            }
            int icounter = 0;
            while (icounter < unreservedPackages.length) {
                myMessageBuffer.append(unreservedPackages[icounter]);
                myMessageBuffer.append(" ");
                ++icounter;
            }
            if (unreservedPackages.length == 1) {
                myMessageBuffer.append("is ");
            } else {
                myMessageBuffer.append("are ");
            }
            myMessageBuffer.append("not reserved for DC : ");
            myMessageBuffer.append(this.myDevelopmentComponentInfo.getCurrentComponent().getName());
            myMessageBuffer.append(".");
            myMessageBuffer.append(lineSep);
            loc.infoT(myMessageBuffer.toString());
            LogFile myLogFile = new LogFile();
            myLogFile.setErrorMessage(myMessageBuffer.toString());
            myLogFile.writeLogFile(this.logFilePath, true);
            this.result.setBuildResultMessage(myMessageBuffer.toString());
            this.result.setBuildActionRC(1);
        } else {
            this.result.setBuildActionRC(0);
        }
        return this.result;
    }

    public BuildActionResult getBuildActionResult() {
        return this.result;
    }

    public BuildActionSeverity getBuildActionSeverity() {
        return this.severity;
    }

    public String getCaption() {
        return "PackageChecker";
    }

    public void setBuildActionSeverity(BuildActionSeverity buildActionSeverity) {
        this.severity = buildActionSeverity;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

