/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildtool;

import com.sap.tc.buildplugin.api.IJarHandler;
import com.sap.tc.buildtool.PluginClassLoader;
import com.sap.tc.logging.Location;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;

public class JarHandler
implements IJarHandler {
    HashSet pathSet = new HashSet();
    private Map knownFiles = new HashMap();
    private PluginClassLoader pluginLoader = new PluginClassLoader(this.getClass().getClassLoader());

    public int checkFileModification(Location loc) {
        loc.infoT("enter checkFileModification");
        int result = 0;
        if (Boolean.getBoolean("pluginHandler.reloadlibraries")) {
            Entry entry;
            boolean modified = false;
            Iterator files = this.knownFiles.values().iterator();
            while (files.hasNext()) {
                entry = (Entry)files.next();
                if (entry.isUpToDate()) continue;
                modified = true;
                loc.infoT("Library not up to date: " + entry.file.getPath());
            }
            if (modified) {
                this.reinit();
                result = 1;
                files = this.knownFiles.values().iterator();
                while (files.hasNext()) {
                    entry = (Entry)files.next();
                    entry.update();
                }
            } else {
                loc.infoT("Libraries up to date.");
            }
        }
        loc.infoT("exit checkFileModification");
        return result;
    }

    public void prepareExecution() {
        this.pluginLoader.resetTimer();
    }

    public void releaseJars() {
        this.pluginLoader.releaseJars();
    }

    void reinit() {
        PluginClassLoader loader = new PluginClassLoader(this.getClass().getClassLoader());
        Iterator files = this.knownFiles.values().iterator();
        while (files.hasNext()) {
            Entry entry = (Entry)files.next();
            loader.addClassSource(entry.file);
        }
        this.pluginLoader = loader;
    }

    public void addJarPath(File f) throws ClassNotFoundException {
        String name = f.getPath();
        if (!this.knownFiles.containsKey(name)) {
            Entry e = new Entry(f);
            this.pluginLoader.addClassSource(e.file);
            this.knownFiles.put(name, e);
        }
    }

    public Class loadClass(String className) throws ClassNotFoundException {
        return this.pluginLoader.loadClass(className);
    }

    public long getClassLoadingTime() {
        return this.pluginLoader.getTimeElapsed();
    }

    private static class Entry {
        File file;
        long timestamp;
        transient long newTimestamp;

        public Entry(File file) {
            this.file = file;
            this.timestamp = file.lastModified();
        }

        public boolean isUpToDate() {
            this.newTimestamp = this.file.lastModified();
            return this.newTimestamp == this.timestamp;
        }

        public void update() {
            if (this.newTimestamp != 0L) {
                this.timestamp = this.newTimestamp;
                this.newTimestamp = 0L;
            }
        }
    }
}

