/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildtool;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildtool.IBuildResult;
import java.io.PrintWriter;
import java.io.StringWriter;

public class BuildResult
implements IBuildResult {
    private int resultCode = 0;
    private String resultMessage = IBuildResult.buildMsg[0];
    private String buildLogPath;
    private Throwable problemCause;

    public BuildResult(int _resultCode) {
        this.resultCode = _resultCode;
        this.resultMessage = IBuildResult.buildMsg[_resultCode];
    }

    public int getResultCode() {
        return this.resultCode;
    }

    private void setResultCode(int resultCode) {
        this.resultCode = resultCode;
    }

    public Throwable getProblemCause() {
        return this.problemCause;
    }

    public void setProblemCause(Throwable problemCause) {
        this.problemCause = problemCause;
    }

    public void evaluateBuildActionResult(BuildActionResult buildActionResult) {
        int rc = buildActionResult.getBuildActionRC();
        if (buildActionResult.getBuildLogPath() != null) {
            this.buildLogPath = buildActionResult.getBuildLogPath();
        }
        if (this.resultCode < rc) {
            this.setResultCode(rc);
            this.setResultMessage(buildActionResult.getBuildResultMessage() + "\n" + IBuildResult.buildMsg[rc]);
        }
    }

    public String getResultMessage() {
        if (this.problemCause != null) {
            return this.resultMessage + "\n" + this.getStackTrace(this.problemCause);
        }
        return this.resultMessage;
    }

    private String getStackTrace(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        pw.close();
        return sw.toString();
    }

    private void setResultMessage(String resultMessage) {
        this.resultMessage = resultMessage;
    }

    public void setBuildLogPath(String path) {
        this.buildLogPath = path;
    }

    public String getBuildLogPath() {
        return this.buildLogPath;
    }
}

