/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.update.hierarchy;

import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelChangeEvent;
import com.tssap.selena.model.elements.ModelChangeListener;
import com.tssap.selena.model.elements.ModelDeltaNode;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.update.diagram.DiagramFactory;
import com.tssap.selena.model.update.diagram.IDiagram;
import com.tssap.selena.model.update.hierarchy.DiagramViewFactory;
import com.tssap.selena.model.util.Assert;
import com.tssap.selena.model.util.delta.RootModelDeltaNode;
import com.tssap.selena.model.view.View;
import com.tssap.selena.model.view.ViewAccess;
import java.util.Enumeration;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;

public class SingleDiagramUpdater
implements View {
    private boolean isClosing = false;
    private ReferenceCollection myCollection;
    private IDiagram myDiagram;
    private DiagramViewFactory myModelViewFactory;
    private Closer myCloser;
    private String myType;
    static /* synthetic */ Class class$com$tssap$selena$model$update$diagram$IDiagram;

    public SingleDiagramUpdater(String type, ReferenceCollection collection, DiagramViewFactory factory, IProgressMonitor pm) {
        this.myType = type;
        this.myModelViewFactory = factory;
        this.myCollection = collection;
        this.myCloser = new Closer();
        this.createDiagram(pm);
        this.initDiagram(pm);
    }

    public void update(ModelDeltaNode delta) {
        Assert.isLegal((boolean)delta.getElementUniqueName().equals(this.myCollection.getUniqueName()), (String)("diagram updater received delta from another collection \n updater: " + this.myCollection.getUniqueName() + "\n delta:" + delta.getElementUniqueName()));
        this.myDiagram.modelChanged(delta);
    }

    public void totalUpdate() {
        RootModelDeltaNode totalUpdate = new RootModelDeltaNode(this.myCollection.getModel());
        totalUpdate.makeTotallyChanged();
        this.update((ModelDeltaNode)totalUpdate);
    }

    public String getType() {
        return this.myType;
    }

    private void createDiagram(IProgressMonitor pm) {
        this.myDiagram = DiagramFactory.createDiagram(this, pm);
    }

    public void reactivateDiagram() {
        this.myDiagram.reactivate();
    }

    private void initDiagram(IProgressMonitor pm) {
    }

    private void totalDiagramUpdate() {
        if (Boolean.TRUE.booleanValue()) {
            throw new RuntimeException("bug in initDiagram");
        }
    }

    public void dispose() {
        this.shutDown();
    }

    public void shutDown() {
        if (this.isClosing) {
            return;
        }
        this.isClosing = true;
        if (this.myCloser != null) {
            this.myCloser.dispose();
            this.myCloser = null;
        }
        this.myDiagram.closeView();
        this.myModelViewFactory.stopListening(this);
        ViewAccess.getViewManager((UniqueName)this.myCollection.getModel().getUniqueName()).disposeView((View)this);
        this.isClosing = false;
        this.myDiagram = null;
        this.myModelViewFactory = null;
        this.myCollection = null;
    }

    public UniqueName getModelUin() {
        return this.getModel().getUniqueName();
    }

    private Model getModel() {
        return this.myCollection.getModel();
    }

    public ReferenceCollection getReferenceCollection() {
        return this.myCollection;
    }

    public Object getService(Class clazz) {
        if ((class$com$tssap$selena$model$update$diagram$IDiagram == null ? (class$com$tssap$selena$model$update$diagram$IDiagram = SingleDiagramUpdater.class$("com.tssap.selena.model.update.diagram.IDiagram")) : class$com$tssap$selena$model$update$diagram$IDiagram).isAssignableFrom(clazz)) {
            return this.getDiagram();
        }
        return null;
    }

    public IDiagram getDiagram() {
        return this.myDiagram;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private class Closer
    implements ModelChangeListener {
        private HashSet myDiagramParents;

        public Closer() {
            this.initParentChain();
            SingleDiagramUpdater.this.getModel().addModelDeltaListener((ModelChangeListener)this);
        }

        public void modelChanged(ModelChangeEvent changeEvent) {
            ModelDeltaNode rootNode = changeEvent.getRootDelta();
            if (rootNode == null || rootNode.isEmpty()) {
                return;
            }
            if (this.isParentDeleted(rootNode)) {
                ViewAccess.getViewManager((UniqueName)SingleDiagramUpdater.this.myCollection.getModel().getUniqueName()).disposeView((View)SingleDiagramUpdater.this);
            }
        }

        private void dispose() {
            SingleDiagramUpdater.this.getModel().removeModelDeltaListener((ModelChangeListener)this);
            this.myDiagramParents = null;
        }

        private boolean isParentDeleted(ModelDeltaNode node) {
            if (node.isDeleted()) {
                return this.getDiagramParents().contains(node.getElementUniqueName());
            }
            boolean result = false;
            Enumeration subNodes = node.changedChildren();
            while (!result && subNodes.hasMoreElements()) {
                result = this.isParentDeleted((ModelDeltaNode)subNodes.nextElement());
            }
            return result;
        }

        private HashSet getDiagramParents() {
            return this.myDiagramParents;
        }

        private void initParentChain() {
            this.myDiagramParents = new HashSet();
            ReferenceCollection cur = SingleDiagramUpdater.this.getReferenceCollection();
            while (cur != null && !this.myDiagramParents.contains(cur.getUniqueName())) {
                this.myDiagramParents.add(cur.getUniqueName());
                cur = cur.getParent();
            }
        }
    }
}

